/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.HashGenerator;
import com.facebook.presto.operator.InterpretedHashGenerator;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.type.Type;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class MergeHashSort {
    private MergeHashSort() {
    }

    public static Iterator<Page> merge(List<Type> keyTypes, List<Type> allTypes, List<Iterator<Page>> channels) {
        List channelIterators = channels.stream().map(SingleChannelPagePositions::new).collect(Collectors.toList());
        int[] hashChannels = new int[keyTypes.size()];
        for (int i = 0; i < keyTypes.size(); ++i) {
            hashChannels[i] = i;
        }
        InterpretedHashGenerator hashGenerator = new InterpretedHashGenerator(keyTypes, hashChannels);
        return new PageRewriteIterator(hashGenerator, allTypes, (Iterator<PagePosition>)Iterators.mergeSorted(channelIterators, (left, right) -> MergeHashSort.comparePages(hashGenerator, left, right)));
    }

    private static int comparePages(HashGenerator hashGenerator, PagePosition left, PagePosition right) {
        if (left.isPositionOutOfPage() && right.isPositionOutOfPage()) {
            return 0;
        }
        if (left.isPositionOutOfPage()) {
            return -1;
        }
        if (right.isPositionOutOfPage()) {
            return 1;
        }
        long leftHash = hashGenerator.hashPosition(left.getPosition(), left.getPage());
        long rightHash = hashGenerator.hashPosition(right.getPosition(), right.getPage());
        return Long.compare(leftHash, rightHash);
    }

    public static class PageRewriteIterator
    implements Iterator<Page> {
        private final List<Type> allTypes;
        private final Iterator<PagePosition> pagePositions;
        private final HashGenerator hashGenerator;
        private final PageBuilder builder;
        private PagePosition currentPage = null;

        public PageRewriteIterator(HashGenerator hashGenerator, List<Type> allTypes, Iterator<PagePosition> pagePositions) {
            this.hashGenerator = hashGenerator;
            this.allTypes = allTypes;
            this.pagePositions = pagePositions;
            this.builder = new PageBuilder(allTypes);
        }

        @Override
        public boolean hasNext() {
            return this.currentPage != null || this.pagePositions.hasNext();
        }

        @Override
        public Page next() {
            this.builder.reset();
            if (this.currentPage == null) {
                this.currentPage = this.pagePositions.next();
            }
            PagePosition previousPage = this.currentPage;
            while (MergeHashSort.comparePages(this.hashGenerator, this.currentPage, previousPage) == 0 || !this.builder.isFull()) {
                if (!this.currentPage.isPositionOutOfPage()) {
                    this.builder.declarePosition();
                    for (int column = 0; column < this.allTypes.size(); ++column) {
                        Type type = this.allTypes.get(column);
                        type.appendTo(this.currentPage.getPage().getBlock(column), this.currentPage.getPosition(), this.builder.getBlockBuilder(column));
                    }
                    previousPage = this.currentPage;
                }
                if (this.pagePositions.hasNext()) {
                    this.currentPage = this.pagePositions.next();
                    continue;
                }
                this.currentPage = null;
                break;
            }
            return this.builder.build();
        }
    }

    public static class SingleChannelPagePositions
    implements PagePositions {
        private final Iterator<Page> channel;
        private PagePosition current;

        public SingleChannelPagePositions(Iterator<Page> channel) {
            this.channel = Objects.requireNonNull(channel, "channel is null");
        }

        @Override
        public boolean hasNext() {
            return this.channel.hasNext() || this.current != null && this.current.getPosition() + 1 < this.current.getPage().getPositionCount();
        }

        @Override
        public PagePosition next() {
            this.current = this.current == null || this.current.getPosition() + 1 >= this.current.getPage().getPositionCount() ? new PagePosition(this.channel.next(), 0) : new PagePosition(this.current.getPage(), this.current.getPosition() + 1);
            return this.current;
        }
    }

    public static interface PagePositions
    extends Iterator<PagePosition> {
    }

    public static class PagePosition {
        private final Page page;
        private final int position;

        public PagePosition(Page page, int position) {
            this.page = Objects.requireNonNull(page, "page is null");
            this.position = Objects.requireNonNull(Integer.valueOf(position), "position is null");
        }

        public Page getPage() {
            return this.page;
        }

        public int getPosition() {
            return this.position;
        }

        public boolean isPositionOutOfPage() {
            return this.position >= this.page.getPositionCount();
        }
    }
}

