/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.PageProcessor;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public class FilterAndProjectOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final List<Type> types;
    private final PageBuilder pageBuilder;
    private final PageProcessor processor;
    private final String processingOptimization;
    private Page currentPage;
    private int currentPosition;
    private boolean finishing;

    public FilterAndProjectOperator(OperatorContext operatorContext, Iterable<? extends Type> types, PageProcessor processor) {
        this.processor = Objects.requireNonNull(processor, "processor is null");
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.types = ImmutableList.copyOf(Objects.requireNonNull(types, "types is null"));
        this.processingOptimization = SystemSessionProperties.getProcessingOptimization(operatorContext.getSession());
        this.pageBuilder = new PageBuilder(this.getTypes());
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public final List<Type> getTypes() {
        return this.types;
    }

    @Override
    public final void finish() {
        this.finishing = true;
    }

    @Override
    public final boolean isFinished() {
        return this.finishing && this.pageBuilder.isEmpty() && this.currentPage == null;
    }

    @Override
    public final boolean needsInput() {
        return !this.finishing && !this.pageBuilder.isFull() && this.currentPage == null;
    }

    @Override
    public final void addInput(Page page) {
        Preconditions.checkState((!this.finishing ? 1 : 0) != 0, (Object)"Operator is already finishing");
        Objects.requireNonNull(page, "page is null");
        Preconditions.checkState((!this.pageBuilder.isFull() ? 1 : 0) != 0, (Object)"Page buffer is full");
        this.currentPage = page;
        this.currentPosition = 0;
    }

    @Override
    public final Page getOutput() {
        if (!this.pageBuilder.isFull() && this.currentPage != null) {
            switch (this.processingOptimization) {
                case "columnar": {
                    Page page = this.processor.processColumnar(this.operatorContext.getSession().toConnectorSession(), this.currentPage, this.getTypes());
                    this.currentPage = null;
                    this.currentPosition = 0;
                    return page;
                }
                case "columnar_dictionary": {
                    Page page = this.processor.processColumnarDictionary(this.operatorContext.getSession().toConnectorSession(), this.currentPage, this.getTypes());
                    this.currentPage = null;
                    this.currentPosition = 0;
                    return page;
                }
                case "disabled": {
                    this.currentPosition = this.processor.process(this.operatorContext.getSession().toConnectorSession(), this.currentPage, this.currentPosition, this.currentPage.getPositionCount(), this.pageBuilder);
                    if (this.currentPosition != this.currentPage.getPositionCount()) break;
                    this.currentPage = null;
                    this.currentPosition = 0;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        if (!this.finishing && !this.pageBuilder.isFull() || this.pageBuilder.isEmpty()) {
            return null;
        }
        Page page = this.pageBuilder.build();
        this.pageBuilder.reset();
        return page;
    }

    public static class FilterAndProjectOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final Supplier<PageProcessor> processor;
        private final List<Type> types;
        private boolean closed;

        public FilterAndProjectOperatorFactory(int operatorId, PlanNodeId planNodeId, Supplier<PageProcessor> processor, List<Type> types) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.processor = processor;
            this.types = types;
        }

        @Override
        public List<Type> getTypes() {
            return this.types;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, FilterAndProjectOperator.class.getSimpleName());
            return new FilterAndProjectOperator(operatorContext, this.types, this.processor.get());
        }

        @Override
        public void close() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new FilterAndProjectOperatorFactory(this.operatorId, this.planNodeId, this.processor, this.types);
        }
    }
}

