/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.execution.SystemMemoryUsageListener;
import com.facebook.presto.operator.ExchangeClient;
import com.facebook.presto.operator.ExchangeClientConfig;
import com.facebook.presto.operator.ExchangeClientSupplier;
import com.facebook.presto.operator.ForExchange;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.google.common.base.Preconditions;
import io.airlift.http.client.HttpClient;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Inject;

public class ExchangeClientFactory
implements ExchangeClientSupplier {
    private final BlockEncodingSerde blockEncodingSerde;
    private final DataSize maxBufferedBytes;
    private final int concurrentRequestMultiplier;
    private final Duration minErrorDuration;
    private final Duration maxErrorDuration;
    private final HttpClient httpClient;
    private final DataSize maxResponseSize;
    private final ScheduledExecutorService executor;

    @Inject
    public ExchangeClientFactory(BlockEncodingSerde blockEncodingSerde, ExchangeClientConfig config, @ForExchange HttpClient httpClient, @ForExchange ScheduledExecutorService executor) {
        this(blockEncodingSerde, config.getMaxBufferSize(), config.getMaxResponseSize(), config.getConcurrentRequestMultiplier(), config.getMinErrorDuration(), config.getMaxErrorDuration(), httpClient, executor);
    }

    public ExchangeClientFactory(BlockEncodingSerde blockEncodingSerde, DataSize maxBufferedBytes, DataSize maxResponseSize, int concurrentRequestMultiplier, Duration minErrorDuration, Duration maxErrorDuration, HttpClient httpClient, ScheduledExecutorService executor) {
        this.blockEncodingSerde = blockEncodingSerde;
        this.maxBufferedBytes = Objects.requireNonNull(maxBufferedBytes, "maxBufferedBytes is null");
        this.concurrentRequestMultiplier = concurrentRequestMultiplier;
        this.minErrorDuration = Objects.requireNonNull(minErrorDuration, "minErrorDuration is null");
        this.maxErrorDuration = Objects.requireNonNull(maxErrorDuration, "maxErrorDuration is null");
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
        Objects.requireNonNull(maxResponseSize, "maxResponseSize is null");
        long maxResponseSizeBytes = (long)((double)Math.min(httpClient.getMaxContentLength(), maxResponseSize.toBytes()) * 0.75);
        this.maxResponseSize = new DataSize((double)maxResponseSizeBytes, DataSize.Unit.BYTE);
        this.executor = Objects.requireNonNull(executor, "executor is null");
        Preconditions.checkArgument((maxBufferedBytes.toBytes() > 0L ? 1 : 0) != 0, (String)"maxBufferSize must be at least 1 byte: %s", (Object)maxBufferedBytes);
        Preconditions.checkArgument((maxResponseSize.toBytes() > 0L ? 1 : 0) != 0, (String)"maxResponseSize must be at least 1 byte: %s", (Object)maxResponseSize);
        Preconditions.checkArgument((concurrentRequestMultiplier > 0 ? 1 : 0) != 0, (String)"concurrentRequestMultiplier must be at least 1: %s", (int)concurrentRequestMultiplier);
    }

    @Override
    public ExchangeClient get(SystemMemoryUsageListener systemMemoryUsageListener) {
        return new ExchangeClient(this.maxBufferedBytes, this.maxResponseSize, this.concurrentRequestMultiplier, this.minErrorDuration, this.maxErrorDuration, this.httpClient, this.executor, systemMemoryUsageListener);
    }
}

