/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.GroupByHash;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.JoinCompiler;
import com.facebook.presto.type.UnknownType;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;

public class ChannelSet {
    private final GroupByHash hash;
    private final boolean containsNull;
    private final int[] hashChannels;

    public ChannelSet(GroupByHash hash, boolean containsNull, int[] hashChannels) {
        this.hash = hash;
        this.containsNull = containsNull;
        this.hashChannels = hashChannels;
    }

    public Type getType() {
        return this.hash.getTypes().get(0);
    }

    public long getEstimatedSizeInBytes() {
        return this.hash.getEstimatedSize();
    }

    public int size() {
        return this.hash.getGroupCount();
    }

    public boolean containsNull() {
        return this.containsNull;
    }

    public boolean contains(int position, Page page) {
        return this.hash.contains(position, page, this.hashChannels);
    }

    public static class ChannelSetBuilder {
        private static final int[] HASH_CHANNELS = new int[]{0};
        private final GroupByHash hash;
        private final OperatorContext operatorContext;
        private final Page nullBlockPage;

        public ChannelSetBuilder(Type type, Optional<Integer> hashChannel, int expectedPositions, OperatorContext operatorContext, JoinCompiler joinCompiler) {
            ImmutableList types = ImmutableList.of((Object)type);
            this.hash = GroupByHash.createGroupByHash(operatorContext.getSession(), (List<? extends Type>)types, HASH_CHANNELS, hashChannel, expectedPositions, joinCompiler);
            this.operatorContext = operatorContext;
            this.nullBlockPage = new Page(new Block[]{type.createBlockBuilder(new BlockBuilderStatus(), 1, UnknownType.UNKNOWN.getFixedSize()).appendNull().build()});
        }

        public ChannelSet build() {
            return new ChannelSet(this.hash, this.hash.contains(0, this.nullBlockPage, HASH_CHANNELS), HASH_CHANNELS);
        }

        public long getEstimatedSize() {
            return this.hash.getEstimatedSize();
        }

        public int size() {
            return this.hash.getGroupCount();
        }

        public void addPage(Page page) {
            this.hash.addPage(page);
            if (this.operatorContext != null) {
                this.operatorContext.setMemoryReservation(this.hash.getEstimatedSize());
            }
        }
    }
}

