/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.Unnester;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.ArrayType;
import java.util.Objects;
import javax.annotation.Nullable;

public class ArrayUnnester
implements Unnester {
    private final Type elementType;
    private final Block arrayBlock;
    private final int channelCount;
    private int position;
    private final int positionCount;

    public ArrayUnnester(ArrayType arrayType, @Nullable Block arrayBlock) {
        this.channelCount = 1;
        this.elementType = Objects.requireNonNull(arrayType, "arrayType is null").getElementType();
        this.arrayBlock = arrayBlock;
        this.positionCount = arrayBlock == null ? 0 : arrayBlock.getPositionCount();
    }

    protected void appendTo(PageBuilder pageBuilder, int outputChannelOffset) {
        BlockBuilder blockBuilder = pageBuilder.getBlockBuilder(outputChannelOffset);
        this.elementType.appendTo(this.arrayBlock, this.position, blockBuilder);
        ++this.position;
    }

    @Override
    public boolean hasNext() {
        return this.position < this.positionCount;
    }

    @Override
    public final int getChannelCount() {
        return this.channelCount;
    }

    @Override
    public final void appendNext(PageBuilder pageBuilder, int outputChannelOffset) {
        this.appendTo(pageBuilder, outputChannelOffset);
    }
}

