/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.spi.type.Type;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class ViewDefinition {
    private final String originalSql;
    private final Optional<String> catalog;
    private final Optional<String> schema;
    private final List<ViewColumn> columns;
    private final Optional<String> owner;

    @JsonCreator
    public ViewDefinition(@JsonProperty(value="originalSql") String originalSql, @JsonProperty(value="catalog") Optional<String> catalog, @JsonProperty(value="schema") Optional<String> schema, @JsonProperty(value="columns") List<ViewColumn> columns, @JsonProperty(value="owner") Optional<String> owner) {
        this.originalSql = Objects.requireNonNull(originalSql, "originalSql is null");
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns is null"));
        this.owner = Objects.requireNonNull(owner, "owner is null");
    }

    @JsonProperty
    public String getOriginalSql() {
        return this.originalSql;
    }

    @JsonProperty
    public Optional<String> getCatalog() {
        return this.catalog;
    }

    @JsonProperty
    public Optional<String> getSchema() {
        return this.schema;
    }

    @JsonProperty
    public List<ViewColumn> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public Optional<String> getOwner() {
        return this.owner;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("originalSql", (Object)this.originalSql).add("catalog", this.catalog.orElse(null)).add("schema", this.schema.orElse(null)).add("columns", this.columns).add("owner", this.owner).omitNullValues().toString();
    }

    public static final class ViewColumn {
        private final String name;
        private final Type type;

        @JsonCreator
        public ViewColumn(@JsonProperty(value="name") String name, @JsonProperty(value="type") Type type) {
            this.name = Objects.requireNonNull(name, "name is null");
            this.type = Objects.requireNonNull(type, "type is null");
        }

        @JsonProperty
        public String getName() {
            return this.name;
        }

        @JsonProperty
        public Type getType() {
            return this.type;
        }

        public String toString() {
            return this.name + ":" + this.type;
        }
    }
}

