/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.LongVariableConstraint;
import com.facebook.presto.metadata.SignatureBuilder;
import com.facebook.presto.metadata.TypeVariableConstraint;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.util.ImmutableCollectors;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Signature {
    private final String name;
    private final FunctionKind kind;
    private final List<TypeVariableConstraint> typeVariableConstraints;
    private final List<LongVariableConstraint> longVariableConstraints;
    private final TypeSignature returnType;
    private final List<TypeSignature> argumentTypes;
    private final boolean variableArity;

    @JsonCreator
    public Signature(@JsonProperty(value="name") String name, @JsonProperty(value="kind") FunctionKind kind, @JsonProperty(value="typeVariableConstraints") List<TypeVariableConstraint> typeVariableConstraints, @JsonProperty(value="longVariableConstraints") List<LongVariableConstraint> longVariableConstraints, @JsonProperty(value="returnType") TypeSignature returnType, @JsonProperty(value="argumentTypes") List<TypeSignature> argumentTypes, @JsonProperty(value="variableArity") boolean variableArity) {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(typeVariableConstraints, "typeVariableConstraints is null");
        Objects.requireNonNull(longVariableConstraints, "longVariableConstraints is null");
        this.name = name;
        this.kind = Objects.requireNonNull(kind, "type is null");
        this.typeVariableConstraints = ImmutableList.copyOf(typeVariableConstraints);
        this.longVariableConstraints = ImmutableList.copyOf(longVariableConstraints);
        this.returnType = Objects.requireNonNull(returnType, "returnType is null");
        this.argumentTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentTypes, "argumentTypes is null"));
        this.variableArity = variableArity;
    }

    public Signature(String name, FunctionKind kind, TypeSignature returnType, TypeSignature ... argumentTypes) {
        this(name, kind, returnType, (List<TypeSignature>)ImmutableList.copyOf((Object[])argumentTypes));
    }

    public Signature(String name, FunctionKind kind, TypeSignature returnType, List<TypeSignature> argumentTypes) {
        this(name, kind, (List<TypeVariableConstraint>)ImmutableList.of(), (List<LongVariableConstraint>)ImmutableList.of(), returnType, argumentTypes, false);
    }

    public static Signature internalOperator(OperatorType operator, Type returnType, List<? extends Type> argumentTypes) {
        return Signature.internalScalarFunction(FunctionRegistry.mangleOperatorName(operator.name()), returnType.getTypeSignature(), (List)argumentTypes.stream().map(Type::getTypeSignature).collect(ImmutableCollectors.toImmutableList()));
    }

    public static Signature internalOperator(OperatorType operator, TypeSignature returnType, TypeSignature ... argumentTypes) {
        return Signature.internalOperator(operator, returnType, (List<TypeSignature>)ImmutableList.copyOf((Object[])argumentTypes));
    }

    public static Signature internalOperator(OperatorType operator, TypeSignature returnType, List<TypeSignature> argumentTypes) {
        return Signature.internalScalarFunction(FunctionRegistry.mangleOperatorName(operator.name()), returnType, argumentTypes);
    }

    public static Signature internalOperator(String name, TypeSignature returnType, List<TypeSignature> argumentTypes) {
        return Signature.internalScalarFunction(FunctionRegistry.mangleOperatorName(name), returnType, argumentTypes);
    }

    public static Signature internalOperator(String name, TypeSignature returnType, TypeSignature ... argumentTypes) {
        return Signature.internalScalarFunction(FunctionRegistry.mangleOperatorName(name), returnType, (List<TypeSignature>)ImmutableList.copyOf((Object[])argumentTypes));
    }

    public static Signature internalScalarFunction(String name, TypeSignature returnType, TypeSignature ... argumentTypes) {
        return Signature.internalScalarFunction(name, returnType, (List<TypeSignature>)ImmutableList.copyOf((Object[])argumentTypes));
    }

    public static Signature internalScalarFunction(String name, TypeSignature returnType, List<TypeSignature> argumentTypes) {
        return new Signature(name, FunctionKind.SCALAR, (List<TypeVariableConstraint>)ImmutableList.of(), (List<LongVariableConstraint>)ImmutableList.of(), returnType, argumentTypes, false);
    }

    public Signature withAlias(String name) {
        return new Signature(name, this.kind, this.typeVariableConstraints, this.longVariableConstraints, this.getReturnType(), this.getArgumentTypes(), this.variableArity);
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public FunctionKind getKind() {
        return this.kind;
    }

    @JsonProperty
    public TypeSignature getReturnType() {
        return this.returnType;
    }

    @JsonProperty
    public List<TypeSignature> getArgumentTypes() {
        return this.argumentTypes;
    }

    @JsonProperty
    public boolean isVariableArity() {
        return this.variableArity;
    }

    @JsonProperty
    public List<TypeVariableConstraint> getTypeVariableConstraints() {
        return this.typeVariableConstraints;
    }

    @JsonProperty
    public List<LongVariableConstraint> getLongVariableConstraints() {
        return this.longVariableConstraints;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.kind, this.typeVariableConstraints, this.longVariableConstraints, this.returnType, this.argumentTypes, this.variableArity});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Signature other = (Signature)obj;
        return Objects.equals(this.name, other.name) && Objects.equals((Object)this.kind, (Object)other.kind) && Objects.equals(this.typeVariableConstraints, other.typeVariableConstraints) && Objects.equals(this.longVariableConstraints, other.longVariableConstraints) && Objects.equals(this.returnType, other.returnType) && Objects.equals(this.argumentTypes, other.argumentTypes) && Objects.equals(this.variableArity, other.variableArity);
    }

    public String toString() {
        List allConstraints = Stream.concat(this.typeVariableConstraints.stream().map(TypeVariableConstraint::toString), this.longVariableConstraints.stream().map(LongVariableConstraint::toString)).collect(Collectors.toList());
        return this.name + (allConstraints.isEmpty() ? "" : "<" + Joiner.on((String)",").join(allConstraints) + ">") + "(" + Joiner.on((String)",").join(this.argumentTypes) + "):" + this.returnType;
    }

    public static TypeVariableConstraint withVariadicBound(String name, String variadicBound) {
        return new TypeVariableConstraint(name, false, false, variadicBound);
    }

    public static TypeVariableConstraint comparableWithVariadicBound(String name, String variadicBound) {
        return new TypeVariableConstraint(name, true, false, variadicBound);
    }

    public static TypeVariableConstraint typeVariable(String name) {
        return new TypeVariableConstraint(name, false, false, null);
    }

    public static TypeVariableConstraint comparableTypeParameter(String name) {
        return new TypeVariableConstraint(name, true, false, null);
    }

    public static TypeVariableConstraint orderableTypeParameter(String name) {
        return new TypeVariableConstraint(name, false, true, null);
    }

    public static LongVariableConstraint longVariableExpression(String variable, String expression) {
        return new LongVariableConstraint(variable, expression);
    }

    public static SignatureBuilder builder() {
        return new SignatureBuilder();
    }
}

