/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.type.TypeSignature;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class OperatorNotFoundException
extends PrestoException {
    private final OperatorType operatorType;
    private final TypeSignature returnType;
    private final List<TypeSignature> argumentTypes;

    public OperatorNotFoundException(OperatorType operatorType, List<? extends TypeSignature> argumentTypes) {
        super((ErrorCodeSupplier)StandardErrorCode.OPERATOR_NOT_FOUND, OperatorNotFoundException.formatErrorMessage(operatorType, argumentTypes, Optional.empty()));
        this.operatorType = Objects.requireNonNull(operatorType, "operatorType is null");
        this.returnType = null;
        this.argumentTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentTypes, "argumentTypes is null"));
    }

    public OperatorNotFoundException(OperatorType operatorType, List<? extends TypeSignature> argumentTypes, TypeSignature returnType) {
        super((ErrorCodeSupplier)StandardErrorCode.OPERATOR_NOT_FOUND, OperatorNotFoundException.formatErrorMessage(operatorType, argumentTypes, Optional.of(returnType)));
        this.operatorType = Objects.requireNonNull(operatorType, "operatorType is null");
        this.argumentTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentTypes, "argumentTypes is null"));
        this.returnType = Objects.requireNonNull(returnType, "returnType is null");
    }

    private static String formatErrorMessage(OperatorType operatorType, List<? extends TypeSignature> argumentTypes, Optional<TypeSignature> returnType) {
        String operatorString;
        switch (operatorType) {
            case BETWEEN: {
                return String.format("Cannot check if %s is BETWEEN %s and %s", argumentTypes.get(0), argumentTypes.get(1), argumentTypes.get(2));
            }
            case CAST: {
                operatorString = String.format("%s%s", operatorType.getOperator(), returnType.map(value -> " to " + value).orElse(""));
                break;
            }
            default: {
                operatorString = String.format("'%s'%s", operatorType.getOperator(), returnType.map(value -> ":" + value).orElse(""));
            }
        }
        return String.format("%s cannot be applied to %s", operatorString, Joiner.on((String)", ").join(argumentTypes));
    }

    public OperatorType getOperatorType() {
        return this.operatorType;
    }

    public TypeSignature getReturnType() {
        return this.returnType;
    }

    public List<TypeSignature> getArgumentTypes() {
        return this.argumentTypes;
    }
}

