/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.memory;

import com.facebook.presto.execution.TaskManager;
import com.facebook.presto.memory.LocalMemoryManager;
import com.facebook.presto.memory.MemoryInfo;
import com.facebook.presto.memory.MemoryPoolAssignmentsRequest;
import java.util.Objects;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@Path(value="/v1/memory")
public class MemoryResource {
    private final LocalMemoryManager memoryManager;
    private final TaskManager taskManager;

    @Inject
    public MemoryResource(LocalMemoryManager memoryManager, TaskManager taskManager) {
        this.memoryManager = Objects.requireNonNull(memoryManager, "memoryManager is null");
        this.taskManager = Objects.requireNonNull(taskManager, "taskManager is null");
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public MemoryInfo getMemoryInfo(MemoryPoolAssignmentsRequest request) {
        this.taskManager.updateMemoryPoolAssignments(request);
        return this.memoryManager.getInfo();
    }
}

