/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.resourceGroups;

import com.facebook.presto.execution.QueryManagerConfig;
import com.facebook.presto.spi.resourceGroups.ResourceGroup;
import com.facebook.presto.spi.resourceGroups.ResourceGroupConfigurationManager;
import com.facebook.presto.spi.resourceGroups.ResourceGroupConfigurationManagerContext;
import com.facebook.presto.spi.resourceGroups.ResourceGroupConfigurationManagerFactory;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.facebook.presto.spi.resourceGroups.ResourceGroupSelector;
import com.facebook.presto.spi.resourceGroups.SelectionContext;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;

public class LegacyResourceGroupConfigurationManagerFactory
implements ResourceGroupConfigurationManagerFactory {
    public static final String LEGACY_RESOURCE_GROUP_MANAGER = "legacy";
    private static final ResourceGroupId GLOBAL = new ResourceGroupId("global");
    private final int maxRunning;
    private final int maxQueued;

    @Inject
    public LegacyResourceGroupConfigurationManagerFactory(QueryManagerConfig config) {
        this.maxRunning = config.getMaxConcurrentQueries();
        this.maxQueued = config.getMaxQueuedQueries();
    }

    public String getName() {
        return LEGACY_RESOURCE_GROUP_MANAGER;
    }

    public ResourceGroupConfigurationManager create(Map<String, String> config, ResourceGroupConfigurationManagerContext context) {
        return new LegacyResourceGroupConfigurationManager();
    }

    public class LegacyResourceGroupConfigurationManager
    implements ResourceGroupConfigurationManager {
        public void configure(ResourceGroup group, SelectionContext context) {
            Preconditions.checkArgument((boolean)group.getId().equals((Object)GLOBAL), (String)"Unexpected resource group: %s", (Object)group.getId());
            group.setMaxQueuedQueries(LegacyResourceGroupConfigurationManagerFactory.this.maxQueued);
            group.setMaxRunningQueries(LegacyResourceGroupConfigurationManagerFactory.this.maxRunning);
        }

        public List<ResourceGroupSelector> getSelectors() {
            return ImmutableList.of(context -> Optional.of(GLOBAL));
        }
    }
}

