/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.buffer;

import com.facebook.presto.OutputBuffers;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.SystemMemoryUsageListener;
import com.facebook.presto.execution.buffer.BufferInfo;
import com.facebook.presto.execution.buffer.BufferResult;
import com.facebook.presto.execution.buffer.BufferState;
import com.facebook.presto.execution.buffer.ClientBuffer;
import com.facebook.presto.execution.buffer.OutputBuffer;
import com.facebook.presto.execution.buffer.OutputBufferInfo;
import com.facebook.presto.execution.buffer.OutputBufferMemoryManager;
import com.facebook.presto.execution.buffer.PageBufferInfo;
import com.facebook.presto.execution.buffer.SerializedPage;
import com.facebook.presto.execution.buffer.SerializedPageReference;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

public class ArbitraryOutputBuffer
implements OutputBuffer {
    private final OutputBufferMemoryManager memoryManager;
    @GuardedBy(value="this")
    private OutputBuffers outputBuffers = OutputBuffers.createInitialEmptyOutputBuffers(OutputBuffers.BufferType.ARBITRARY);
    private final MasterBuffer masterBuffer;
    @GuardedBy(value="this")
    private final ConcurrentMap<OutputBuffers.OutputBufferId, ClientBuffer> buffers = new ConcurrentHashMap<OutputBuffers.OutputBufferId, ClientBuffer>();
    private final StateMachine<BufferState> state;
    private final String taskInstanceId;
    private final AtomicLong totalPagesAdded = new AtomicLong();
    private final AtomicLong totalRowsAdded = new AtomicLong();

    public ArbitraryOutputBuffer(String taskInstanceId, StateMachine<BufferState> state, DataSize maxBufferSize, SystemMemoryUsageListener systemMemoryUsageListener, Executor notificationExecutor) {
        this.taskInstanceId = Objects.requireNonNull(taskInstanceId, "taskInstanceId is null");
        this.state = Objects.requireNonNull(state, "state is null");
        Objects.requireNonNull(maxBufferSize, "maxBufferSize is null");
        Preconditions.checkArgument((maxBufferSize.toBytes() > 0L ? 1 : 0) != 0, (Object)"maxBufferSize must be at least 1");
        this.memoryManager = new OutputBufferMemoryManager(maxBufferSize.toBytes(), Objects.requireNonNull(systemMemoryUsageListener, "systemMemoryUsageListener is null"), Objects.requireNonNull(notificationExecutor, "notificationExecutor is null"));
        this.masterBuffer = new MasterBuffer();
    }

    @Override
    public void addStateChangeListener(StateMachine.StateChangeListener<BufferState> stateChangeListener) {
        this.state.addStateChangeListener(stateChangeListener);
    }

    @Override
    public boolean isFinished() {
        return this.state.get() == BufferState.FINISHED;
    }

    @Override
    public double getUtilization() {
        return this.memoryManager.getUtilization();
    }

    @Override
    public OutputBufferInfo getInfo() {
        BufferState state = this.state.get();
        Collection buffers = this.buffers.values();
        int totalBufferedPages = this.masterBuffer.getBufferedPages();
        ImmutableList.Builder infos = ImmutableList.builder();
        for (ClientBuffer buffer : buffers) {
            BufferInfo bufferInfo = buffer.getInfo();
            infos.add((Object)bufferInfo);
            PageBufferInfo pageBufferInfo = bufferInfo.getPageBufferInfo();
            totalBufferedPages = (int)((long)totalBufferedPages + pageBufferInfo.getBufferedPages());
        }
        return new OutputBufferInfo("ARBITRARY", state, state.canAddBuffers(), state.canAddPages(), this.memoryManager.getBufferedBytes(), totalBufferedPages, this.totalRowsAdded.get(), this.totalPagesAdded.get(), (List<BufferInfo>)infos.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOutputBuffers(OutputBuffers newOutputBuffers) {
        Objects.requireNonNull(newOutputBuffers, "newOutputBuffers is null");
        ArbitraryOutputBuffer arbitraryOutputBuffer = this;
        synchronized (arbitraryOutputBuffer) {
            BufferState state = this.state.get();
            if (state.isTerminal() || this.outputBuffers.getVersion() >= newOutputBuffers.getVersion()) {
                return;
            }
            this.outputBuffers.checkValidTransition(newOutputBuffers);
            this.outputBuffers = newOutputBuffers;
            for (OutputBuffers.OutputBufferId outputBufferId : this.outputBuffers.getBuffers().keySet()) {
                this.getBuffer(outputBufferId);
            }
            if (this.outputBuffers.isNoMoreBufferIds()) {
                this.state.compareAndSet(BufferState.OPEN, BufferState.NO_MORE_BUFFERS);
                this.state.compareAndSet(BufferState.NO_MORE_PAGES, BufferState.FLUSHING);
            }
        }
        if (!this.state.get().canAddBuffers()) {
            this.noMoreBuffers();
        }
        this.checkFlushComplete();
    }

    @Override
    public ListenableFuture<?> enqueue(List<SerializedPage> pages) {
        Objects.requireNonNull(pages, "page is null");
        if (!this.state.get().canAddPages()) {
            return Futures.immediateFuture((Object)true);
        }
        long bytesAdded = pages.stream().mapToLong(SerializedPage::getRetainedSizeInBytes).sum();
        this.memoryManager.updateMemoryUsage(bytesAdded);
        long rowCount = pages.stream().mapToLong(SerializedPage::getPositionCount).sum();
        this.totalRowsAdded.addAndGet(rowCount);
        this.totalPagesAdded.addAndGet(pages.size());
        List serializedPageReferences = (List)pages.stream().map(pageSplit -> new SerializedPageReference((SerializedPage)pageSplit, 1, () -> this.memoryManager.updateMemoryUsage(-pageSplit.getRetainedSizeInBytes()))).collect(ImmutableCollectors.toImmutableList());
        this.masterBuffer.addPages(serializedPageReferences);
        for (ClientBuffer clientBuffer : this.safeGetBuffersSnapshot()) {
            if (this.masterBuffer.isEmpty()) break;
            clientBuffer.loadPagesIfNecessary(this.masterBuffer);
        }
        return this.memoryManager.getNotFullFuture();
    }

    @Override
    public ListenableFuture<?> enqueue(int partition, List<SerializedPage> pages) {
        Preconditions.checkState((partition == 0 ? 1 : 0) != 0, (Object)"Expected partition number to be zero");
        return this.enqueue(pages);
    }

    @Override
    public CompletableFuture<BufferResult> get(OutputBuffers.OutputBufferId bufferId, long startingSequenceId, DataSize maxSize) {
        Objects.requireNonNull(bufferId, "bufferId is null");
        Preconditions.checkArgument((maxSize.toBytes() > 0L ? 1 : 0) != 0, (Object)"maxSize must be at least 1 byte");
        return this.getBuffer(bufferId).getPages(startingSequenceId, maxSize, Optional.of(this.masterBuffer));
    }

    @Override
    public void abort(OutputBuffers.OutputBufferId bufferId) {
        Objects.requireNonNull(bufferId, "bufferId is null");
        this.getBuffer(bufferId).destroy();
        this.checkFlushComplete();
    }

    @Override
    public void setNoMorePages() {
        this.state.compareAndSet(BufferState.OPEN, BufferState.NO_MORE_PAGES);
        this.state.compareAndSet(BufferState.NO_MORE_BUFFERS, BufferState.FLUSHING);
        this.memoryManager.setNoBlockOnFull();
        this.masterBuffer.setNoMorePages();
        this.checkFlushComplete();
    }

    @Override
    public void destroy() {
        if (this.state.setIf(BufferState.FINISHED, oldState -> !oldState.isTerminal())) {
            this.noMoreBuffers();
            this.masterBuffer.destroy();
            this.safeGetBuffersSnapshot().forEach(ClientBuffer::destroy);
            this.memoryManager.setNoBlockOnFull();
        }
    }

    @Override
    public void fail() {
        if (this.state.setIf(BufferState.FAILED, oldState -> !oldState.isTerminal())) {
            this.memoryManager.setNoBlockOnFull();
        }
    }

    private synchronized ClientBuffer getBuffer(OutputBuffers.OutputBufferId id) {
        ClientBuffer buffer = (ClientBuffer)this.buffers.get(id);
        if (buffer != null) {
            return buffer;
        }
        Preconditions.checkState((boolean)this.state.get().canAddBuffers(), (Object)"No more buffers already set");
        buffer = new ClientBuffer(this.taskInstanceId, id);
        if (this.state.get() == BufferState.FINISHED) {
            buffer.destroy();
        }
        this.buffers.put(id, buffer);
        return buffer;
    }

    private synchronized Collection<ClientBuffer> safeGetBuffersSnapshot() {
        return ImmutableList.copyOf(this.buffers.values());
    }

    private synchronized void noMoreBuffers() {
        Sets.SetView undeclaredCreatedBuffers = Sets.difference(this.buffers.keySet(), this.outputBuffers.getBuffers().keySet());
        Preconditions.checkState((boolean)undeclaredCreatedBuffers.isEmpty(), (String)"Final output buffers does not contain all created buffer ids: %s", (Object)undeclaredCreatedBuffers);
    }

    @GuardedBy(value="this")
    private void checkFlushComplete() {
        if (this.state.get() != BufferState.FLUSHING) {
            return;
        }
        if (this.safeGetBuffersSnapshot().stream().allMatch(ClientBuffer::isDestroyed)) {
            this.destroy();
        }
    }

    @ThreadSafe
    private static class MasterBuffer
    implements ClientBuffer.PagesSupplier {
        @GuardedBy(value="this")
        private final LinkedList<SerializedPageReference> masterBuffer = new LinkedList();
        @GuardedBy(value="this")
        private boolean noMorePages;
        private final AtomicInteger bufferedPages = new AtomicInteger();

        private MasterBuffer() {
        }

        public synchronized void addPages(List<SerializedPageReference> pages) {
            this.masterBuffer.addAll(pages);
            this.bufferedPages.set(this.masterBuffer.size());
        }

        public synchronized boolean isEmpty() {
            return this.masterBuffer.isEmpty();
        }

        @Override
        public synchronized boolean mayHaveMorePages() {
            return !this.noMorePages || !this.masterBuffer.isEmpty();
        }

        public synchronized void setNoMorePages() {
            this.noMorePages = true;
        }

        @Override
        public synchronized List<SerializedPageReference> getPages(DataSize maxSize) {
            SerializedPageReference page;
            long maxBytes = maxSize.toBytes();
            ArrayList<SerializedPageReference> pages = new ArrayList<SerializedPageReference>();
            long bytesRemoved = 0L;
            while ((page = this.masterBuffer.peek()) != null && (pages.isEmpty() || (bytesRemoved += page.getRetainedSizeInBytes()) <= maxBytes)) {
                Preconditions.checkState((this.masterBuffer.poll() == page ? 1 : 0) != 0, (Object)"Master buffer corrupted");
                pages.add(page);
            }
            this.bufferedPages.set(this.masterBuffer.size());
            return ImmutableList.copyOf(pages);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy() {
            ImmutableList pages;
            Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (Object)"Can not destroy master buffer while holding a lock on this");
            MasterBuffer masterBuffer = this;
            synchronized (masterBuffer) {
                pages = ImmutableList.copyOf(this.masterBuffer);
                this.masterBuffer.clear();
                this.bufferedPages.set(0);
            }
            pages.forEach(SerializedPageReference::dereferencePage);
        }

        public int getBufferedPages() {
            return this.bufferedPages.get();
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("bufferedPages", this.bufferedPages.get()).toString();
        }
    }
}

