/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.execution.DataDefinitionTask;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.ResetSession;
import com.facebook.presto.transaction.TransactionManager;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class ResetSessionTask
implements DataDefinitionTask<ResetSession> {
    @Override
    public String getName() {
        return "RESET SESSION";
    }

    @Override
    public CompletableFuture<?> execute(ResetSession statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        List parts = statement.getName().getParts();
        if (parts.size() > 2) {
            throw new SemanticException(SemanticErrorCode.INVALID_SESSION_PROPERTY, (Node)statement, "Invalid session property '%s'", statement.getName());
        }
        if (parts.size() == 1) {
            metadata.getSessionPropertyManager().getSystemSessionPropertyMetadata((String)parts.get(0)).orElseThrow(() -> new SemanticException(SemanticErrorCode.INVALID_SESSION_PROPERTY, (Node)statement, "Session property %s does not exist", statement.getName()));
        } else {
            ConnectorId connectorId = metadata.getCatalogHandle(stateMachine.getSession(), (String)parts.get(0)).orElseThrow(() -> new SemanticException(SemanticErrorCode.MISSING_CATALOG, (Node)statement, "Catalog %s does not exist", parts.get(0)));
            metadata.getSessionPropertyManager().getConnectorSessionPropertyMetadata(connectorId, (String)parts.get(1)).orElseThrow(() -> new SemanticException(SemanticErrorCode.INVALID_SESSION_PROPERTY, (Node)statement, "Session property %s does not exist", statement.getName()));
        }
        stateMachine.addResetSessionProperties(statement.getName().toString());
        return CompletableFuture.completedFuture(null);
    }
}

