/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class QueryQueueDefinition {
    private static final Pattern USER_PATTERN = Pattern.compile(Pattern.quote("${USER}"));
    private static final Pattern SOURCE_PATTERN = Pattern.compile(Pattern.quote("${SOURCE}"));
    private final String template;
    private final int maxConcurrent;
    private final int maxQueued;

    public QueryQueueDefinition(String template, int maxConcurrent, int maxQueued) {
        this.template = Objects.requireNonNull(template, "template is null");
        Matcher matcher = Pattern.compile("\\$\\{(.*?)\\}").matcher(template);
        while (matcher.find()) {
            String group = matcher.group(1);
            Preconditions.checkArgument((group.equals("USER") || group.equals("SOURCE") ? 1 : 0) != 0, (String)"Unsupported template parameter: ${%s}", (Object)group);
        }
        Preconditions.checkArgument((maxConcurrent > 0 ? 1 : 0) != 0, (Object)"maxConcurrent must be positive");
        Preconditions.checkArgument((maxQueued > 0 ? 1 : 0) != 0, (Object)"maxQueued must be positive");
        this.maxConcurrent = maxConcurrent;
        this.maxQueued = maxQueued;
    }

    public String getExpandedTemplate(Session session) {
        String expanded = USER_PATTERN.matcher(this.template).replaceAll(session.getUser());
        return SOURCE_PATTERN.matcher(expanded).replaceAll(session.getSource().orElse(""));
    }

    String getTemplate() {
        return this.template;
    }

    public int getMaxConcurrent() {
        return this.maxConcurrent;
    }

    public int getMaxQueued() {
        return this.maxQueued;
    }
}

