/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.system.jdbc;

import com.facebook.presto.Session;
import com.facebook.presto.connector.system.SystemConnectorSessionUtil;
import com.facebook.presto.connector.system.jdbc.FilterUtil;
import com.facebook.presto.connector.system.jdbc.JdbcTable;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataListing;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.InMemoryRecordSet;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class SchemaJdbcTable
extends JdbcTable {
    public static final SchemaTableName NAME = new SchemaTableName("jdbc", "schemas");
    public static final ConnectorTableMetadata METADATA = MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(NAME).column("table_schem", (Type)VarcharType.createUnboundedVarcharType()).column("table_catalog", (Type)VarcharType.createUnboundedVarcharType()).build();
    private final Metadata metadata;
    private final AccessControl accessControl;

    @Inject
    public SchemaJdbcTable(Metadata metadata, AccessControl accessControl) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    public ConnectorTableMetadata getTableMetadata() {
        return METADATA;
    }

    public RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession connectorSession, TupleDomain<Integer> constraint) {
        Session session = SystemConnectorSessionUtil.toSession(transactionHandle, connectorSession);
        Optional<String> catalogFilter = FilterUtil.stringFilter(constraint, 1);
        InMemoryRecordSet.Builder table = InMemoryRecordSet.builder((ConnectorTableMetadata)METADATA);
        for (String catalog : FilterUtil.filter(MetadataListing.listCatalogs(session, this.metadata, this.accessControl).keySet(), catalogFilter)) {
            for (String schema : MetadataListing.listSchemas(session, this.metadata, this.accessControl, catalog)) {
                table.addRow(new Object[]{schema, catalog});
            }
        }
        return table.build().cursor();
    }
}

