/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.system;

import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

public class SystemColumnHandle
implements ColumnHandle {
    private final ConnectorId connectorId;
    private final String columnName;

    @JsonCreator
    public SystemColumnHandle(@JsonProperty(value="connectorId") ConnectorId connectorId, @JsonProperty(value="columnName") String columnName) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
        this.columnName = Objects.requireNonNull(columnName, "columnName is null");
    }

    @JsonProperty
    public ConnectorId getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public String getColumnName() {
        return this.columnName;
    }

    public int hashCode() {
        return Objects.hash(this.connectorId, this.columnName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SystemColumnHandle other = (SystemColumnHandle)obj;
        return Objects.equals(this.connectorId, other.connectorId) && Objects.equals(this.columnName, other.columnName);
    }

    public String toString() {
        return this.connectorId + ":" + this.columnName;
    }

    public static Map<String, ColumnHandle> toSystemColumnHandles(ConnectorId connectorId, ConnectorTableMetadata tableMetadata) {
        ImmutableMap.Builder columnHandles = ImmutableMap.builder();
        for (ColumnMetadata columnMetadata : tableMetadata.getColumns()) {
            columnHandles.put((Object)columnMetadata.getName(), (Object)new SystemColumnHandle(connectorId, columnMetadata.getName()));
        }
        return columnHandles.build();
    }
}

