/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.system;

import com.facebook.presto.metadata.AllNodes;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.PrestoNode;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.InMemoryRecordSet;
import com.facebook.presto.spi.Node;
import com.facebook.presto.spi.NodeState;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;

public class NodeSystemTable
implements SystemTable {
    public static final SchemaTableName NODES_TABLE_NAME = new SchemaTableName("runtime", "nodes");
    public static final ConnectorTableMetadata NODES_TABLE = MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(NODES_TABLE_NAME).column("node_id", (Type)VarcharType.createUnboundedVarcharType()).column("http_uri", (Type)VarcharType.createUnboundedVarcharType()).column("node_version", (Type)VarcharType.createUnboundedVarcharType()).column("coordinator", (Type)BooleanType.BOOLEAN).column("state", (Type)VarcharType.createUnboundedVarcharType()).build();
    private final InternalNodeManager nodeManager;

    @Inject
    public NodeSystemTable(InternalNodeManager nodeManager) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return NODES_TABLE;
    }

    public RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
        InMemoryRecordSet.Builder table = InMemoryRecordSet.builder((ConnectorTableMetadata)NODES_TABLE);
        AllNodes allNodes = this.nodeManager.getAllNodes();
        this.addRows(table, allNodes.getActiveNodes(), NodeState.ACTIVE);
        this.addRows(table, allNodes.getInactiveNodes(), NodeState.INACTIVE);
        this.addRows(table, allNodes.getShuttingDownNodes(), NodeState.SHUTTING_DOWN);
        return table.build().cursor();
    }

    private void addRows(InMemoryRecordSet.Builder table, Set<Node> nodes, NodeState state) {
        for (Node node : nodes) {
            table.addRow(new Object[]{node.getNodeIdentifier(), node.getHttpUri().toString(), NodeSystemTable.getNodeVersion(node), this.isCoordinator(node), state.toString().toLowerCase()});
        }
    }

    private static String getNodeVersion(Node node) {
        if (node instanceof PrestoNode) {
            return ((PrestoNode)node).getNodeVersion().toString();
        }
        return "";
    }

    private boolean isCoordinator(Node node) {
        return this.nodeManager.getCoordinators().contains(node);
    }
}

