/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.informationSchema;

import com.facebook.presto.connector.informationSchema.InformationSchemaColumnHandle;
import com.facebook.presto.connector.informationSchema.InformationSchemaSplit;
import com.facebook.presto.connector.informationSchema.InformationSchemaTableLayoutHandle;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.FixedSplitSource;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.predicate.NullableValue;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class InformationSchemaSplitManager
implements ConnectorSplitManager {
    private final InternalNodeManager nodeManager;

    public InformationSchemaSplitManager(InternalNodeManager nodeManager) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableLayoutHandle layout) {
        InformationSchemaTableLayoutHandle handle = (InformationSchemaTableLayoutHandle)layout;
        Map bindings = (Map)TupleDomain.extractFixedValues(handle.getConstraint()).orElse(ImmutableMap.of());
        ImmutableList localAddress = ImmutableList.of((Object)this.nodeManager.getCurrentNode().getHostAndPort());
        Map<String, NullableValue> filters = bindings.entrySet().stream().collect(Collectors.toMap(entry -> ((InformationSchemaColumnHandle)entry.getKey()).getColumnName(), Map.Entry::getValue));
        InformationSchemaSplit split = new InformationSchemaSplit(handle.getTable(), filters, (List<HostAddress>)localAddress);
        return new FixedSplitSource((Iterable)ImmutableList.of((Object)split));
    }
}

