/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.informationSchema;

import com.facebook.presto.connector.informationSchema.InformationSchemaColumnHandle;
import com.facebook.presto.connector.informationSchema.InformationSchemaTableHandle;
import com.facebook.presto.connector.informationSchema.InformationSchemaTableLayoutHandle;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class InformationSchemaMetadata
implements ConnectorMetadata {
    public static final String INFORMATION_SCHEMA = "information_schema";
    public static final SchemaTableName TABLE_COLUMNS = new SchemaTableName("information_schema", "columns");
    public static final SchemaTableName TABLE_TABLES = new SchemaTableName("information_schema", "tables");
    public static final SchemaTableName TABLE_VIEWS = new SchemaTableName("information_schema", "views");
    public static final SchemaTableName TABLE_SCHEMATA = new SchemaTableName("information_schema", "schemata");
    public static final SchemaTableName TABLE_INTERNAL_PARTITIONS = new SchemaTableName("information_schema", "__internal_partitions__");
    public static final Map<SchemaTableName, ConnectorTableMetadata> TABLES = MetadataUtil.SchemaMetadataBuilder.schemaMetadataBuilder().table(MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(TABLE_COLUMNS).column("table_catalog", (Type)VarcharType.createUnboundedVarcharType()).column("table_schema", (Type)VarcharType.createUnboundedVarcharType()).column("table_name", (Type)VarcharType.createUnboundedVarcharType()).column("column_name", (Type)VarcharType.createUnboundedVarcharType()).column("ordinal_position", (Type)BigintType.BIGINT).column("column_default", (Type)VarcharType.createUnboundedVarcharType()).column("is_nullable", (Type)VarcharType.createUnboundedVarcharType()).column("data_type", (Type)VarcharType.createUnboundedVarcharType()).column("comment", (Type)VarcharType.createUnboundedVarcharType()).column("extra_info", (Type)VarcharType.createUnboundedVarcharType()).build()).table(MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(TABLE_TABLES).column("table_catalog", (Type)VarcharType.createUnboundedVarcharType()).column("table_schema", (Type)VarcharType.createUnboundedVarcharType()).column("table_name", (Type)VarcharType.createUnboundedVarcharType()).column("table_type", (Type)VarcharType.createUnboundedVarcharType()).build()).table(MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(TABLE_VIEWS).column("table_catalog", (Type)VarcharType.createUnboundedVarcharType()).column("table_schema", (Type)VarcharType.createUnboundedVarcharType()).column("table_name", (Type)VarcharType.createUnboundedVarcharType()).column("view_definition", (Type)VarcharType.createUnboundedVarcharType()).build()).table(MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(TABLE_SCHEMATA).column("catalog_name", (Type)VarcharType.createUnboundedVarcharType()).column("schema_name", (Type)VarcharType.createUnboundedVarcharType()).build()).table(MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(TABLE_INTERNAL_PARTITIONS).column("table_catalog", (Type)VarcharType.createUnboundedVarcharType()).column("table_schema", (Type)VarcharType.createUnboundedVarcharType()).column("table_name", (Type)VarcharType.createUnboundedVarcharType()).column("partition_number", (Type)BigintType.BIGINT).column("partition_key", (Type)VarcharType.createUnboundedVarcharType()).column("partition_value", (Type)VarcharType.createUnboundedVarcharType()).build()).build();
    private final String catalogName;

    public InformationSchemaMetadata(String catalogName) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
    }

    private InformationSchemaTableHandle checkTableHandle(ConnectorTableHandle tableHandle) {
        InformationSchemaTableHandle handle = (InformationSchemaTableHandle)tableHandle;
        Preconditions.checkArgument((boolean)handle.getCatalogName().equals(this.catalogName), (String)"invalid table handle: expected catalog %s but got %s", (Object)this.catalogName, (Object)handle.getCatalogName());
        Preconditions.checkArgument((boolean)TABLES.containsKey(handle.getSchemaTableName()), (String)"table %s does not exist", (Object)handle.getSchemaTableName());
        return handle;
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return ImmutableList.of((Object)INFORMATION_SCHEMA);
    }

    public ConnectorTableHandle getTableHandle(ConnectorSession connectorSession, SchemaTableName tableName) {
        if (!TABLES.containsKey(tableName)) {
            return null;
        }
        return new InformationSchemaTableHandle(this.catalogName, tableName.getSchemaName(), tableName.getTableName());
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        InformationSchemaTableHandle informationSchemaTableHandle = this.checkTableHandle(tableHandle);
        return TABLES.get(informationSchemaTableHandle.getSchemaTableName());
    }

    public List<SchemaTableName> listTables(ConnectorSession session, String schemaNameOrNull) {
        if (schemaNameOrNull == null) {
            return ImmutableList.copyOf(TABLES.keySet());
        }
        return ImmutableList.copyOf((Iterable)Iterables.filter(TABLES.keySet(), (Predicate)Predicates.compose((Predicate)Predicates.equalTo((Object)schemaNameOrNull), SchemaTableName::getSchemaName)));
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        String columnName;
        InformationSchemaTableHandle informationSchemaTableHandle = this.checkTableHandle(tableHandle);
        ConnectorTableMetadata tableMetadata = TABLES.get(informationSchemaTableHandle.getSchemaTableName());
        ColumnMetadata columnMetadata = MetadataUtil.findColumnMetadata(tableMetadata, columnName = ((InformationSchemaColumnHandle)columnHandle).getColumnName());
        Preconditions.checkArgument((columnMetadata != null ? 1 : 0) != 0, (String)"Column %s on table %s does not exist", (Object)columnName, (Object)tableMetadata.getTable());
        return columnMetadata;
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        InformationSchemaTableHandle informationSchemaTableHandle = this.checkTableHandle(tableHandle);
        ConnectorTableMetadata tableMetadata = TABLES.get(informationSchemaTableHandle.getSchemaTableName());
        return tableMetadata.getColumns().stream().map(ColumnMetadata::getName).collect(Collectors.toMap(Function.identity(), InformationSchemaColumnHandle::new));
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<SchemaTableName, ConnectorTableMetadata> entry : TABLES.entrySet()) {
            if (!prefix.matches(entry.getKey())) continue;
            builder.put((Object)entry.getKey(), (Object)entry.getValue().getColumns());
        }
        return builder.build();
    }

    public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle table, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        InformationSchemaTableHandle handle = (InformationSchemaTableHandle)table;
        ConnectorTableLayout layout = new ConnectorTableLayout((ConnectorTableLayoutHandle)new InformationSchemaTableLayoutHandle(handle, (TupleDomain<ColumnHandle>)constraint.getSummary()));
        return ImmutableList.of((Object)new ConnectorTableLayoutResult(layout, constraint.getSummary()));
    }

    public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle handle) {
        return new ConnectorTableLayout(handle);
    }

    static List<ColumnMetadata> informationSchemaTableColumns(SchemaTableName tableName) {
        Preconditions.checkArgument((boolean)TABLES.containsKey(tableName), (String)"table does not exist: %s", (Object)tableName);
        return TABLES.get(tableName).getColumns();
    }
}

