/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.metadata.BuiltInTypeAndFunctionNamespaceManager;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SpatialJoinUtils {
    public static final QualifiedObjectName ST_CONTAINS = QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.JAVA_BUILTIN_NAMESPACE, (String)"st_contains");
    public static final QualifiedObjectName ST_CROSSES = QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.JAVA_BUILTIN_NAMESPACE, (String)"st_crosses");
    public static final QualifiedObjectName ST_EQUALS = QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.JAVA_BUILTIN_NAMESPACE, (String)"st_equals");
    public static final QualifiedObjectName ST_INTERSECTS = QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.JAVA_BUILTIN_NAMESPACE, (String)"st_intersects");
    public static final QualifiedObjectName ST_OVERLAPS = QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.JAVA_BUILTIN_NAMESPACE, (String)"st_overlaps");
    public static final QualifiedObjectName ST_TOUCHES = QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.JAVA_BUILTIN_NAMESPACE, (String)"st_touches");
    public static final QualifiedObjectName ST_WITHIN = QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.JAVA_BUILTIN_NAMESPACE, (String)"st_within");
    public static final QualifiedObjectName ST_DISTANCE = QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.JAVA_BUILTIN_NAMESPACE, (String)"st_distance");
    private static final Set<String> ALLOWED_SPATIAL_JOIN_FUNCTIONS = Stream.of(ST_CONTAINS, ST_CROSSES, ST_EQUALS, ST_INTERSECTS, ST_OVERLAPS, ST_TOUCHES, ST_WITHIN).map(QualifiedObjectName::getObjectName).map(String::toLowerCase).collect(Collectors.toSet());

    private SpatialJoinUtils() {
    }

    public static List<CallExpression> extractSupportedSpatialFunctions(RowExpression filterExpression, FunctionAndTypeManager functionAndTypeManager) {
        return (List)LogicalRowExpressions.extractConjuncts((RowExpression)filterExpression).stream().filter(CallExpression.class::isInstance).map(CallExpression.class::cast).filter(call -> SpatialJoinUtils.isSupportedSpatialFunction(call, functionAndTypeManager)).collect(ImmutableList.toImmutableList());
    }

    private static boolean isSupportedSpatialFunction(CallExpression call, FunctionAndTypeManager functionAndTypeManager) {
        String functionName = functionAndTypeManager.getFunctionMetadata(call.getFunctionHandle()).getName().getObjectName().toLowerCase(Locale.ENGLISH);
        return ALLOWED_SPATIAL_JOIN_FUNCTIONS.contains(functionName);
    }

    public static List<CallExpression> extractSupportedSpatialComparisons(RowExpression filterExpression, FunctionAndTypeManager functionAndTypeManager) {
        return (List)LogicalRowExpressions.extractConjuncts((RowExpression)filterExpression).stream().filter(CallExpression.class::isInstance).map(CallExpression.class::cast).filter(call -> new FunctionResolution(functionAndTypeManager.getFunctionAndTypeResolver()).isComparisonFunction(call.getFunctionHandle())).filter(call -> SpatialJoinUtils.isSupportedSpatialComparison(call, functionAndTypeManager)).collect(ImmutableList.toImmutableList());
    }

    private static boolean isSupportedSpatialComparison(CallExpression expression, FunctionAndTypeManager functionAndTypeManager) {
        FunctionMetadata metadata = functionAndTypeManager.getFunctionMetadata(expression.getFunctionHandle());
        Preconditions.checkArgument((metadata.getOperatorType().isPresent() && ((OperatorType)metadata.getOperatorType().get()).isComparisonOperator() ? 1 : 0) != 0);
        switch ((OperatorType)metadata.getOperatorType().get()) {
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: {
                return SpatialJoinUtils.isSTDistance((RowExpression)expression.getArguments().get(0), functionAndTypeManager);
            }
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: {
                return SpatialJoinUtils.isSTDistance((RowExpression)expression.getArguments().get(1), functionAndTypeManager);
            }
        }
        return false;
    }

    private static boolean isSTDistance(RowExpression expression, FunctionAndTypeManager functionAndTypeManager) {
        return expression instanceof CallExpression && functionAndTypeManager.getFunctionMetadata(((CallExpression)expression).getFunctionHandle()).getName().equals((Object)ST_DISTANCE);
    }

    public static FunctionHandle getFlippedFunctionHandle(CallExpression callExpression, FunctionAndTypeManager functionAndTypeManager) {
        FunctionMetadata callExpressionMetadata = functionAndTypeManager.getFunctionMetadata(callExpression.getFunctionHandle());
        Preconditions.checkArgument((boolean)callExpressionMetadata.getOperatorType().isPresent());
        OperatorType operatorType = SpatialJoinUtils.flip((OperatorType)callExpressionMetadata.getOperatorType().get());
        List typeProviderList = TypeSignatureProvider.fromTypes((List)((List)callExpression.getArguments().stream().map(RowExpression::getType).collect(ImmutableList.toImmutableList())));
        Preconditions.checkArgument((typeProviderList.size() == 2 ? 1 : 0) != 0, (Object)"Expected there to be only two arguments in type provider");
        return functionAndTypeManager.resolveOperator(operatorType, (List<TypeSignatureProvider>)ImmutableList.of((Object)((TypeSignatureProvider)typeProviderList.get(1)), (Object)((TypeSignatureProvider)typeProviderList.get(0))));
    }

    public static OperatorType flip(OperatorType operatorType) {
        switch (operatorType) {
            case EQUAL: {
                return OperatorType.EQUAL;
            }
            case NOT_EQUAL: {
                return OperatorType.NOT_EQUAL;
            }
            case LESS_THAN: {
                return OperatorType.GREATER_THAN;
            }
            case LESS_THAN_OR_EQUAL: {
                return OperatorType.GREATER_THAN_OR_EQUAL;
            }
            case GREATER_THAN: {
                return OperatorType.LESS_THAN;
            }
            case GREATER_THAN_OR_EQUAL: {
                return OperatorType.LESS_THAN_OR_EQUAL;
            }
            case IS_DISTINCT_FROM: {
                return OperatorType.IS_DISTINCT_FROM;
            }
        }
        throw new IllegalArgumentException("Unsupported comparison: " + operatorType);
    }
}

