/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public final class SecureRandomGeneration {
    private SecureRandomGeneration() {
    }

    public static String getNonBlockingAlgorithmName() {
        String os = System.getProperty("os.name");
        return os.startsWith("Windows") ? "SHA1PRNG" : "NativePRNGNonBlocking";
    }

    public static SecureRandom getNonBlocking() {
        String algorithm = SecureRandomGeneration.getNonBlockingAlgorithmName();
        try {
            return SecureRandom.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, algorithm + " is not supported in your OS", (Throwable)e);
        }
    }
}

