/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import com.facebook.airlift.log.Logger;
import com.facebook.airlift.stats.GarbageCollectionNotificationInfo;
import com.facebook.presto.execution.SqlTask;
import com.facebook.presto.execution.SqlTaskIoStats;
import com.facebook.presto.execution.SqlTaskManager;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskStatus;
import com.facebook.presto.operator.TaskStats;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.util.StringTableUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.management.JMException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;

public class GcStatusMonitor {
    private static final Logger log = Logger.get(GcStatusMonitor.class);
    private static final String GC_NOTIFICATION_TYPE = "com.sun.management.gc.notification";
    private final NotificationListener notificationListener = (notification, ignored) -> this.onNotification(notification);
    private final SqlTaskManager sqlTaskManager;

    @Inject
    public GcStatusMonitor(SqlTaskManager sqlTaskManager) {
        this.sqlTaskManager = Objects.requireNonNull(sqlTaskManager, "sqlTaskManager must not be null");
    }

    @PostConstruct
    public void start() {
        for (GarbageCollectorMXBean mbean : ManagementFactory.getGarbageCollectorMXBeans()) {
            if (mbean.getName().equals("TestingMBeanServer")) continue;
            ObjectName objectName = mbean.getObjectName();
            try {
                ManagementFactory.getPlatformMBeanServer().addNotificationListener(objectName, this.notificationListener, null, null);
            }
            catch (JMException e) {
                throw new RuntimeException("Unable to add GC listener", e);
            }
        }
    }

    @PreDestroy
    public void stop() {
        for (GarbageCollectorMXBean mbean : ManagementFactory.getGarbageCollectorMXBeans()) {
            ObjectName objectName = mbean.getObjectName();
            try {
                ManagementFactory.getPlatformMBeanServer().removeNotificationListener(objectName, this.notificationListener);
            }
            catch (JMException jMException) {}
        }
    }

    private void onNotification(Notification notification) {
        GarbageCollectionNotificationInfo info;
        if (GC_NOTIFICATION_TYPE.equals(notification.getType()) && (info = new GarbageCollectionNotificationInfo((CompositeData)notification.getUserData())).isMajorGc()) {
            this.onMajorGc();
        }
    }

    private void onMajorGc() {
        try {
            this.logActiveTasks();
        }
        catch (Throwable throwable) {
            log.error(throwable);
        }
    }

    private void logActiveTasks() {
        List<SqlTask> activeSqlTasks = this.getActiveSqlTasks();
        ListMultimap activeQueriesToTasksMap = (ListMultimap)activeSqlTasks.stream().collect(ImmutableListMultimap.toImmutableListMultimap(task -> task.getQueryContext().getQueryId(), Function.identity()));
        GcStatusMonitor.logQueriesAndTasks((ListMultimap<QueryId, SqlTask>)activeQueriesToTasksMap);
    }

    private static void logQueriesAndTasks(ListMultimap<QueryId, SqlTask> queryIDToSqlTaskMap) {
        Comparator<Map.Entry> comparator = Comparator.comparingLong(Map.Entry::getValue);
        List queryIdsSortedByMemoryUsage = (List)queryIDToSqlTaskMap.asMap().entrySet().stream().map(entry -> new AbstractMap.SimpleEntry<QueryId, Long>((QueryId)entry.getKey(), ((Collection)entry.getValue()).stream().map(SqlTask::getTaskInfo).map(TaskInfo::getStats).mapToLong(stats -> stats.getUserMemoryReservationInBytes() + stats.getSystemMemoryReservationInBytes()).sum())).sorted(comparator.reversed()).map(Map.Entry::getKey).collect(ImmutableList.toImmutableList());
        GcStatusMonitor.logQueriesAndTasks(queryIdsSortedByMemoryUsage, queryIDToSqlTaskMap);
        GcStatusMonitor.logTaskStats(queryIdsSortedByMemoryUsage, queryIDToSqlTaskMap);
    }

    private List<SqlTask> getActiveSqlTasks() {
        return (List)this.sqlTaskManager.getAllTasks().stream().filter(task -> !task.getTaskState().isDone()).collect(ImmutableList.toImmutableList());
    }

    private static void logQueriesAndTasks(List<QueryId> queryIds, ListMultimap<QueryId, SqlTask> tasksByQueryId) {
        List rows = (List)queryIds.stream().map(queryId -> {
            List sqlTasks = tasksByQueryId.get(queryId);
            long userMemoryReservation = sqlTasks.stream().map(SqlTask::getTaskInfo).map(TaskInfo::getStats).mapToLong(TaskStats::getUserMemoryReservationInBytes).sum();
            long systemMemoryReservation = sqlTasks.stream().map(SqlTask::getTaskInfo).map(TaskInfo::getStats).mapToLong(TaskStats::getSystemMemoryReservationInBytes).sum();
            long revocableMemoryReservation = sqlTasks.stream().map(SqlTask::getTaskInfo).map(TaskInfo::getStats).mapToLong(TaskStats::getRevocableMemoryReservationInBytes).sum();
            return ImmutableList.of((Object)queryId.toString(), (Object)Long.toString(userMemoryReservation + systemMemoryReservation), (Object)Long.toString(userMemoryReservation), (Object)Long.toString(systemMemoryReservation), (Object)Long.toString(revocableMemoryReservation));
        }).collect(ImmutableList.toImmutableList());
        if (!rows.isEmpty()) {
            GcStatusMonitor.logInfoTable((List<List<String>>)ImmutableList.builder().add((Object)ImmutableList.of((Object)"Query ID", (Object)"Total Memory Reservation", (Object)"User Memory Reservation", (Object)"System Memory Reservation", (Object)"Revocable Memory Reservation")).addAll((Iterable)rows).build());
        }
    }

    private static void logTaskStats(List<QueryId> queryIds, ListMultimap<QueryId, SqlTask> tasksByQueryId) {
        List rows = (List)queryIds.stream().flatMap(queryId -> {
            List sqlTasks = tasksByQueryId.get(queryId);
            Comparator comparator = (first, second) -> {
                TaskStats aTaskStats = first.getTaskInfo().getStats();
                TaskStats bTaskStats = second.getTaskInfo().getStats();
                return Long.compare(aTaskStats.getUserMemoryReservationInBytes() + aTaskStats.getSystemMemoryReservationInBytes(), bTaskStats.getUserMemoryReservationInBytes() + bTaskStats.getSystemMemoryReservationInBytes());
            };
            return sqlTasks.stream().sorted(comparator.reversed()).map(task -> {
                TaskInfo taskInfo = task.getTaskInfo();
                SqlTaskIoStats taskIOStats = task.getIoStats();
                TaskStatus taskStatus = taskInfo.getTaskStatus();
                TaskStats taskStats = taskInfo.getStats();
                return ImmutableList.of((Object)task.getQueryContext().getQueryId().toString(), (Object)task.getTaskId().toString(), (Object)taskStatus.getState().toString(), (Object)String.valueOf(taskStats.getCreateTimeInMillis()), (Object)Long.toString(taskStats.getUserMemoryReservationInBytes()), (Object)Long.toString(taskStats.getSystemMemoryReservationInBytes()), (Object)Long.toString(taskStats.getRevocableMemoryReservationInBytes()), (Object)Long.toString(taskIOStats.getInputDataSize().getTotalCount()), (Object)Long.toString(taskIOStats.getOutputDataSize().getTotalCount()), (Object)Long.toString(taskIOStats.getInputPositions().getTotalCount()), (Object)Long.toString(taskIOStats.getOutputPositions().getTotalCount()));
            });
        }).collect(ImmutableList.toImmutableList());
        if (!rows.isEmpty()) {
            GcStatusMonitor.logInfoTable((List<List<String>>)ImmutableList.builder().add((Object)ImmutableList.of((Object)"Query ID", (Object)"Task ID", (Object)"State", (Object)"Created Ts", (Object)"User Memory", (Object)"System Memory", (Object)"Revocable Memory", (Object)"Input Bytes", (Object)"Output Bytes", (Object)"Input Row Count", (Object)"Output Row Count")).addAll((Iterable)rows).build());
        }
    }

    private static void logInfoTable(List<List<String>> table) {
        StringTableUtils.getTableStrings(table).stream().forEach(arg_0 -> ((Logger)log).info(arg_0));
    }
}

