/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type.setdigest;

import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.type.setdigest.SetDigest;
import com.facebook.presto.type.setdigest.SetDigestState;
import com.facebook.presto.type.setdigest.SetDigestType;
import io.airlift.slice.Slice;

@AggregationFunction(value="merge_set_digest")
public final class MergeSetDigestAggregation {
    private MergeSetDigestAggregation() {
    }

    @InputFunction
    public static void input(SetDigestState state, @SqlType(value="SetDigest") Slice value) {
        SetDigest instance = SetDigest.newInstance(value);
        MergeSetDigestAggregation.merge(state, instance);
    }

    @CombineFunction
    public static void combine(SetDigestState state, SetDigestState otherState) {
        MergeSetDigestAggregation.merge(state, otherState.getDigest());
    }

    private static void merge(SetDigestState state, SetDigest instance) {
        if (state.getDigest() == null) {
            state.setDigest(instance);
        } else {
            state.getDigest().mergeWith(instance);
        }
    }

    @OutputFunction(value="SetDigest")
    public static void output(SetDigestState state, BlockBuilder out) {
        if (state.getDigest() == null) {
            out.appendNull();
        } else {
            SetDigestType.SET_DIGEST.writeSlice(out, state.getDigest().serialize());
        }
    }
}

