/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type.khyperloglog;

import com.facebook.presto.common.array.ObjectBigArray;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.AccumulatorStateFactory;
import com.facebook.presto.spi.function.GroupedAccumulatorState;
import com.facebook.presto.type.khyperloglog.KHyperLogLog;
import com.facebook.presto.type.khyperloglog.KHyperLogLogState;
import org.openjdk.jol.info.ClassLayout;

public class KHyperLogLogStateFactory
implements AccumulatorStateFactory<KHyperLogLogState> {
    private static final int SIZE_OF_SINGLE = ClassLayout.parseClass(SingleKHyperLogLogState.class).instanceSize();
    private static final int SIZE_OF_GROUPED = ClassLayout.parseClass(GroupedKHyperLogLogState.class).instanceSize();
    private final long groupLimit;

    public KHyperLogLogStateFactory() {
        this.groupLimit = 0L;
    }

    public KHyperLogLogStateFactory(long groupLimit) {
        this.groupLimit = groupLimit;
    }

    public KHyperLogLogState createSingleState() {
        return new SingleKHyperLogLogState();
    }

    public Class<? extends KHyperLogLogState> getSingleStateClass() {
        return SingleKHyperLogLogState.class;
    }

    public KHyperLogLogState createGroupedState() {
        return new GroupedKHyperLogLogState(this.groupLimit);
    }

    public Class<? extends KHyperLogLogState> getGroupedStateClass() {
        return GroupedKHyperLogLogState.class;
    }

    public static class SingleKHyperLogLogState
    implements KHyperLogLogState {
        private KHyperLogLog khll;

        @Override
        public KHyperLogLog getKHLL() {
            return this.khll;
        }

        @Override
        public void setKHLL(KHyperLogLog value) {
            this.khll = value;
        }

        public long getEstimatedSize() {
            if (this.khll == null) {
                return SIZE_OF_SINGLE;
            }
            return SIZE_OF_SINGLE + this.khll.estimatedInMemorySize();
        }
    }

    public static class GroupedKHyperLogLogState
    implements GroupedAccumulatorState,
    KHyperLogLogState {
        private final ObjectBigArray<KHyperLogLog> khlls = new ObjectBigArray();
        private long groupId;
        private long size;
        private final long groupLimit;

        public GroupedKHyperLogLogState(long groupLimit) {
            this.groupLimit = groupLimit;
        }

        public void setGroupId(long groupId) {
            this.groupId = groupId;
        }

        public void ensureCapacity(long size) {
            if (this.groupLimit > 0L && size > this.groupLimit) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("GroupedKHyperLogLogState number of groups exceed limit %d set by khyperloglog-agg-group-limit", this.groupLimit));
            }
            this.khlls.ensureCapacity(size);
        }

        @Override
        public KHyperLogLog getKHLL() {
            return (KHyperLogLog)this.khlls.get(this.groupId);
        }

        @Override
        public void setKHLL(KHyperLogLog value) {
            if (this.getKHLL() != null) {
                this.size -= (long)this.getKHLL().estimatedInMemorySize();
            }
            this.size += (long)value.estimatedInMemorySize();
            this.khlls.set(this.groupId, (Object)value);
        }

        public long getEstimatedSize() {
            return (long)SIZE_OF_GROUPED + this.size + this.khlls.sizeOf();
        }
    }
}

