/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.TypeUtils;
import com.facebook.presto.spi.function.BlockIndex;
import com.facebook.presto.spi.function.BlockPosition;
import com.facebook.presto.spi.function.IsNull;
import com.facebook.presto.spi.function.ScalarOperator;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlType;

public final class RealComparisonOperators {
    private RealComparisonOperators() {
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean equal(@SqlType(value="real") long left, @SqlType(value="real") long right) {
        return TypeUtils.realEquals((float)Float.intBitsToFloat((int)left), (float)Float.intBitsToFloat((int)right));
    }

    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean notEqual(@SqlType(value="real") long left, @SqlType(value="real") long right) {
        return !TypeUtils.realEquals((float)Float.intBitsToFloat((int)left), (float)Float.intBitsToFloat((int)right));
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    @SqlType(value="boolean")
    public static boolean lessThan(@SqlType(value="real") long left, @SqlType(value="real") long right) {
        return TypeUtils.realCompare((float)Float.intBitsToFloat((int)left), (float)Float.intBitsToFloat((int)right)) == -1;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean lessThanOrEqual(@SqlType(value="real") long left, @SqlType(value="real") long right) {
        return TypeUtils.realCompare((float)Float.intBitsToFloat((int)left), (float)Float.intBitsToFloat((int)right)) <= 0;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN)
    @SqlType(value="boolean")
    public static boolean greaterThan(@SqlType(value="real") long left, @SqlType(value="real") long right) {
        return TypeUtils.realCompare((float)Float.intBitsToFloat((int)left), (float)Float.intBitsToFloat((int)right)) == 1;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean greaterThanOrEqual(@SqlType(value="real") long left, @SqlType(value="real") long right) {
        return TypeUtils.realCompare((float)Float.intBitsToFloat((int)left), (float)Float.intBitsToFloat((int)right)) >= 0;
    }

    @ScalarOperator(value=OperatorType.BETWEEN)
    @SqlType(value="boolean")
    public static boolean between(@SqlType(value="real") long value, @SqlType(value="real") long min, @SqlType(value="real") long max) {
        return RealComparisonOperators.lessThanOrEqual(min, value) && RealComparisonOperators.lessThanOrEqual(value, max);
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    @SqlType(value="bigint")
    public static long hashCode(@SqlType(value="real") long value) {
        return TypeUtils.realHashCode((float)Float.intBitsToFloat((int)value));
    }

    @ScalarOperator(value=OperatorType.IS_DISTINCT_FROM)
    public static class RealDistinctFromOperator {
        @SqlType(value="boolean")
        public static boolean isDistinctFrom(@SqlType(value="real") long left, @IsNull boolean leftNull, @SqlType(value="real") long right, @IsNull boolean rightNull) {
            if (leftNull != rightNull) {
                return true;
            }
            if (leftNull) {
                return false;
            }
            return RealComparisonOperators.notEqual(left, right);
        }

        @SqlType(value="boolean")
        public static boolean isDistinctFrom(@BlockPosition @SqlType(value="real", nativeContainerType=long.class) Block left, @BlockIndex int leftPosition, @BlockPosition @SqlType(value="real", nativeContainerType=long.class) Block right, @BlockIndex int rightPosition) {
            if (left.isNull(leftPosition) != right.isNull(rightPosition)) {
                return true;
            }
            if (left.isNull(leftPosition)) {
                return false;
            }
            return RealComparisonOperators.notEqual(RealType.REAL.getLong(left, leftPosition), RealType.REAL.getLong(right, rightPosition));
        }
    }
}

