/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.Chars;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.LiteralParameters;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.ScalarOperator;
import com.facebook.presto.spi.function.SqlFunctionVisibility;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.type.LiteralParameter;
import com.facebook.presto.util.Failures;
import io.airlift.jcodings.Encoding;
import io.airlift.jcodings.specific.NonStrictUTF8Encoding;
import io.airlift.joni.Matcher;
import io.airlift.joni.Regex;
import io.airlift.joni.Syntax;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.nio.charset.StandardCharsets;

public final class LikeFunctions {
    private static final Syntax SYNTAX = new Syntax(0x800006, 0, 0, 0, new Syntax.MetaCharTable(92, 0, 0, 0, 0, 0));

    private LikeFunctions() {
    }

    @ScalarFunction(value="like", visibility=SqlFunctionVisibility.HIDDEN)
    @LiteralParameters(value={"x"})
    @SqlType(value="boolean")
    public static boolean likeChar(@LiteralParameter(value="x") Long x, @SqlType(value="char(x)") Slice value, @SqlType(value="LikePattern") Regex pattern) {
        return LikeFunctions.likeVarchar(Chars.padSpaces((Slice)value, (int)x.intValue()), pattern);
    }

    @ScalarFunction(value="like", visibility=SqlFunctionVisibility.HIDDEN)
    @LiteralParameters(value={"x"})
    @SqlType(value="boolean")
    public static boolean likeVarchar(@SqlType(value="varchar(x)") Slice value, @SqlType(value="LikePattern") Regex pattern) {
        Matcher matcher;
        int offset;
        if (value.hasByteArray()) {
            offset = value.byteArrayOffset();
            matcher = pattern.matcher(value.byteArray(), offset, offset + value.length());
        } else {
            offset = 0;
            matcher = pattern.matcher(value.getBytes());
        }
        return matcher.match(offset, offset + value.length(), 0) != -1;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @LiteralParameters(value={"x"})
    @SqlType(value="LikePattern")
    public static Regex castVarcharToLikePattern(@SqlType(value="varchar(x)") Slice pattern) {
        return LikeFunctions.likePattern(pattern);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @LiteralParameters(value={"x"})
    @SqlType(value="LikePattern")
    public static Regex castCharToLikePattern(@LiteralParameter(value="x") Long charLength, @SqlType(value="char(x)") Slice pattern) {
        return LikeFunctions.likePattern(Chars.padSpaces((Slice)pattern, (int)charLength.intValue()));
    }

    public static Regex likePattern(Slice pattern) {
        return LikeFunctions.likePattern(pattern.toStringUtf8(), '0', false);
    }

    @ScalarFunction(visibility=SqlFunctionVisibility.HIDDEN)
    @LiteralParameters(value={"x", "y"})
    @SqlType(value="LikePattern")
    public static Regex likePattern(@SqlType(value="varchar(x)") Slice pattern, @SqlType(value="varchar(y)") Slice escape) {
        return LikeFunctions.likePattern(pattern.toStringUtf8(), LikeFunctions.getEscapeChar(escape), true);
    }

    public static boolean isLikePattern(Slice pattern, Slice escape) {
        String stringPattern = pattern.toStringUtf8();
        if (escape == null) {
            return stringPattern.contains("%") || stringPattern.contains("_");
        }
        String stringEscape = escape.toStringUtf8();
        Failures.checkCondition(stringEscape.length() == 1, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Escape string must be a single character", new Object[0]);
        char escapeChar = stringEscape.charAt(0);
        boolean escaped = false;
        boolean isLikePattern = false;
        for (int currentChar : stringPattern.codePoints().toArray()) {
            if (!escaped && currentChar == escapeChar) {
                escaped = true;
                continue;
            }
            if (escaped) {
                LikeFunctions.checkEscape(currentChar == 37 || currentChar == 95 || currentChar == escapeChar);
                escaped = false;
                continue;
            }
            if (currentChar != 37 && currentChar != 95) continue;
            isLikePattern = true;
        }
        LikeFunctions.checkEscape(!escaped);
        return isLikePattern;
    }

    public static Slice unescapeLiteralLikePattern(Slice pattern, Slice escape) {
        if (escape == null) {
            return pattern;
        }
        String stringEscape = escape.toStringUtf8();
        Failures.checkCondition(stringEscape.length() == 1, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Escape string must be a single character", new Object[0]);
        char escapeChar = stringEscape.charAt(0);
        String stringPattern = pattern.toStringUtf8();
        StringBuilder unescapedPattern = new StringBuilder(stringPattern.length());
        boolean escaped = false;
        for (int currentChar : stringPattern.codePoints().toArray()) {
            if (!escaped && currentChar == escapeChar) {
                escaped = true;
                continue;
            }
            unescapedPattern.append(Character.toChars(currentChar));
            escaped = false;
        }
        return Slices.utf8Slice((String)unescapedPattern.toString());
    }

    private static void checkEscape(boolean condition) {
        Failures.checkCondition(condition, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Escape character must be followed by '%%', '_' or the escape character itself", new Object[0]);
    }

    private static Regex likePattern(String patternString, char escapeChar, boolean shouldEscape) {
        StringBuilder regex = new StringBuilder(patternString.length() * 2);
        regex.append('^');
        boolean escaped = false;
        block7: for (char currentChar : patternString.toCharArray()) {
            LikeFunctions.checkEscape(!escaped || currentChar == '%' || currentChar == '_' || currentChar == escapeChar);
            if (shouldEscape && !escaped && currentChar == escapeChar) {
                escaped = true;
                continue;
            }
            switch (currentChar) {
                case '%': {
                    regex.append(escaped ? "%" : ".*");
                    escaped = false;
                    continue block7;
                }
                case '_': {
                    regex.append(escaped ? "_" : ".");
                    escaped = false;
                    continue block7;
                }
                default: {
                    switch (currentChar) {
                        case '$': 
                        case '*': 
                        case '.': 
                        case '\\': 
                        case '^': {
                            regex.append('\\');
                        }
                    }
                    regex.append(currentChar);
                    escaped = false;
                }
            }
        }
        LikeFunctions.checkEscape(!escaped);
        regex.append('$');
        byte[] bytes = regex.toString().getBytes(StandardCharsets.UTF_8);
        return new Regex(bytes, 0, bytes.length, 12, (Encoding)NonStrictUTF8Encoding.INSTANCE, SYNTAX);
    }

    private static char getEscapeChar(Slice escape) {
        String escapeString = escape.toStringUtf8();
        if (escapeString.isEmpty()) {
            return '\uffff';
        }
        if (escapeString.length() == 1) {
            return escapeString.charAt(0);
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Escape string must be a single character");
    }
}

