/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.TypeUtils;
import com.facebook.presto.spi.function.BlockIndex;
import com.facebook.presto.spi.function.BlockPosition;
import com.facebook.presto.spi.function.IsNull;
import com.facebook.presto.spi.function.ScalarOperator;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlType;

public class DoubleComparisonOperators {
    private DoubleComparisonOperators() {
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean equal(@SqlType(value="double") double left, @SqlType(value="double") double right) {
        return TypeUtils.doubleEquals((double)left, (double)right);
    }

    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean notEqual(@SqlType(value="double") double left, @SqlType(value="double") double right) {
        return DoubleComparisonOperators.equal(left, right) == false;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    @SqlType(value="boolean")
    public static boolean lessThan(@SqlType(value="double") double left, @SqlType(value="double") double right) {
        return TypeUtils.doubleCompare((double)left, (double)right) < 0;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean lessThanOrEqual(@SqlType(value="double") double left, @SqlType(value="double") double right) {
        return TypeUtils.doubleCompare((double)left, (double)right) <= 0;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN)
    @SqlType(value="boolean")
    public static boolean greaterThan(@SqlType(value="double") double left, @SqlType(value="double") double right) {
        return TypeUtils.doubleCompare((double)left, (double)right) == 1;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean greaterThanOrEqual(@SqlType(value="double") double left, @SqlType(value="double") double right) {
        return TypeUtils.doubleCompare((double)left, (double)right) >= 0;
    }

    @ScalarOperator(value=OperatorType.BETWEEN)
    @SqlType(value="boolean")
    public static boolean between(@SqlType(value="double") double value, @SqlType(value="double") double min, @SqlType(value="double") double max) {
        return DoubleComparisonOperators.lessThanOrEqual(min, value) && DoubleComparisonOperators.lessThanOrEqual(value, max);
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    @SqlType(value="bigint")
    public static long hashCode(@SqlType(value="double") double value) {
        return TypeUtils.doubleHashCode((double)value);
    }

    @ScalarOperator(value=OperatorType.IS_DISTINCT_FROM)
    public static class DoubleDistinctFromOperator {
        @SqlType(value="boolean")
        public static boolean isDistinctFrom(@SqlType(value="double") double left, @IsNull boolean leftNull, @SqlType(value="double") double right, @IsNull boolean rightNull) {
            if (leftNull != rightNull) {
                return true;
            }
            if (leftNull) {
                return false;
            }
            return DoubleComparisonOperators.notEqual(left, right);
        }

        @SqlType(value="boolean")
        public static boolean isDistinctFrom(@BlockPosition @SqlType(value="double", nativeContainerType=double.class) Block leftBlock, @BlockIndex int leftPosition, @BlockPosition @SqlType(value="double", nativeContainerType=double.class) Block rightBlock, @BlockIndex int rightPosition) {
            if (leftBlock.isNull(leftPosition) != rightBlock.isNull(rightPosition)) {
                return true;
            }
            if (leftBlock.isNull(leftPosition)) {
                return false;
            }
            double left = DoubleType.DOUBLE.getDouble(leftBlock, leftPosition);
            double right = DoubleType.DOUBLE.getDouble(rightBlock, rightPosition);
            return DoubleComparisonOperators.notEqual(left, right);
        }
    }
}

