/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.ttl.clusterttlprovidermanagers;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.spi.ttl.ClusterTtlProvider;
import com.facebook.presto.spi.ttl.ClusterTtlProviderFactory;
import com.facebook.presto.spi.ttl.ConfidenceBasedTtlInfo;
import com.facebook.presto.ttl.clusterttlprovidermanagers.ClusterTtlProviderManager;
import com.facebook.presto.ttl.nodettlfetchermanagers.NodeTtlFetcherManager;
import com.facebook.presto.util.PropertiesUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

public class ConfidenceBasedClusterTtlProviderManager
implements ClusterTtlProviderManager {
    private static final Logger log = Logger.get(ConfidenceBasedClusterTtlProviderManager.class);
    private static final File CLUSTER_TTL_PROVIDER_CONFIG = new File("etc/cluster-ttl-provider.properties");
    private static final String CLUSTER_TTL_PROVIDER_PROPERTY_NAME = "cluster-ttl-provider.factory";
    private final AtomicReference<ClusterTtlProvider> clusterTtlProvider = new AtomicReference();
    private final NodeTtlFetcherManager nodeTtlFetcherManager;
    private final Map<String, ClusterTtlProviderFactory> clusterTtlProviderFactories = new ConcurrentHashMap<String, ClusterTtlProviderFactory>();

    @Inject
    public ConfidenceBasedClusterTtlProviderManager(NodeTtlFetcherManager nodeTtlFetcherManager) {
        this.nodeTtlFetcherManager = Objects.requireNonNull(nodeTtlFetcherManager, "nodeTtlFetcherManager is null");
    }

    @Override
    public ConfidenceBasedTtlInfo getClusterTtl() {
        return this.clusterTtlProvider.get().getClusterTtl((List)ImmutableList.copyOf(this.nodeTtlFetcherManager.getAllTtls().values()));
    }

    @Override
    public void addClusterTtlProviderFactory(ClusterTtlProviderFactory clusterTtlProviderFactory) {
        Objects.requireNonNull(clusterTtlProviderFactory, "clusterTtlProviderFactory is null");
        if (this.clusterTtlProviderFactories.putIfAbsent(clusterTtlProviderFactory.getName(), clusterTtlProviderFactory) != null) {
            throw new IllegalArgumentException(String.format("Query Prerequisites '%s' is already registered", clusterTtlProviderFactory.getName()));
        }
    }

    @Override
    public void loadClusterTtlProvider() throws Exception {
        if (CLUSTER_TTL_PROVIDER_CONFIG.exists()) {
            HashMap<String, String> properties = new HashMap<String, String>(PropertiesUtil.loadProperties(CLUSTER_TTL_PROVIDER_CONFIG));
            String factoryName = (String)properties.remove(CLUSTER_TTL_PROVIDER_PROPERTY_NAME);
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)factoryName) ? 1 : 0) != 0, (String)"Cluster Ttl Provider configuration %s does not contain %s", (Object)CLUSTER_TTL_PROVIDER_CONFIG.getAbsoluteFile(), (Object)CLUSTER_TTL_PROVIDER_PROPERTY_NAME);
            this.load(factoryName, properties);
        } else {
            this.load("infinite", (Map<String, String>)ImmutableMap.of());
        }
    }

    @VisibleForTesting
    public void load(String factoryName, Map<String, String> properties) {
        log.info("-- Loading Cluster Ttl Provider factory --");
        ClusterTtlProviderFactory clusterTtlProviderFactory = this.clusterTtlProviderFactories.get(factoryName);
        Preconditions.checkState((clusterTtlProviderFactory != null ? 1 : 0) != 0, (String)"Cluster Ttl Provider factory %s is not registered", (Object)factoryName);
        ClusterTtlProvider clusterTtlProvider = clusterTtlProviderFactory.create(properties);
        Preconditions.checkState((boolean)this.clusterTtlProvider.compareAndSet(null, clusterTtlProvider), (Object)"Cluster Ttl Provider has already been set!");
        log.info("-- Loaded Cluster Ttl Provider %s --", new Object[]{factoryName});
    }
}

