/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.transaction;

import com.facebook.presto.Session;
import com.facebook.presto.common.transaction.TransactionId;
import com.facebook.presto.metadata.CatalogMetadata;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.function.FunctionNamespaceManager;
import com.facebook.presto.spi.function.FunctionNamespaceTransactionHandle;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.spi.transaction.IsolationLevel;
import com.facebook.presto.transaction.TransactionInfo;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public interface TransactionManager {
    public static final IsolationLevel DEFAULT_ISOLATION = IsolationLevel.READ_UNCOMMITTED;
    public static final boolean DEFAULT_READ_ONLY = false;

    public TransactionInfo getTransactionInfo(TransactionId var1);

    public Optional<TransactionInfo> getOptionalTransactionInfo(TransactionId var1);

    public List<TransactionInfo> getAllTransactionInfos();

    public void tryRegisterTransaction(TransactionInfo var1);

    public TransactionId beginTransaction(boolean var1);

    public TransactionId beginTransaction(IsolationLevel var1, boolean var2, boolean var3);

    public Map<String, ConnectorId> getCatalogNames(TransactionId var1);

    public Optional<CatalogMetadata> getOptionalCatalogMetadata(TransactionId var1, String var2);

    public void enableRollback(TransactionId var1);

    public CatalogMetadata getCatalogMetadata(TransactionId var1, ConnectorId var2);

    public CatalogMetadata getCatalogMetadataForWrite(TransactionId var1, ConnectorId var2);

    public CatalogMetadata getCatalogMetadataForWrite(TransactionId var1, String var2);

    public ConnectorTransactionHandle getConnectorTransaction(TransactionId var1, ConnectorId var2);

    public void registerFunctionNamespaceManager(String var1, FunctionNamespaceManager<?> var2);

    public FunctionNamespaceTransactionHandle getFunctionNamespaceTransaction(TransactionId var1, String var2);

    public void checkAndSetActive(TransactionId var1);

    public void trySetActive(TransactionId var1);

    public void trySetInactive(TransactionId var1);

    public ListenableFuture<?> asyncCommit(TransactionId var1);

    public ListenableFuture<?> asyncAbort(TransactionId var1);

    public void fail(TransactionId var1);

    default public void activateTransaction(Session session, boolean transactionControl, AccessControl accessControl) {
        if (!session.getTransactionId().isPresent()) {
            return;
        }
        TransactionId transactionId = session.getTransactionId().get();
        if (transactionControl) {
            this.trySetActive(transactionId);
        } else {
            this.checkAndSetActive(transactionId);
        }
    }
}

