/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.transaction;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.presto.common.transaction.TransactionId;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.transaction.IsolationLevel;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.units.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@ThriftStruct
public class TransactionInfo {
    private final TransactionId transactionId;
    private final IsolationLevel isolationLevel;
    private final boolean readOnly;
    private final boolean autoCommitContext;
    private final long createTimeInMillis;
    private final Duration idleTime;
    private final List<ConnectorId> connectorIds;
    private final Optional<ConnectorId> writtenConnectorId;

    @ThriftConstructor
    public TransactionInfo(TransactionId transactionId, IsolationLevel isolationLevel, boolean readOnly, boolean autoCommitContext, long createTimeInMillis, Duration idleTime, List<ConnectorId> connectorIds, Optional<ConnectorId> writtenConnectorId) {
        this.transactionId = Objects.requireNonNull(transactionId, "transactionId is null");
        this.isolationLevel = Objects.requireNonNull(isolationLevel, "isolationLevel is null");
        this.readOnly = readOnly;
        this.autoCommitContext = autoCommitContext;
        Preconditions.checkArgument((createTimeInMillis >= 0L ? 1 : 0) != 0, (Object)"createTimeInMillis is negative");
        this.createTimeInMillis = createTimeInMillis;
        this.idleTime = Objects.requireNonNull(idleTime, "idleTime is null");
        this.connectorIds = ImmutableList.copyOf((Collection)Objects.requireNonNull(connectorIds, "connectorIds is null"));
        this.writtenConnectorId = Objects.requireNonNull(writtenConnectorId, "writtenConnectorId is null");
    }

    @ThriftField(value=1)
    public TransactionId getTransactionId() {
        return this.transactionId;
    }

    @ThriftField(value=2)
    public IsolationLevel getIsolationLevel() {
        return this.isolationLevel;
    }

    @ThriftField(value=3)
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @ThriftField(value=4)
    public boolean isAutoCommitContext() {
        return this.autoCommitContext;
    }

    @ThriftField(value=5)
    public long getCreateTimeInMillis() {
        return this.createTimeInMillis;
    }

    @ThriftField(value=6)
    public Duration getIdleTime() {
        return this.idleTime;
    }

    @ThriftField(value=7)
    public List<ConnectorId> getConnectorIds() {
        return this.connectorIds;
    }

    @ThriftField(value=8)
    public Optional<ConnectorId> getWrittenConnectorId() {
        return this.writtenConnectorId;
    }
}

