/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.testing;

import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.transaction.TransactionId;
import com.facebook.presto.security.AccessControlManager;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.security.AccessControlContext;
import com.facebook.presto.spi.security.AccessDeniedException;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.security.ViewExpression;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;

public class TestingAccessControlManager
extends AccessControlManager {
    private final Set<TestingPrivilege> denyPrivileges = new HashSet<TestingPrivilege>();
    private final Map<RowFilterKey, List<ViewExpression>> rowFilters = new HashMap<RowFilterKey, List<ViewExpression>>();
    private final Map<ColumnMaskKey, ViewExpression> columnMasks = new HashMap<ColumnMaskKey, ViewExpression>();

    @Inject
    public TestingAccessControlManager(TransactionManager transactionManager) {
        super(transactionManager);
        this.setSystemAccessControl("allow-all", (Map<String, String>)ImmutableMap.of());
    }

    public static TestingPrivilege privilege(String entityName, TestingPrivilegeType type) {
        return new TestingPrivilege(Optional.empty(), entityName, type);
    }

    public static TestingPrivilege privilege(String userName, String entityName, TestingPrivilegeType type) {
        return new TestingPrivilege(Optional.of(userName), entityName, type);
    }

    public void deny(TestingPrivilege ... deniedPrivileges) {
        Collections.addAll(this.denyPrivileges, deniedPrivileges);
    }

    public void reset() {
        this.denyPrivileges.clear();
        this.rowFilters.clear();
        this.columnMasks.clear();
    }

    public void rowFilter(QualifiedObjectName table, String identity, ViewExpression filter) {
        this.rowFilters.computeIfAbsent(new RowFilterKey(identity, table), key -> new ArrayList()).add(filter);
    }

    public void columnMask(QualifiedObjectName table, String column, String identity, ViewExpression mask) {
        this.columnMasks.put(new ColumnMaskKey(identity, table, column), mask);
    }

    @Override
    public void checkCanSetUser(Identity identity, AccessControlContext context, Optional<Principal> principal, String userName) {
        if (this.shouldDenyPrivilege(userName, userName, TestingPrivilegeType.SET_USER)) {
            AccessDeniedException.denySetUser(principal, (String)userName);
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanSetUser(identity, context, principal, userName);
        }
    }

    @Override
    public void checkCanCreateSchema(TransactionId transactionId, Identity identity, AccessControlContext context, CatalogSchemaName schemaName) {
        if (this.shouldDenyPrivilege(identity.getUser(), schemaName.getSchemaName(), TestingPrivilegeType.CREATE_SCHEMA)) {
            AccessDeniedException.denyCreateSchema((String)schemaName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanCreateSchema(transactionId, identity, context, schemaName);
        }
    }

    @Override
    public void checkCanDropSchema(TransactionId transactionId, Identity identity, AccessControlContext context, CatalogSchemaName schemaName) {
        if (this.shouldDenyPrivilege(identity.getUser(), schemaName.getSchemaName(), TestingPrivilegeType.DROP_SCHEMA)) {
            AccessDeniedException.denyDropSchema((String)schemaName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanDropSchema(transactionId, identity, context, schemaName);
        }
    }

    @Override
    public void checkCanRenameSchema(TransactionId transactionId, Identity identity, AccessControlContext context, CatalogSchemaName schemaName, String newSchemaName) {
        if (this.shouldDenyPrivilege(identity.getUser(), schemaName.getSchemaName(), TestingPrivilegeType.RENAME_SCHEMA)) {
            AccessDeniedException.denyRenameSchema((String)schemaName.toString(), (String)newSchemaName);
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanRenameSchema(transactionId, identity, context, schemaName, newSchemaName);
        }
    }

    @Override
    public void checkCanShowCreateTable(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName tableName) {
        if (this.shouldDenyPrivilege(identity.getUser(), tableName.getObjectName(), TestingPrivilegeType.SHOW_CREATE_TABLE)) {
            AccessDeniedException.denyShowCreateTable((String)tableName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanShowCreateTable(transactionId, identity, context, tableName);
        }
    }

    @Override
    public void checkCanCreateTable(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName tableName) {
        if (this.shouldDenyPrivilege(identity.getUser(), tableName.getObjectName(), TestingPrivilegeType.CREATE_TABLE)) {
            AccessDeniedException.denyCreateTable((String)tableName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanCreateTable(transactionId, identity, context, tableName);
        }
    }

    @Override
    public void checkCanDropTable(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName tableName) {
        if (this.shouldDenyPrivilege(identity.getUser(), tableName.getObjectName(), TestingPrivilegeType.DROP_TABLE)) {
            AccessDeniedException.denyDropTable((String)tableName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanDropTable(transactionId, identity, context, tableName);
        }
    }

    @Override
    public void checkCanRenameTable(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName tableName, QualifiedObjectName newTableName) {
        if (this.shouldDenyPrivilege(identity.getUser(), tableName.getObjectName(), TestingPrivilegeType.RENAME_TABLE)) {
            AccessDeniedException.denyRenameTable((String)tableName.toString(), (String)newTableName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanRenameTable(transactionId, identity, context, tableName, newTableName);
        }
    }

    @Override
    public void checkCanSetTableProperties(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName tableName, Map<String, Object> properties) {
        if (this.shouldDenyPrivilege(identity.getUser(), tableName.getObjectName(), TestingPrivilegeType.SET_TABLE_PROPERTIES)) {
            AccessDeniedException.denySetTableProperties((String)tableName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanSetTableProperties(transactionId, identity, context, tableName, properties);
        }
    }

    @Override
    public void checkCanAddColumns(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName tableName) {
        if (this.shouldDenyPrivilege(identity.getUser(), tableName.getObjectName(), TestingPrivilegeType.ADD_COLUMN)) {
            AccessDeniedException.denyAddColumn((String)tableName.toString());
        }
        super.checkCanAddColumns(transactionId, identity, context, tableName);
    }

    @Override
    public void checkCanDropColumn(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName tableName) {
        if (this.shouldDenyPrivilege(identity.getUser(), tableName.getObjectName(), TestingPrivilegeType.DROP_COLUMN)) {
            AccessDeniedException.denyDropColumn((String)tableName.toString());
        }
        super.checkCanDropColumn(transactionId, identity, context, tableName);
    }

    @Override
    public void checkCanRenameColumn(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName tableName) {
        if (this.shouldDenyPrivilege(identity.getUser(), tableName.getObjectName(), TestingPrivilegeType.RENAME_COLUMN)) {
            AccessDeniedException.denyRenameColumn((String)tableName.toString());
        }
        super.checkCanRenameColumn(transactionId, identity, context, tableName);
    }

    @Override
    public void checkCanInsertIntoTable(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName tableName) {
        if (this.shouldDenyPrivilege(identity.getUser(), tableName.getObjectName(), TestingPrivilegeType.INSERT_TABLE)) {
            AccessDeniedException.denyInsertTable((String)tableName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanInsertIntoTable(transactionId, identity, context, tableName);
        }
    }

    @Override
    public void checkCanDeleteFromTable(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName tableName) {
        if (this.shouldDenyPrivilege(identity.getUser(), tableName.getObjectName(), TestingPrivilegeType.DELETE_TABLE)) {
            AccessDeniedException.denyDeleteTable((String)tableName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanDeleteFromTable(transactionId, identity, context, tableName);
        }
    }

    @Override
    public void checkCanTruncateTable(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName tableName) {
        if (this.shouldDenyPrivilege(identity.getUser(), tableName.getObjectName(), TestingPrivilegeType.TRUNCATE_TABLE)) {
            AccessDeniedException.denyTruncateTable((String)tableName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanDeleteFromTable(transactionId, identity, context, tableName);
        }
    }

    @Override
    public void checkCanUpdateTableColumns(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName tableName, Set<String> updatedColumnNames) {
        if (this.shouldDenyPrivilege(identity.getUser(), tableName.getObjectName(), TestingPrivilegeType.UPDATE_TABLE)) {
            AccessDeniedException.denyUpdateTableColumns((String)tableName.toString(), updatedColumnNames);
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanUpdateTableColumns(transactionId, identity, context, tableName, updatedColumnNames);
        }
    }

    @Override
    public void checkCanCreateView(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName viewName) {
        if (this.shouldDenyPrivilege(identity.getUser(), viewName.getObjectName(), TestingPrivilegeType.CREATE_VIEW)) {
            AccessDeniedException.denyCreateView((String)viewName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanCreateView(transactionId, identity, context, viewName);
        }
    }

    @Override
    public void checkCanRenameView(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName viewName, QualifiedObjectName newViewName) {
        if (this.shouldDenyPrivilege(identity.getUser(), viewName.getObjectName(), TestingPrivilegeType.RENAME_VIEW)) {
            AccessDeniedException.denyRenameView((String)viewName.toString(), (String)newViewName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanRenameView(transactionId, identity, context, viewName, newViewName);
        }
    }

    @Override
    public void checkCanDropView(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName viewName) {
        if (this.shouldDenyPrivilege(identity.getUser(), viewName.getObjectName(), TestingPrivilegeType.DROP_VIEW)) {
            AccessDeniedException.denyDropView((String)viewName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanDropView(transactionId, identity, context, viewName);
        }
    }

    @Override
    public void checkCanSetSystemSessionProperty(Identity identity, AccessControlContext context, String propertyName) {
        if (this.shouldDenyPrivilege(identity.getUser(), propertyName, TestingPrivilegeType.SET_SESSION)) {
            AccessDeniedException.denySetSystemSessionProperty((String)propertyName);
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanSetSystemSessionProperty(identity, context, propertyName);
        }
    }

    @Override
    public void checkCanCreateViewWithSelectFromColumns(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName tableName, Set<String> columnNames) {
        if (this.shouldDenyPrivilege(identity.getUser(), tableName.getObjectName(), TestingPrivilegeType.CREATE_VIEW_WITH_SELECT_COLUMNS)) {
            AccessDeniedException.denyCreateViewWithSelect((String)tableName.toString(), (Identity)identity);
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanCreateViewWithSelectFromColumns(transactionId, identity, context, tableName, columnNames);
        }
    }

    @Override
    public void checkCanSetCatalogSessionProperty(TransactionId transactionId, Identity identity, AccessControlContext context, String catalogName, String propertyName) {
        if (this.shouldDenyPrivilege(identity.getUser(), catalogName + "." + propertyName, TestingPrivilegeType.SET_SESSION)) {
            AccessDeniedException.denySetCatalogSessionProperty((String)catalogName, (String)propertyName);
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanSetCatalogSessionProperty(transactionId, identity, context, catalogName, propertyName);
        }
    }

    @Override
    public void checkCanSelectFromColumns(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName tableName, Set<Subfield> columnOrSubfieldNames) {
        Set columns = (Set)columnOrSubfieldNames.stream().map(subfield -> subfield.toString()).collect(ImmutableSet.toImmutableSet());
        if (this.shouldDenyPrivilege(identity.getUser(), tableName.getObjectName(), TestingPrivilegeType.SELECT_COLUMN)) {
            AccessDeniedException.denySelectColumns((String)tableName.toString(), (Collection)columns);
        }
        for (String column : columns) {
            if (!this.shouldDenyPrivilege(identity.getUser(), column, TestingPrivilegeType.SELECT_COLUMN)) continue;
            AccessDeniedException.denySelectColumns((String)tableName.toString(), (Collection)columns);
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanSelectFromColumns(transactionId, identity, context, tableName, columnOrSubfieldNames);
        }
    }

    @Override
    public void checkCanDropConstraint(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName tableName) {
        if (this.shouldDenyPrivilege(identity.getUser(), tableName.getObjectName(), TestingPrivilegeType.DROP_CONSTRAINT)) {
            AccessDeniedException.denyDropConstraint((String)tableName.toString());
        }
        super.checkCanDropConstraint(transactionId, identity, context, tableName);
    }

    @Override
    public void checkCanAddConstraints(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName tableName) {
        if (this.shouldDenyPrivilege(identity.getUser(), tableName.getObjectName(), TestingPrivilegeType.ADD_CONSTRAINT)) {
            AccessDeniedException.denyAddConstraint((String)tableName.toString());
        }
        super.checkCanAddConstraints(transactionId, identity, context, tableName);
    }

    @Override
    public List<ViewExpression> getRowFilters(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName tableName) {
        return this.rowFilters.getOrDefault(new RowFilterKey(identity.getUser(), tableName), (List<ViewExpression>)ImmutableList.of());
    }

    @Override
    public Map<ColumnMetadata, ViewExpression> getColumnMasks(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName tableName, List<ColumnMetadata> columns) {
        Map<ColumnMetadata, ViewExpression> superResult = super.getColumnMasks(transactionId, identity, context, tableName, columns);
        ImmutableMap.Builder columnMaskBuilder = ImmutableMap.builder();
        for (ColumnMetadata column : columns) {
            ColumnMaskKey columnMaskKey = new ColumnMaskKey(identity.getUser(), tableName, column.getName());
            if (this.columnMasks.containsKey(columnMaskKey)) {
                columnMaskBuilder.put((Object)column, (Object)this.columnMasks.get(columnMaskKey));
                continue;
            }
            if (!superResult.containsKey(column)) continue;
            columnMaskBuilder.put((Object)column, (Object)superResult.get(column));
        }
        return columnMaskBuilder.buildOrThrow();
    }

    private boolean shouldDenyPrivilege(String userName, String entityName, TestingPrivilegeType type) {
        TestingPrivilege testPrivilege = TestingAccessControlManager.privilege(userName, entityName, type);
        for (TestingPrivilege denyPrivilege : this.denyPrivileges) {
            if (!denyPrivilege.matches(testPrivilege)) continue;
            return true;
        }
        return false;
    }

    public static class TestingPrivilege {
        private final Optional<String> userName;
        private final String entityName;
        private final TestingPrivilegeType type;

        private TestingPrivilege(Optional<String> userName, String entityName, TestingPrivilegeType type) {
            this.userName = Objects.requireNonNull(userName, "userName is null");
            this.entityName = Objects.requireNonNull(entityName, "entityName is null");
            this.type = Objects.requireNonNull(type, "type is null");
        }

        public boolean matches(TestingPrivilege testPrivilege) {
            return this.userName.map(name -> testPrivilege.userName.get().equals(name)).orElse(true) != false && this.entityName.equals(testPrivilege.entityName) && this.type == testPrivilege.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestingPrivilege that = (TestingPrivilege)o;
            return Objects.equals(this.entityName, that.entityName) && Objects.equals((Object)this.type, (Object)that.type);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.entityName, this.type});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("userName", this.userName).add("entityName", (Object)this.entityName).add("type", (Object)this.type).toString();
        }
    }

    public static enum TestingPrivilegeType {
        SET_USER,
        CREATE_SCHEMA,
        DROP_SCHEMA,
        RENAME_SCHEMA,
        SHOW_CREATE_TABLE,
        CREATE_TABLE,
        DROP_TABLE,
        RENAME_TABLE,
        INSERT_TABLE,
        DELETE_TABLE,
        TRUNCATE_TABLE,
        UPDATE_TABLE,
        ADD_COLUMN,
        DROP_COLUMN,
        RENAME_COLUMN,
        SELECT_COLUMN,
        ADD_CONSTRAINT,
        DROP_CONSTRAINT,
        CREATE_VIEW,
        RENAME_VIEW,
        DROP_VIEW,
        CREATE_VIEW_WITH_SELECT_COLUMNS,
        SET_TABLE_PROPERTIES,
        SET_SESSION;

    }

    private static class RowFilterKey {
        private final String identity;
        private final QualifiedObjectName table;

        public RowFilterKey(String identity, QualifiedObjectName table) {
            this.identity = Objects.requireNonNull(identity, "identity is null");
            this.table = Objects.requireNonNull(table, "table is null");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RowFilterKey that = (RowFilterKey)o;
            return this.identity.equals(that.identity) && this.table.equals((Object)that.table);
        }

        public int hashCode() {
            return Objects.hash(this.identity, this.table);
        }
    }

    private static class ColumnMaskKey {
        private final String identity;
        private final QualifiedObjectName table;
        private final String column;

        public ColumnMaskKey(String identity, QualifiedObjectName table, String column) {
            this.identity = identity;
            this.table = table;
            this.column = column;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ColumnMaskKey that = (ColumnMaskKey)o;
            return this.identity.equals(that.identity) && this.table.equals((Object)that.table) && this.column.equals(that.column);
        }

        public int hashCode() {
            return Objects.hash(this.identity, this.table, this.column);
        }
    }
}

