/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.rewrite;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.UnknownTypeException;
import com.facebook.presto.common.type.BigintEnumType;
import com.facebook.presto.common.type.EnumType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeWithName;
import com.facebook.presto.common.type.VarcharEnumType;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.sql.analyzer.FunctionAndTypeResolver;
import com.facebook.presto.sql.analyzer.QueryExplainer;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.rewrite.DefaultTreeRewriter;
import com.facebook.presto.sql.rewrite.StatementRewrite;
import com.facebook.presto.sql.tree.ArrayConstructor;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.DereferenceExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.Parameter;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.sql.tree.StringLiteral;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

final class NativeExecutionTypeRewrite
implements StatementRewrite.Rewrite {
    private static final Logger LOG = Logger.get(ExpressionRewriter.class);
    private static final String FUNCTION_ENUM_KEY = "enum_key";
    private static final String FUNCTION_ELEMENT_AT = "element_at";
    private static final String FUNCTION_MAP = "map";

    NativeExecutionTypeRewrite() {
    }

    @Override
    public Statement rewrite(Session session, Metadata metadata, SqlParser parser, Optional<QueryExplainer> queryExplainer, Statement node, List<Expression> parameters, Map<NodeRef<Parameter>, Expression> parameterLookup, AccessControl accessControl, WarningCollector warningCollector, String query) {
        if (SystemSessionProperties.isNativeExecutionEnabled(session) && SystemSessionProperties.isNativeExecutionTypeRewriteEnabled(session)) {
            return (Statement)new Rewriter(metadata.getFunctionAndTypeManager().getFunctionAndTypeResolver()).process((Node)node, null);
        }
        return node;
    }

    public static Expression rewriteEnumExpressions(Expression expression, FunctionAndTypeResolver functionAndTypeResolver) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new EnumExpressionRewriter(functionAndTypeResolver), (Expression)expression);
    }

    private static final class Rewriter
    extends DefaultTreeRewriter<Void> {
        private final FunctionAndTypeResolver functionAndTypeResolver;

        public Rewriter(FunctionAndTypeResolver functionAndTypeResolver) {
            this.functionAndTypeResolver = Objects.requireNonNull(functionAndTypeResolver, "functionAndTypeResolver is null");
        }

        @Override
        protected Node visitExpression(Expression node, Void context) {
            return NativeExecutionTypeRewrite.rewriteEnumExpressions(node, this.functionAndTypeResolver);
        }

        @Override
        protected Node visitFunctionCall(FunctionCall node, Void context) {
            return NativeExecutionTypeRewrite.rewriteEnumExpressions((Expression)node, this.functionAndTypeResolver);
        }
    }

    private static class EnumExpressionRewriter
    extends ExpressionRewriter<Void> {
        private final FunctionAndTypeResolver functionAndTypeResolver;

        public EnumExpressionRewriter(FunctionAndTypeResolver functionAndTypeResolver) {
            this.functionAndTypeResolver = functionAndTypeResolver;
        }

        private Expression convertEnumTypeToLiteral(DereferenceExpression key, Type type) {
            String enumKey = key.getField().getValue().toUpperCase();
            if (type instanceof BigintEnumType) {
                Map enumMap = ((EnumType)type).getEnumMap();
                Long enumValue = (Long)enumMap.get(enumKey);
                if (enumValue == null) {
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, ".*'" + type.getDisplayName() + "." + key.getField().getValue() + "' cannot be resolved", new Object[0]);
                }
                return new Cast((Expression)new LongLiteral(enumValue.toString()), "bigint");
            }
            if (type instanceof VarcharEnumType) {
                Map enumMap = ((EnumType)type).getEnumMap();
                String enumValue = (String)enumMap.get(enumKey);
                if (enumValue == null) {
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, ".*'" + type.getDisplayName() + "." + key.getField().getValue() + "' cannot be resolved", new Object[0]);
                }
                return new StringLiteral(enumValue);
            }
            return key;
        }

        public Expression rewriteExpression(Expression expression, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            return treeRewriter.defaultRewrite(expression, null);
        }

        public Expression rewriteDereferenceExpression(DereferenceExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            try {
                Type argumentType = this.functionAndTypeResolver.getType(TypeSignature.parseTypeSignature((String)node.getBase().toString()));
                if (argumentType instanceof TypeWithName && (argumentType = ((TypeWithName)argumentType).getType()) instanceof EnumType) {
                    return this.convertEnumTypeToLiteral(node, argumentType);
                }
            }
            catch (UnknownTypeException | IllegalArgumentException e) {
                LOG.warn(((Throwable)e).getMessage());
                return node;
            }
            return node;
        }

        public Expression rewriteCast(Cast node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            node = (Cast)treeRewriter.defaultRewrite((Expression)node, null);
            try {
                Type type = this.functionAndTypeResolver.getType(TypeSignature.parseTypeSignature((String)node.getType()));
                if (type instanceof TypeWithName) {
                    type = ((TypeWithName)type).getType();
                    switch (type.getTypeSignature().getBase()) {
                        case "BigintEnum": {
                            return new Cast(node.getLocation(), node.getExpression(), "bigint", node.isSafe(), node.isTypeOnly());
                        }
                        case "VarcharEnum": {
                            return new Cast(node.getLocation(), node.getExpression(), "varchar", node.isSafe(), node.isTypeOnly());
                        }
                    }
                    return new Cast(node.getLocation(), node.getExpression(), type.getTypeSignature().getBase(), node.isSafe(), node.isTypeOnly());
                }
            }
            catch (UnknownTypeException | IllegalArgumentException e) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "Unknown type: " + node.getType(), new Object[0]);
            }
            return node;
        }

        private boolean isValidEnumKeyFunctionCall(FunctionCall node) {
            return node.getName().equals((Object)QualifiedName.of((String)NativeExecutionTypeRewrite.FUNCTION_ENUM_KEY)) && node.getArguments().size() == 1;
        }

        private Expression convertEnumTypeToMapExpression(Type type) {
            ImmutableList.Builder keys = ImmutableList.builder();
            ImmutableList.Builder values = ImmutableList.builder();
            switch (type.getTypeSignature().getBase()) {
                case "BigintEnum": {
                    for (Map.Entry entry : ((BigintEnumType)type).getEnumMap().entrySet()) {
                        keys.add((Object)new LongLiteral(((Long)entry.getValue()).toString()));
                        values.add((Object)new StringLiteral((String)entry.getKey()));
                    }
                    break;
                }
                case "VarcharEnum": {
                    for (Map.Entry entry : ((VarcharEnumType)type).getEnumMap().entrySet()) {
                        keys.add((Object)new StringLiteral((String)entry.getValue()));
                        values.add((Object)new StringLiteral((String)entry.getKey()));
                    }
                    break;
                }
                default: {
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, "Unknown type: " + type, new Object[0]);
                }
            }
            return new FunctionCall(QualifiedName.of((String)NativeExecutionTypeRewrite.FUNCTION_MAP), (List)ImmutableList.of((Object)new ArrayConstructor((List)keys.build()), (Object)new ArrayConstructor((List)values.build())));
        }

        public Expression rewriteFunctionCall(FunctionCall node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            QualifiedName functionName = node.getName();
            List arguments = node.getArguments();
            if (this.isValidEnumKeyFunctionCall(node)) {
                Type argumentType;
                Expression argument = (Expression)arguments.get(0);
                functionName = QualifiedName.of((String)NativeExecutionTypeRewrite.FUNCTION_ELEMENT_AT);
                if (argument instanceof Cast) {
                    argumentType = this.functionAndTypeResolver.getType(TypeSignature.parseTypeSignature((String)((Cast)argument).getType()));
                } else if (argument instanceof DereferenceExpression) {
                    argumentType = this.functionAndTypeResolver.getType(TypeSignature.parseTypeSignature((String)((DereferenceExpression)argument).getBase().toString()));
                } else {
                    return node;
                }
                if (argumentType instanceof TypeWithName) {
                    argumentType = ((TypeWithName)argumentType).getType();
                    Expression enumMapExpression = this.convertEnumTypeToMapExpression(argumentType);
                    Expression enumValue = treeRewriter.rewrite(argument, null);
                    if (argumentType instanceof EnumType) {
                        arguments = ImmutableList.of((Object)enumMapExpression, (Object)enumValue);
                    }
                }
            } else {
                node = (FunctionCall)treeRewriter.defaultRewrite((Expression)node, null);
                arguments = node.getArguments();
            }
            return node.getLocation().isPresent() ? new FunctionCall((NodeLocation)node.getLocation().get(), functionName, node.getWindow(), node.getFilter(), node.getOrderBy(), node.isDistinct(), node.isIgnoreNulls(), arguments) : new FunctionCall(functionName, node.getWindow(), node.getFilter(), node.getOrderBy(), node.isDistinct(), node.isIgnoreNulls(), arguments);
        }
    }
}

