/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.sanity;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.PrestoWarning;
import com.facebook.presto.spi.StandardWarningCode;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.TableLayoutFilterCoverage;
import com.facebook.presto.spi.WarningCodeSupplier;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.planner.optimizations.PlanNodeSearcher;
import com.facebook.presto.sql.planner.sanity.PlanChecker;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import java.util.Set;

public final class WarnOnScanWithoutPartitionPredicate
implements PlanChecker.Checker {
    private final Set<String> warnOnNoTableLayoutFilter;

    WarnOnScanWithoutPartitionPredicate(FeaturesConfig featuresConfig) {
        this.warnOnNoTableLayoutFilter = ImmutableSet.copyOf((Iterable)Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)featuresConfig.getWarnOnNoTableLayoutFilter()));
    }

    @Override
    public void validate(PlanNode plan, Session session, Metadata metadata, WarningCollector warningCollector) {
        for (TableScanNode scan : PlanNodeSearcher.searchFrom(plan).where(TableScanNode.class::isInstance).findAll()) {
            TableHandle tableHandle = scan.getTable();
            TableLayoutFilterCoverage partitioningFilterCoverage = metadata.getTableLayoutFilterCoverage(session, tableHandle, this.warnOnNoTableLayoutFilter);
            if (partitioningFilterCoverage != TableLayoutFilterCoverage.NOT_COVERED) continue;
            String warningMessage = String.format("No partition filter for scan of table %s", scan.getTable().getConnectorHandle());
            warningCollector.add(new PrestoWarning((WarningCodeSupplier)StandardWarningCode.PERFORMANCE_WARNING, warningMessage));
        }
    }
}

