/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.sanity;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.plan.PlanCheckerProvider;
import com.facebook.presto.spi.plan.PlanCheckerProviderContext;
import com.facebook.presto.spi.plan.PlanCheckerProviderFactory;
import com.facebook.presto.spi.plan.SimplePlanFragmentSerde;
import com.facebook.presto.sql.planner.sanity.PlanCheckerProviderManagerConfig;
import com.facebook.presto.util.PropertiesUtil;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class PlanCheckerProviderManager {
    private static final Logger log = Logger.get(PlanCheckerProviderManager.class);
    private static final String PLAN_CHECKER_PROVIDER_NAME = "plan-checker-provider.name";
    private final SimplePlanFragmentSerde simplePlanFragmentSerde;
    private final Map<String, PlanCheckerProviderFactory> providerFactories = new ConcurrentHashMap<String, PlanCheckerProviderFactory>();
    private final CopyOnWriteArrayList<PlanCheckerProvider> providers = new CopyOnWriteArrayList();
    private final File configDirectory;

    @Inject
    public PlanCheckerProviderManager(SimplePlanFragmentSerde simplePlanFragmentSerde, PlanCheckerProviderManagerConfig config) {
        this.simplePlanFragmentSerde = Objects.requireNonNull(simplePlanFragmentSerde, "planNodeSerde is null");
        Objects.requireNonNull(config, "config is null");
        this.configDirectory = Objects.requireNonNull(config.getPlanCheckerConfigurationDir(), "configDirectory is null");
    }

    public void addPlanCheckerProviderFactory(PlanCheckerProviderFactory planCheckerProviderFactory) {
        Objects.requireNonNull(planCheckerProviderFactory, "planCheckerProviderFactory is null");
        if (this.providerFactories.putIfAbsent(planCheckerProviderFactory.getName(), planCheckerProviderFactory) != null) {
            throw new IllegalArgumentException(String.format("PlanCheckerProviderFactory '%s' is already registered", planCheckerProviderFactory.getName()));
        }
    }

    public void loadPlanCheckerProviders(NodeManager nodeManager) throws IOException {
        for (File file : PlanCheckerProviderManager.listFiles(this.configDirectory)) {
            if (!file.isFile() || !file.getName().endsWith(".properties")) continue;
            HashMap<String, String> properties = new HashMap<String, String>(PropertiesUtil.loadProperties(file));
            String planCheckerProviderName = (String)properties.remove(PLAN_CHECKER_PROVIDER_NAME);
            Preconditions.checkState((!Strings.isNullOrEmpty((String)planCheckerProviderName) ? 1 : 0) != 0, (String)"Plan checker configuration %s does not contain %s", (Object)file.getAbsoluteFile(), (Object)PLAN_CHECKER_PROVIDER_NAME);
            this.loadPlanCheckerProvider(planCheckerProviderName, properties, nodeManager);
        }
    }

    public void loadPlanCheckerProvider(String planCheckerProviderName, Map<String, String> properties, NodeManager nodeManager) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)planCheckerProviderName) ? 1 : 0) != 0, (Object)"Plan checker provider name is null or empty");
        Objects.requireNonNull(properties, "properties is null");
        Objects.requireNonNull(nodeManager, "nodeManager is null");
        PlanCheckerProviderContext planCheckerProviderContext = new PlanCheckerProviderContext(this.simplePlanFragmentSerde, nodeManager);
        log.info("-- Loading plan checker provider [%s] --", new Object[]{planCheckerProviderName});
        PlanCheckerProviderFactory providerFactory = this.providerFactories.get(planCheckerProviderName);
        Preconditions.checkState((providerFactory != null ? 1 : 0) != 0, (String)"No planCheckerProviderFactory found for '%s'. Available factories were %s", (Object)planCheckerProviderName, this.providerFactories.keySet());
        this.providers.addIfAbsent(providerFactory.create(properties, planCheckerProviderContext));
        log.info("-- Added plan checker provider [%s] --", new Object[]{planCheckerProviderName});
    }

    private static List<File> listFiles(File dir) {
        Object[] files;
        if (dir != null && dir.isDirectory() && (files = dir.listFiles()) != null) {
            return ImmutableList.copyOf((Object[])files);
        }
        return ImmutableList.of();
    }

    public List<PlanCheckerProvider> getPlanCheckerProviders() {
        return this.providers;
    }
}

