/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.sanity;

import com.facebook.presto.Session;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.TimestampWithTimeZoneType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.expressions.DefaultRowExpressionTraversalVisitor;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.plan.WindowNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.InputReferenceExpression;
import com.facebook.presto.spi.relation.IntermediateFormExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.planner.SimplePlanVisitor;
import com.facebook.presto.sql.planner.sanity.PlanChecker;
import com.facebook.presto.type.IpAddressType;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class CheckUnsupportedPrestissimoTypes
implements PlanChecker.Checker {
    private static final String timestampWithTimeszoneErrorMessage = "Timestamp with Timezone type is not supported in Prestissimo";
    private static final String ipAddressErrorMessage = "IPAddress type is not supported in Prestissimo";
    private FeaturesConfig config;

    public CheckUnsupportedPrestissimoTypes(FeaturesConfig config) {
        this.config = Objects.requireNonNull(config);
    }

    @Override
    public void validate(PlanNode planNode, Session session, Metadata metadata, WarningCollector warningCollector) {
        planNode.accept((PlanVisitor)new Visitor(), null);
    }

    private Optional<String> getUnsupportedTypeErrorMessage(Type type) {
        if (type.equals(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE) && this.config.isDisableTimeStampWithTimeZoneForNative()) {
            return Optional.of(timestampWithTimeszoneErrorMessage);
        }
        if (type.equals((Object)IpAddressType.IPADDRESS) && this.config.isDisableIPAddressForNative()) {
            return Optional.of(ipAddressErrorMessage);
        }
        if (type instanceof ArrayType) {
            return this.getUnsupportedTypeErrorMessage(((ArrayType)type).getElementType());
        }
        if (type instanceof MapType) {
            Optional<String> key = this.getUnsupportedTypeErrorMessage(((MapType)type).getKeyType());
            return key.isPresent() ? key : this.getUnsupportedTypeErrorMessage(((MapType)type).getValueType());
        }
        if (type instanceof RowType) {
            return ((RowType)type).getTypeParameters().stream().map(this::getUnsupportedTypeErrorMessage).filter(opt -> opt.isPresent()).findFirst().orElse(Optional.empty());
        }
        return Optional.empty();
    }

    private class Visitor
    extends SimplePlanVisitor<Void> {
        private final UnsupportedTypeChecker unsupportedTypeChecker;

        public Visitor() {
            this.unsupportedTypeChecker = new UnsupportedTypeChecker();
        }

        @Override
        public Void visitPlan(PlanNode node, Void context) {
            Optional<String> res = node.getOutputVariables().stream().map(x -> CheckUnsupportedPrestissimoTypes.this.getUnsupportedTypeErrorMessage(x.getType())).filter(Objects::nonNull).findFirst().orElse(Optional.empty());
            res.ifPresent(str -> Preconditions.checkState((boolean)false, (Object)str));
            return super.visitPlan(node, context);
        }

        public Void visitAggregation(AggregationNode node, Void context) {
            this.visitPlan((PlanNode)node, context);
            node.getAggregations().forEach((variable, aggregation) -> {
                aggregation.getCall().accept((RowExpressionVisitor)this.unsupportedTypeChecker, null);
                if (aggregation.getFilter().isPresent()) {
                    ((RowExpression)aggregation.getFilter().get()).accept((RowExpressionVisitor)this.unsupportedTypeChecker, null);
                }
            });
            return null;
        }

        public Void visitWindow(WindowNode node, Void context) {
            this.visitPlan((PlanNode)node, context);
            node.getWindowFunctions().forEach((variable, function) -> function.getFunctionCall().accept((RowExpressionVisitor)this.unsupportedTypeChecker, null));
            return null;
        }

        public Void visitProject(ProjectNode node, Void context) {
            this.visitPlan((PlanNode)node, context);
            node.getAssignments().getMap().forEach((variable, expression) -> expression.accept((RowExpressionVisitor)this.unsupportedTypeChecker, null));
            return null;
        }

        public Void visitValues(ValuesNode node, Void context) {
            this.visitPlan((PlanNode)node, context);
            for (List row : node.getRows()) {
                row.forEach(x -> x.accept((RowExpressionVisitor)this.unsupportedTypeChecker, null));
            }
            return null;
        }

        public Void visitFilter(FilterNode node, Void context) {
            this.visitPlan((PlanNode)node, context);
            node.getPredicate().accept((RowExpressionVisitor)this.unsupportedTypeChecker, null);
            return null;
        }
    }

    private class UnsupportedTypeChecker
    extends DefaultRowExpressionTraversalVisitor<Void> {
        private UnsupportedTypeChecker() {
        }

        public Void visitConstant(ConstantExpression literal, Void context) {
            Optional errorMessage = CheckUnsupportedPrestissimoTypes.this.getUnsupportedTypeErrorMessage(literal.getType());
            Preconditions.checkState((!errorMessage.isPresent() ? 1 : 0) != 0, (Object)errorMessage);
            return null;
        }

        public Void visitVariableReference(VariableReferenceExpression reference, Void context) {
            CheckUnsupportedPrestissimoTypes.this.getUnsupportedTypeErrorMessage(reference.getType()).ifPresent(str -> Preconditions.checkState((boolean)false, (Object)str));
            return null;
        }

        public Void visitInputReference(InputReferenceExpression input, Void context) {
            CheckUnsupportedPrestissimoTypes.this.getUnsupportedTypeErrorMessage(input.getType()).ifPresent(str -> Preconditions.checkState((boolean)false, (Object)str));
            return null;
        }

        public Void visitCall(CallExpression call, Void context) {
            CheckUnsupportedPrestissimoTypes.this.getUnsupportedTypeErrorMessage(call.getType()).ifPresent(str -> Preconditions.checkState((boolean)false, (Object)str));
            return super.visitCall(call, (Object)context);
        }

        public Void visitSpecialForm(SpecialFormExpression specialForm, Void context) {
            CheckUnsupportedPrestissimoTypes.this.getUnsupportedTypeErrorMessage(specialForm.getType()).ifPresent(str -> Preconditions.checkState((boolean)false, (Object)str));
            return super.visitSpecialForm(specialForm, (Object)context);
        }

        public Void visitIntermediateFormExpression(IntermediateFormExpression expression, Void context) {
            CheckUnsupportedPrestissimoTypes.this.getUnsupportedTypeErrorMessage(expression.getType()).ifPresent(str -> Preconditions.checkState((boolean)false, (Object)str));
            return super.visitIntermediateFormExpression(expression, (Object)context);
        }
    }
}

