/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.planPrinter;

import com.facebook.presto.spi.eventlistener.CTEInformation;
import com.facebook.presto.spi.eventlistener.PlanOptimizerInformation;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.optimizations.OptimizerResult;
import com.facebook.presto.sql.planner.planPrinter.NodeRepresentation;
import io.airlift.units.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class PlanRepresentation {
    private final PlanNode root;
    private final Optional<Duration> totalCpuTime;
    private final Optional<Duration> totalScheduledTime;
    private final TypeProvider types;
    private final Map<PlanNodeId, NodeRepresentation> nodeInfo = new HashMap<PlanNodeId, NodeRepresentation>();
    private final List<PlanOptimizerInformation> planOptimizerInfo;
    private final List<CTEInformation> cteInformationList;
    private final List<OptimizerResult> planOptimizerResults;

    public PlanRepresentation(PlanNode root, TypeProvider types, Optional<Duration> totalCpuTime, Optional<Duration> totalScheduledTime, List<PlanOptimizerInformation> planOptimizerInfo, List<CTEInformation> cteInformationList, List<OptimizerResult> planOptimizerResults) {
        this.root = Objects.requireNonNull(root, "root is null");
        this.totalCpuTime = Objects.requireNonNull(totalCpuTime, "totalCpuTime is null");
        this.types = Objects.requireNonNull(types, "types is null");
        this.totalScheduledTime = Objects.requireNonNull(totalScheduledTime, "totalScheduledTime is null");
        this.planOptimizerInfo = Objects.requireNonNull(planOptimizerInfo, "planOptimizerInfo is null");
        this.cteInformationList = Objects.requireNonNull(cteInformationList, "cteInformationList is null");
        this.planOptimizerResults = Objects.requireNonNull(planOptimizerResults, "planOptimizerResults is null");
    }

    public NodeRepresentation getRoot() {
        return this.nodeInfo.get(this.root.getId());
    }

    public TypeProvider getTypes() {
        return this.types;
    }

    public Optional<Duration> getTotalCpuTime() {
        return this.totalCpuTime;
    }

    public Optional<Duration> getTotalScheduledTime() {
        return this.totalScheduledTime;
    }

    public Optional<NodeRepresentation> getNode(PlanNodeId id) {
        return Optional.ofNullable(this.nodeInfo.get(id));
    }

    public PlanNode getPlanNodeRoot() {
        return this.root;
    }

    public void addNode(NodeRepresentation node) {
        NodeRepresentation previous = this.nodeInfo.put(node.getId(), node);
        if (previous != null) {
            throw new IllegalStateException(String.format("Duplicate node ID %s: %s vs. %s", node.getId(), previous.getName(), node.getName()));
        }
    }

    public List<PlanOptimizerInformation> getPlanOptimizerInfo() {
        return this.planOptimizerInfo;
    }

    public List<CTEInformation> getCteInformationList() {
        return this.cteInformationList;
    }

    public List<OptimizerResult> getPlanOptimizerResults() {
        return this.planOptimizerResults;
    }
}

