/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.spi.SourceLocation;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.plan.InternalPlanNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class UpdateNode
extends InternalPlanNode {
    private final PlanNode source;
    private final Optional<VariableReferenceExpression> rowId;
    private final List<VariableReferenceExpression> columnValueAndRowIdSymbols;
    private final List<VariableReferenceExpression> outputVariables;

    @JsonCreator
    public UpdateNode(Optional<SourceLocation> sourceLocation, @JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="rowId") Optional<VariableReferenceExpression> rowId, @JsonProperty(value="columnValueAndRowIdSymbols") List<VariableReferenceExpression> columnValueAndRowIdSymbols, @JsonProperty(value="outputVariables") List<VariableReferenceExpression> outputVariables) {
        this(source.getSourceLocation(), id, Optional.empty(), source, rowId, columnValueAndRowIdSymbols, outputVariables);
    }

    public UpdateNode(Optional<SourceLocation> sourceLocation, PlanNodeId id, Optional<PlanNode> statsEquivalentPlanNode, PlanNode source, Optional<VariableReferenceExpression> rowId, List<VariableReferenceExpression> columnValueAndRowIdSymbols, List<VariableReferenceExpression> outputVariables) {
        super(sourceLocation, id, statsEquivalentPlanNode);
        this.source = Objects.requireNonNull(source, "source is null");
        this.rowId = Objects.requireNonNull(rowId, "rowId is null");
        this.columnValueAndRowIdSymbols = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnValueAndRowIdSymbols, "columnValueAndRowIdSymbols is null"));
        this.outputVariables = ImmutableList.copyOf((Collection)Objects.requireNonNull(outputVariables, "outputVariables is null"));
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public Optional<VariableReferenceExpression> getRowId() {
        return this.rowId;
    }

    @JsonProperty
    public List<VariableReferenceExpression> getColumnValueAndRowIdSymbols() {
        return this.columnValueAndRowIdSymbols;
    }

    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @JsonProperty
    public List<VariableReferenceExpression> getOutputVariables() {
        return this.outputVariables;
    }

    @Override
    public <R, C> R accept(InternalPlanVisitor<R, C> visitor, C context) {
        return visitor.visitUpdate(this, context);
    }

    public PlanNode assignStatsEquivalentPlanNode(Optional<PlanNode> statsEquivalentPlanNode) {
        return new UpdateNode(this.getSourceLocation(), this.getId(), statsEquivalentPlanNode, this.source, this.rowId, this.columnValueAndRowIdSymbols, this.outputVariables);
    }

    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new UpdateNode(this.getSourceLocation(), this.getId(), this.getStatsEquivalentPlanNode(), (PlanNode)Iterables.getOnlyElement(newChildren), this.rowId, this.columnValueAndRowIdSymbols, this.outputVariables);
    }
}

