/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.spi.SourceLocation;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.plan.InternalPlanNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.ImmutableGraph;
import com.google.common.graph.MutableGraph;
import com.google.common.graph.SuccessorsFunction;
import com.google.common.graph.Traverser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class SequenceNode
extends InternalPlanNode {
    private final List<PlanNode> cteProducers;
    private final PlanNode primarySource;
    private final Graph<Integer> cteDependencyGraph;

    @JsonCreator
    public SequenceNode(Optional<SourceLocation> sourceLocation, @JsonProperty(value="id") PlanNodeId planNodeId, @JsonProperty(value="cteProducers") List<PlanNode> cteProducerList, @JsonProperty(value="primarySource") PlanNode primarySource, Graph<Integer> cteDependencyGraph) {
        this(sourceLocation, planNodeId, Optional.empty(), cteProducerList, primarySource, cteDependencyGraph);
    }

    public SequenceNode(Optional<SourceLocation> sourceLocation, PlanNodeId planNodeId, Optional<PlanNode> statsEquivalentPlanNode, List<PlanNode> cteProducerList, PlanNode primarySource, Graph<Integer> cteDependencyGraph) {
        super(sourceLocation, planNodeId, statsEquivalentPlanNode);
        this.cteProducers = ImmutableList.copyOf(cteProducerList);
        this.primarySource = primarySource;
        Preconditions.checkArgument((boolean)cteDependencyGraph.isDirected(), (Object)"Sequence Node expects a directed graph");
        IntStream.range(0, cteProducerList.size()).forEach(i -> Preconditions.checkArgument((boolean)cteDependencyGraph.nodes().contains(i), (Object)("Sequence Node Error: The cteProducer at index " + i + " is missing in the cte dependency graph.")));
        this.cteDependencyGraph = ImmutableGraph.copyOf(cteDependencyGraph);
    }

    @JsonProperty
    public List<PlanNode> getCteProducers() {
        return this.cteProducers;
    }

    @JsonProperty
    public PlanNode getPrimarySource() {
        return this.primarySource;
    }

    public List<PlanNode> getSources() {
        ArrayList<PlanNode> children = new ArrayList<PlanNode>(this.cteProducers);
        children.add(this.primarySource);
        return children;
    }

    public List<VariableReferenceExpression> getOutputVariables() {
        return this.primarySource.getOutputVariables();
    }

    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Preconditions.checkArgument((newChildren.size() == this.cteProducers.size() + 1 ? 1 : 0) != 0, (Object)"expected newChildren to contain same number of nodes as current. If the child count please update the dependency graph");
        return new SequenceNode(newChildren.get(0).getSourceLocation(), this.getId(), this.getStatsEquivalentPlanNode(), newChildren.subList(0, newChildren.size() - 1), newChildren.get(newChildren.size() - 1), this.cteDependencyGraph);
    }

    public PlanNode assignStatsEquivalentPlanNode(Optional<PlanNode> statsEquivalentPlanNode) {
        return new SequenceNode(this.getSourceLocation(), this.getId(), statsEquivalentPlanNode, this.cteProducers, this.getPrimarySource(), this.cteDependencyGraph);
    }

    public Graph<Integer> getCteDependencyGraph() {
        return this.cteDependencyGraph;
    }

    public Graph<Integer> removeCteProducersFromCteDependencyGraph(Set<Integer> indexesToRemove) {
        if (indexesToRemove.isEmpty()) {
            return ImmutableGraph.copyOf(this.getCteDependencyGraph());
        }
        Graph<Integer> originalGraph = this.getCteDependencyGraph();
        MutableGraph newCteDependencyGraph = GraphBuilder.from(this.getCteDependencyGraph()).build();
        HashMap<Integer, Integer> indexMapping = new HashMap<Integer, Integer>();
        int removed = 0;
        for (int prevIndex = 0; prevIndex < this.cteProducers.size(); ++prevIndex) {
            if (indexesToRemove.contains(prevIndex)) {
                ++removed;
                continue;
            }
            int newIndex = prevIndex - removed;
            indexMapping.put(prevIndex, newIndex);
        }
        Iterator iterator = originalGraph.nodes().iterator();
        while (iterator.hasNext()) {
            int oldIndex = (Integer)iterator.next();
            if (indexesToRemove.contains(oldIndex)) continue;
            Integer newIndex = (Integer)indexMapping.get(oldIndex);
            newCteDependencyGraph.addNode((Object)newIndex);
            for (Integer successor : originalGraph.successors((Object)oldIndex)) {
                if (indexesToRemove.contains(successor)) continue;
                Integer newSuccessorIndex = (Integer)indexMapping.get(successor);
                newCteDependencyGraph.putEdge((Object)newIndex, (Object)newSuccessorIndex);
            }
        }
        return ImmutableGraph.copyOf((Graph)newCteDependencyGraph);
    }

    public List<List<PlanNode>> getIndependentCteProducers() {
        MutableGraph undirectedDependencyGraph = GraphBuilder.undirected().allowsSelfLoops(false).build();
        this.cteDependencyGraph.nodes().forEach(arg_0 -> ((MutableGraph)undirectedDependencyGraph).addNode(arg_0));
        this.cteDependencyGraph.edges().forEach(edge -> undirectedDependencyGraph.putEdge((Object)((Integer)edge.nodeU()), (Object)((Integer)edge.nodeV())));
        HashSet visitedCteSet = new HashSet();
        ImmutableList.Builder independentCteProducerList = ImmutableList.builder();
        ArrayList result = new ArrayList();
        for (Integer cteIndex : this.cteDependencyGraph.nodes()) {
            if (visitedCteSet.contains(cteIndex)) continue;
            HashSet componentNodes = new HashSet();
            Traverser.forGraph((SuccessorsFunction)undirectedDependencyGraph).breadthFirst((Object)cteIndex).forEach(componentNode -> {
                if (visitedCteSet.add(componentNode)) {
                    componentNodes.add(componentNode);
                }
            });
            ArrayList topSortedCteProducerList = new ArrayList();
            Traverser.forGraph(this.cteDependencyGraph).depthFirstPostOrder(componentNodes).forEach(topSortedCteProducerList::add);
            if (topSortedCteProducerList.isEmpty()) continue;
            independentCteProducerList.add(topSortedCteProducerList.stream().map(index -> this.cteProducers.get((int)index)).collect(Collectors.toList()));
        }
        return independentCteProducerList.build();
    }

    @Override
    public <R, C> R accept(InternalPlanVisitor<R, C> visitor, C context) {
        return visitor.visitSequence(this, context);
    }
}

