/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.spi.SourceLocation;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.plan.InternalPlanNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class SampleNode
extends InternalPlanNode {
    private final PlanNode source;
    private final double sampleRatio;
    private final Type sampleType;

    @JsonCreator
    public SampleNode(Optional<SourceLocation> sourceLocation, @JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="sampleRatio") double sampleRatio, @JsonProperty(value="sampleType") Type sampleType) {
        this(sourceLocation, id, Optional.empty(), source, sampleRatio, sampleType);
    }

    public SampleNode(Optional<SourceLocation> sourceLocation, PlanNodeId id, Optional<PlanNode> statsEquivalentPlanNode, PlanNode source, double sampleRatio, Type sampleType) {
        super(sourceLocation, id, statsEquivalentPlanNode);
        Preconditions.checkArgument((sampleRatio >= 0.0 ? 1 : 0) != 0, (Object)"sample ratio must be greater than or equal to 0");
        Preconditions.checkArgument((sampleRatio <= 1.0 ? 1 : 0) != 0, (Object)"sample ratio must be less than or equal to 1");
        this.sampleType = Objects.requireNonNull(sampleType, "sample type is null");
        this.source = Objects.requireNonNull(source, "source is null");
        this.sampleRatio = sampleRatio;
    }

    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public double getSampleRatio() {
        return this.sampleRatio;
    }

    @JsonProperty
    public Type getSampleType() {
        return this.sampleType;
    }

    public List<VariableReferenceExpression> getOutputVariables() {
        return this.source.getOutputVariables();
    }

    @Override
    public <R, C> R accept(InternalPlanVisitor<R, C> visitor, C context) {
        return visitor.visitSample(this, context);
    }

    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new SampleNode(this.getSourceLocation(), this.getId(), this.getStatsEquivalentPlanNode(), (PlanNode)Iterables.getOnlyElement(newChildren), this.sampleRatio, this.sampleType);
    }

    public PlanNode assignStatsEquivalentPlanNode(Optional<PlanNode> statsEquivalentPlanNode) {
        return new SampleNode(this.getSourceLocation(), this.getId(), statsEquivalentPlanNode, this.source, this.sampleRatio, this.sampleType);
    }

    public static enum Type {
        BERNOULLI,
        SYSTEM;

    }
}

