/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.CanonicalJoinNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class MultiJoinNode {
    protected CanonicalJoinNode node;
    protected Assignments assignments;
    private final boolean containsCombinedSources;
    private final Optional<RowExpression> joinFilter;

    public MultiJoinNode(LinkedHashSet<PlanNode> sources, RowExpression filter, List<VariableReferenceExpression> outputVariables, Assignments assignments, boolean containsCombinedSources, Optional<RowExpression> joinFilter) {
        Objects.requireNonNull(sources, "sources is null");
        Objects.requireNonNull(filter, "filter is null");
        Objects.requireNonNull(outputVariables, "outputVariables is null");
        Objects.requireNonNull(assignments, "assignments is null");
        this.assignments = assignments;
        this.node = new CanonicalJoinNode(new PlanNodeId(""), (List)sources.stream().collect(ImmutableList.toImmutableList()), JoinType.INNER, (Set<EquiJoinClause>)ImmutableSet.of(), (Set<RowExpression>)ImmutableSet.of((Object)filter), outputVariables);
        this.containsCombinedSources = containsCombinedSources;
        this.joinFilter = joinFilter;
    }

    public RowExpression getFilter() {
        return (RowExpression)this.node.getFilters().stream().findAny().get();
    }

    public LinkedHashSet<PlanNode> getSources() {
        return new LinkedHashSet<PlanNode>(this.node.getSources());
    }

    public List<VariableReferenceExpression> getOutputVariables() {
        return this.node.getOutputVariables();
    }

    public Assignments getAssignments() {
        return this.assignments;
    }

    public Optional<RowExpression> getJoinFilter() {
        return this.joinFilter;
    }

    public boolean getContainsCombinedSources() {
        return this.containsCombinedSources;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int hashCode() {
        return Objects.hash(this.getSources(), ImmutableSet.copyOf((Collection)LogicalRowExpressions.extractConjuncts((RowExpression)this.getFilter())), this.getOutputVariables());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MultiJoinNode)) {
            return false;
        }
        MultiJoinNode other = (MultiJoinNode)obj;
        return this.getSources().equals(other.getSources()) && ImmutableSet.copyOf((Collection)LogicalRowExpressions.extractConjuncts((RowExpression)this.getFilter())).equals((Object)ImmutableSet.copyOf((Collection)LogicalRowExpressions.extractConjuncts((RowExpression)other.getFilter()))) && this.getOutputVariables().equals(other.getOutputVariables()) && this.getAssignments().equals((Object)other.getAssignments());
    }

    public String toString() {
        return "MultiJoinNode{node=" + (Object)((Object)this.node) + ", assignments=" + this.assignments + '}';
    }

    public static class Builder {
        private List<PlanNode> sources;
        private RowExpression filter;
        private List<VariableReferenceExpression> outputVariables;
        private Assignments assignments = Assignments.of();
        private boolean containsCombinedSources;
        private Optional<RowExpression> joinFilter;

        public Builder setSources(PlanNode ... sources) {
            this.sources = ImmutableList.copyOf((Object[])sources);
            return this;
        }

        public Builder setFilter(RowExpression filter) {
            this.filter = filter;
            return this;
        }

        public Builder setAssignments(Assignments assignments) {
            this.assignments = assignments;
            return this;
        }

        public Builder setOutputVariables(VariableReferenceExpression ... outputVariables) {
            this.outputVariables = ImmutableList.copyOf((Object[])outputVariables);
            return this;
        }

        public Builder setContainsCombinedSources(boolean containsCombinedSources) {
            this.containsCombinedSources = containsCombinedSources;
            return this;
        }

        public Builder setJoinFilter(Optional<RowExpression> joinFilter) {
            this.joinFilter = joinFilter;
            return this;
        }

        public MultiJoinNode build() {
            return new MultiJoinNode(new LinkedHashSet<PlanNode>(this.sources), this.filter, this.outputVariables, this.assignments, this.containsCombinedSources, this.joinFilter);
        }
    }
}

