/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.DeleteNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizerResult;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import java.util.Objects;

public class ReplicateSemiJoinInDelete
implements PlanOptimizer {
    @Override
    public PlanOptimizerResult optimize(PlanNode plan, Session session, TypeProvider types, VariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        if (SystemSessionProperties.isBroadcastSemiJoinForDeleteEnabled(session)) {
            Objects.requireNonNull(plan, "plan is null");
            Rewriter rewriter = new Rewriter();
            PlanNode rewrittenPlan = SimplePlanRewriter.rewriteWith(rewriter, plan);
            return PlanOptimizerResult.optimizerResult(rewrittenPlan, rewriter.isPlanChanged());
        }
        return PlanOptimizerResult.optimizerResult(plan, false);
    }

    private static class Rewriter
    extends SimplePlanRewriter<Void> {
        private boolean isDeleteQuery;
        private boolean planChanged;

        private Rewriter() {
        }

        public boolean isPlanChanged() {
            return this.planChanged;
        }

        public PlanNode visitSemiJoin(SemiJoinNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode sourceRewritten = context.rewrite(node.getSource(), context.get());
            PlanNode filteringSourceRewritten = context.rewrite(node.getFilteringSource(), context.get());
            SemiJoinNode rewrittenNode = new SemiJoinNode(node.getSourceLocation(), node.getId(), sourceRewritten, filteringSourceRewritten, node.getSourceJoinVariable(), node.getFilteringSourceJoinVariable(), node.getSemiJoinOutput(), node.getSourceHashVariable(), node.getFilteringSourceHashVariable(), node.getDistributionType(), node.getDynamicFilters());
            if (this.isDeleteQuery) {
                this.planChanged = true;
                return rewrittenNode.withDistributionType(SemiJoinNode.DistributionType.REPLICATED);
            }
            return rewrittenNode;
        }

        public PlanNode visitDelete(DeleteNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            this.isDeleteQuery = true;
            PlanNode rewrittenSource = context.rewrite(node.getSource());
            return new DeleteNode(node.getSourceLocation(), node.getId(), rewrittenSource, node.getRowId(), node.getOutputVariables(), node.getInputDistribution());
        }
    }
}

