/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.JoinNode;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.spi.plan.LimitNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.SemiJoinNode;
import com.facebook.presto.spi.plan.SortNode;
import com.facebook.presto.spi.plan.TopNNode;
import com.facebook.presto.spi.plan.UnionNode;
import com.facebook.presto.spi.plan.UnnestNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.InputReferenceExpression;
import com.facebook.presto.spi.relation.LambdaDefinitionExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.PlannerUtils;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizerResult;
import com.facebook.presto.sql.planner.plan.ChildReplacer;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.facebook.presto.sql.planner.plan.OffsetNode;
import com.facebook.presto.sql.planner.plan.SampleNode;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.IntStream;

public class ReplaceConstantVariableReferencesWithConstants
implements PlanOptimizer {
    private static final List<Type> SUPPORTED_TYPES = ImmutableList.of((Object)BigintType.BIGINT, (Object)IntegerType.INTEGER, (Object)VarcharType.VARCHAR, (Object)DateType.DATE);
    private final FunctionAndTypeManager functionAndTypeManager;

    public ReplaceConstantVariableReferencesWithConstants(FunctionAndTypeManager functionAndTypeManager) {
        this.functionAndTypeManager = Objects.requireNonNull(functionAndTypeManager, "functionAndTypeManager is null");
    }

    private static boolean isSupportedType(RowExpression rowExpression) {
        return SUPPORTED_TYPES.contains(rowExpression.getType()) || rowExpression.getType() instanceof VarcharType;
    }

    @Override
    public PlanOptimizerResult optimize(PlanNode plan, Session session, TypeProvider types, VariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        if (SystemSessionProperties.isRewriteExpressionWithConstantEnabled(session)) {
            Rewriter rewriter = new Rewriter(idAllocator, this.functionAndTypeManager);
            PlanNode rewrittenPlan = ((PlanNodeWithConstant)plan.accept((PlanVisitor)rewriter, null)).getPlanNode();
            return PlanOptimizerResult.optimizerResult(rewrittenPlan, rewriter.isPlanChanged());
        }
        return PlanOptimizerResult.optimizerResult(plan, false);
    }

    private static class Rewriter
    extends InternalPlanVisitor<PlanNodeWithConstant, Void> {
        private final PlanNodeIdAllocator idAllocator;
        private final FunctionResolution functionResolution;
        private boolean planChanged;

        public Rewriter(PlanNodeIdAllocator idAllocator, FunctionAndTypeManager functionAndTypeManager) {
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
            this.functionResolution = new FunctionResolution(functionAndTypeManager.getFunctionAndTypeResolver());
        }

        public boolean isPlanChanged() {
            return this.planChanged;
        }

        private PlanNodeWithConstant accept(PlanNode node) {
            return (PlanNodeWithConstant)node.accept((PlanVisitor)this, null);
        }

        private PlanNodeWithConstant planAndReplace(PlanNode node, boolean keepConstantConstraint) {
            List children = (List)node.getSources().stream().map(this::accept).collect(ImmutableList.toImmutableList());
            ImmutableList.Builder newSources = ImmutableList.builder();
            for (PlanNodeWithConstant planNodeWithConstant : children) {
                PlanNode child = planNodeWithConstant.getPlanNode();
                Map<VariableReferenceExpression, ConstantExpression> constantExpressionMap = planNodeWithConstant.getConstantExpressionMap();
                if (child.getOutputVariables().stream().noneMatch(x -> constantExpressionMap.containsKey(x))) {
                    newSources.add((Object)child);
                    continue;
                }
                newSources.add((Object)PlannerUtils.addOverrideProjection(child, this.idAllocator, constantExpressionMap));
            }
            PlanNode result = ChildReplacer.replaceChildren(node, (List<PlanNode>)newSources.build());
            if (!keepConstantConstraint) {
                return new PlanNodeWithConstant(result, (Map<VariableReferenceExpression, ConstantExpression>)ImmutableMap.of());
            }
            ImmutableMap.Builder properties = ImmutableMap.builder();
            children.stream().map(PlanNodeWithConstant::getConstantExpressionMap).forEach(arg_0 -> ((ImmutableMap.Builder)properties).putAll(arg_0));
            return new PlanNodeWithConstant(result, (Map<VariableReferenceExpression, ConstantExpression>)properties.build());
        }

        public PlanNodeWithConstant visitPlan(PlanNode node, Void context) {
            return this.planAndReplace(node, false);
        }

        public PlanNodeWithConstant visitFilter(FilterNode node, Void context) {
            PlanNodeWithConstant rewrittenChild = this.accept(node.getSource());
            RowExpression predicate = node.getPredicate();
            HashMap<VariableReferenceExpression, ConstantExpression> newConstantMap = new HashMap<VariableReferenceExpression, ConstantExpression>();
            newConstantMap.putAll(rewrittenChild.getConstantExpressionMap());
            for (RowExpression conjunct : LogicalRowExpressions.extractConjuncts((RowExpression)predicate)) {
                if (!(conjunct instanceof CallExpression) || !this.functionResolution.isEqualsFunction(((CallExpression)conjunct).getFunctionHandle())) continue;
                RowExpression argument0 = (RowExpression)((CallExpression)conjunct).getArguments().get(0);
                RowExpression argument1 = (RowExpression)((CallExpression)conjunct).getArguments().get(1);
                if (!ReplaceConstantVariableReferencesWithConstants.isSupportedType(argument0) || !ReplaceConstantVariableReferencesWithConstants.isSupportedType(argument1) || (!(argument0 instanceof VariableReferenceExpression) || !(argument1 instanceof ConstantExpression)) && (!(argument1 instanceof VariableReferenceExpression) || !(argument0 instanceof ConstantExpression))) continue;
                VariableReferenceExpression variable = (VariableReferenceExpression)(argument0 instanceof VariableReferenceExpression ? argument0 : argument1);
                ConstantExpression constant = (ConstantExpression)(argument0 instanceof ConstantExpression ? argument0 : argument1);
                if (newConstantMap.containsKey(variable) && !((ConstantExpression)newConstantMap.get(variable)).equals((Object)constant)) {
                    return new PlanNodeWithConstant(ChildReplacer.replaceChildren((PlanNode)node, (List<PlanNode>)ImmutableList.of((Object)rewrittenChild.getPlanNode())), (Map<VariableReferenceExpression, ConstantExpression>)ImmutableMap.of());
                }
                if (constant.isNull()) continue;
                this.planChanged = true;
                newConstantMap.put(variable, constant);
            }
            FilterNode newFilterNode = node;
            if (!rewrittenChild.getConstantExpressionMap().isEmpty()) {
                predicate = (RowExpression)predicate.accept((RowExpressionVisitor)new ExpressionRewriter(rewrittenChild.getConstantExpressionMap()), null);
                newFilterNode = new FilterNode(node.getSourceLocation(), this.idAllocator.getNextId(), node.getSource(), predicate);
            }
            return new PlanNodeWithConstant(ChildReplacer.replaceChildren((PlanNode)newFilterNode, (List<PlanNode>)ImmutableList.of((Object)rewrittenChild.getPlanNode())), newConstantMap);
        }

        public PlanNodeWithConstant visitProject(ProjectNode node, Void context) {
            PlanNodeWithConstant rewrittenChild = this.accept(node.getSource());
            ProjectNode newProjectNode = node;
            if (!rewrittenChild.getConstantExpressionMap().isEmpty()) {
                Map newAssignments = (Map)node.getAssignments().getMap().entrySet().stream().collect(ImmutableMap.toImmutableMap(x -> (VariableReferenceExpression)x.getKey(), x -> (RowExpression)((RowExpression)x.getValue()).accept((RowExpressionVisitor)new ExpressionRewriter(rewrittenChild.getConstantExpressionMap()), null)));
                newProjectNode = new ProjectNode(this.idAllocator.getNextId(), node.getSource(), Assignments.copyOf((Map)newAssignments));
            }
            ImmutableMap.Builder newConstantMap = ImmutableMap.builder();
            for (Map.Entry entry : newProjectNode.getAssignments().getMap().entrySet()) {
                ConstantExpression constantExpression;
                if (!(entry.getValue() instanceof ConstantExpression) || !ReplaceConstantVariableReferencesWithConstants.isSupportedType((RowExpression)entry.getKey()) || !ReplaceConstantVariableReferencesWithConstants.isSupportedType((RowExpression)entry.getValue()) || (constantExpression = (ConstantExpression)entry.getValue()).isNull()) continue;
                this.planChanged = true;
                newConstantMap.put((Object)((VariableReferenceExpression)entry.getKey()), (Object)constantExpression);
            }
            return new PlanNodeWithConstant(ChildReplacer.replaceChildren((PlanNode)newProjectNode, (List<PlanNode>)ImmutableList.of((Object)rewrittenChild.getPlanNode())), (Map<VariableReferenceExpression, ConstantExpression>)newConstantMap.build());
        }

        public PlanNodeWithConstant visitJoin(JoinNode node, Void context) {
            PlanNodeWithConstant rewrittenLeft = this.accept(node.getLeft());
            PlanNodeWithConstant rewrittenRight = this.accept(node.getRight());
            ImmutableMap.Builder outputConstantMap = ImmutableMap.builder();
            if (node.getType().equals((Object)JoinType.LEFT) || node.getType().equals((Object)JoinType.INNER)) {
                outputConstantMap.putAll(rewrittenLeft.getConstantExpressionMap());
            }
            if (node.getType().equals((Object)JoinType.RIGHT) || node.getType().equals((Object)JoinType.INNER)) {
                outputConstantMap.putAll(rewrittenRight.getConstantExpressionMap());
            }
            ImmutableList sourceWithConstantProjection = ImmutableList.of((Object)PlannerUtils.addOverrideProjection(rewrittenLeft.getPlanNode(), this.idAllocator, rewrittenLeft.getConstantExpressionMap()), (Object)PlannerUtils.addOverrideProjection(rewrittenRight.getPlanNode(), this.idAllocator, rewrittenRight.getConstantExpressionMap()));
            return new PlanNodeWithConstant(ChildReplacer.replaceChildren((PlanNode)node, (List<PlanNode>)sourceWithConstantProjection), (Map<VariableReferenceExpression, ConstantExpression>)outputConstantMap.build());
        }

        public PlanNodeWithConstant visitUnion(UnionNode node, Void context) {
            List rewrittenSources = (List)node.getSources().stream().map(this::accept).collect(ImmutableList.toImmutableList());
            ImmutableMap.Builder outputConstantMap = ImmutableMap.builder();
            if (rewrittenSources.stream().allMatch(x -> !x.getConstantExpressionMap().isEmpty())) {
                for (Map.Entry entry : node.getVariableMapping().entrySet()) {
                    VariableReferenceExpression outputVariable = (VariableReferenceExpression)entry.getKey();
                    List inputList = (List)entry.getValue();
                    if (!IntStream.range(0, inputList.size()).boxed().allMatch(idx -> ((PlanNodeWithConstant)rewrittenSources.get((int)idx)).getConstantExpressionMap().containsKey(inputList.get((int)idx))) || IntStream.range(0, inputList.size()).boxed().map(idx -> ((PlanNodeWithConstant)rewrittenSources.get((int)idx)).getConstantExpressionMap().get(inputList.get((int)idx))).distinct().count() != 1L) continue;
                    outputConstantMap.put((Object)outputVariable, (Object)((PlanNodeWithConstant)rewrittenSources.get(0)).getConstantExpressionMap().get(inputList.get(0)));
                }
            }
            List sourceWithConstantProjection = (List)rewrittenSources.stream().map(x -> PlannerUtils.addOverrideProjection(x.getPlanNode(), this.idAllocator, x.getConstantExpressionMap())).collect(ImmutableList.toImmutableList());
            return new PlanNodeWithConstant(ChildReplacer.replaceChildren((PlanNode)node, sourceWithConstantProjection), (Map<VariableReferenceExpression, ConstantExpression>)outputConstantMap.build());
        }

        public PlanNodeWithConstant visitAggregation(AggregationNode node, Void context) {
            PlanNodeWithConstant rewrittenChild = this.accept(node.getSource());
            ImmutableList sourceWithConstantProjection = ImmutableList.of((Object)PlannerUtils.addOverrideProjection(rewrittenChild.getPlanNode(), this.idAllocator, rewrittenChild.getConstantExpressionMap()));
            if (node.getGroupingSetCount() != 1) {
                return new PlanNodeWithConstant(ChildReplacer.replaceChildren((PlanNode)node, (List<PlanNode>)sourceWithConstantProjection), (Map<VariableReferenceExpression, ConstantExpression>)ImmutableMap.of());
            }
            Map constantGroupByKeys = (Map)rewrittenChild.getConstantExpressionMap().entrySet().stream().filter(x -> node.getGroupingKeys().contains(x.getKey())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
            return new PlanNodeWithConstant(ChildReplacer.replaceChildren((PlanNode)node, (List<PlanNode>)sourceWithConstantProjection), constantGroupByKeys);
        }

        public PlanNodeWithConstant visitTopN(TopNNode node, Void context) {
            return this.planAndReplace((PlanNode)node, true);
        }

        public PlanNodeWithConstant visitSort(SortNode node, Void context) {
            return this.planAndReplace((PlanNode)node, true);
        }

        public PlanNodeWithConstant visitLimit(LimitNode node, Void context) {
            return this.planAndReplace((PlanNode)node, true);
        }

        @Override
        public PlanNodeWithConstant visitSample(SampleNode node, Void context) {
            return this.planAndReplace(node, true);
        }

        public PlanNodeWithConstant visitSemiJoin(SemiJoinNode node, Void context) {
            return this.planAndReplace((PlanNode)node, true);
        }

        @Override
        public PlanNodeWithConstant visitOffset(OffsetNode node, Void context) {
            return this.planAndReplace(node, true);
        }

        public PlanNodeWithConstant visitUnnest(UnnestNode node, Void context) {
            return this.planAndReplace((PlanNode)node, true);
        }
    }

    private static class PlanNodeWithConstant {
        private final PlanNode planNode;
        private final Map<VariableReferenceExpression, ConstantExpression> constantExpressionMap;

        public PlanNodeWithConstant(PlanNode planNode, Map<VariableReferenceExpression, ConstantExpression> constantExpressionMap) {
            Preconditions.checkArgument((boolean)constantExpressionMap.entrySet().stream().allMatch(entry -> ((VariableReferenceExpression)entry.getKey()).getType().equals(((ConstantExpression)entry.getValue()).getType())), (Object)"key and value in constantExpressionMap not of the same type");
            this.planNode = planNode;
            this.constantExpressionMap = (Map)constantExpressionMap.entrySet().stream().filter(entry -> planNode.getOutputVariables().contains(entry.getKey())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        }

        public PlanNode getPlanNode() {
            return this.planNode;
        }

        public Map<VariableReferenceExpression, ConstantExpression> getConstantExpressionMap() {
            return this.constantExpressionMap;
        }
    }

    private static class ExpressionRewriter
    implements RowExpressionVisitor<RowExpression, Void> {
        private final Map<VariableReferenceExpression, ConstantExpression> expressionMap;

        public ExpressionRewriter(Map<VariableReferenceExpression, ConstantExpression> expressionMap) {
            this.expressionMap = ImmutableMap.copyOf(expressionMap);
        }

        public RowExpression visitCall(CallExpression call, Void context) {
            return new CallExpression(call.getSourceLocation(), call.getDisplayName(), call.getFunctionHandle(), call.getType(), (List)call.getArguments().stream().map(argument -> (RowExpression)argument.accept((RowExpressionVisitor)this, null)).collect(ImmutableList.toImmutableList()));
        }

        public RowExpression visitInputReference(InputReferenceExpression reference, Void context) {
            return reference;
        }

        public RowExpression visitConstant(ConstantExpression literal, Void context) {
            return literal;
        }

        public RowExpression visitLambda(LambdaDefinitionExpression lambda, Void context) {
            return lambda;
        }

        public RowExpression visitVariableReference(VariableReferenceExpression reference, Void context) {
            if (this.expressionMap.containsKey(reference)) {
                return (RowExpression)this.expressionMap.get(reference);
            }
            return reference;
        }

        public RowExpression visitSpecialForm(SpecialFormExpression specialForm, Void context) {
            return new SpecialFormExpression(specialForm.getForm(), specialForm.getType(), (List)specialForm.getArguments().stream().map(argument -> (RowExpression)argument.accept((RowExpressionVisitor)this, null)).collect(ImmutableList.toImmutableList()));
        }
    }
}

