/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.eventlistener.CTEInformation;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.CteConsumerNode;
import com.facebook.presto.spi.plan.CteProducerNode;
import com.facebook.presto.spi.plan.CteReferenceNode;
import com.facebook.presto.spi.plan.JoinNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.plan.SemiJoinNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.planner.SimplePlanVisitor;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.optimizations.PlanNodeSearcher;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizerResult;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.facebook.presto.sql.planner.plan.SequenceNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import com.google.common.graph.MutableValueGraph;
import com.google.common.graph.Traverser;
import com.google.common.graph.ValueGraphBuilder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;

public class LogicalCteOptimizer
implements PlanOptimizer {
    private final Metadata metadata;

    public LogicalCteOptimizer(Metadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public PlanOptimizerResult optimize(PlanNode plan, Session session, TypeProvider types, VariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(variableAllocator, "variableAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        Objects.requireNonNull(warningCollector, "warningCollector is null");
        if (!SystemSessionProperties.isCteMaterializationApplicable(session)) {
            return PlanOptimizerResult.optimizerResult(plan, false);
        }
        CteEnumerator cteEnumerator = new CteEnumerator(idAllocator, variableAllocator);
        PlanNode rewrittenPlan = cteEnumerator.transformPersistentCtes(session, plan);
        return PlanOptimizerResult.optimizerResult(rewrittenPlan, cteEnumerator.isPlanRewritten());
    }

    public class CteEnumerator {
        private PlanNodeIdAllocator planNodeIdAllocator;
        private VariableAllocator variableAllocator;
        private boolean isPlanRewritten;

        public CteEnumerator(PlanNodeIdAllocator planNodeIdAllocator, VariableAllocator variableAllocator) {
            this.planNodeIdAllocator = Objects.requireNonNull(planNodeIdAllocator, "planNodeIdAllocator must not be null");
            this.variableAllocator = Objects.requireNonNull(variableAllocator, "variableAllocator must not be null");
        }

        public PlanNode transformPersistentCtes(Session session, PlanNode root) {
            Preconditions.checkArgument((root.getSources().size() == 1 ? 1 : 0) != 0, (Object)"expected newChildren to contain 1 node");
            LogicalCteOptimizerContext context = new LogicalCteOptimizerContext();
            this.determineMaterializationCandidatesAndUpdateContext(session, root, context);
            PlanNode transformedCte = SimplePlanRewriter.rewriteWith(new CteConsumerTransformer(session, this.planNodeIdAllocator, this.variableAllocator), root, context);
            List<PlanNode> topologicalOrderedList = context.getTopologicalOrdering();
            if (topologicalOrderedList.isEmpty()) {
                this.isPlanRewritten = false;
                return transformedCte;
            }
            this.isPlanRewritten = true;
            SequenceNode sequenceNode = new SequenceNode(root.getSourceLocation(), this.planNodeIdAllocator.getNextId(), topologicalOrderedList, (PlanNode)transformedCte.getSources().get(0), context.createIndexedGraphFromTopologicallySortedCteProducers(topologicalOrderedList));
            return root.replaceChildren(Arrays.asList(new PlanNode[]{sequenceNode}));
        }

        public boolean isPlanRewritten() {
            return this.isPlanRewritten;
        }

        private void determineMaterializationCandidatesAndUpdateContext(Session session, PlanNode root, LogicalCteOptimizerContext context) {
            if (this.shouldPerformHeuristicAnalysis(session)) {
                this.performHeuristicAnalysis(session, root, context);
            } else {
                this.markAllCtesForMaterialization(session, context);
            }
        }

        private boolean shouldPerformHeuristicAnalysis(Session session) {
            return !SystemSessionProperties.getCteMaterializationStrategy(session).equals((Object)FeaturesConfig.CteMaterializationStrategy.ALL);
        }

        private void performHeuristicAnalysis(Session session, PlanNode root, LogicalCteOptimizerContext context) {
            WeightedDependencyAnalyzer dependencyAnalyzer = new WeightedDependencyAnalyzer();
            ComplexCteAnalyzer complexCteAnalyzer = new ComplexCteAnalyzer(session);
            root.accept((PlanVisitor)dependencyAnalyzer, (Object)context);
            root.accept((PlanVisitor)complexCteAnalyzer, (Object)context);
            new HeuristicCteMaterializationDeterminer(session).determineHeuristicCandidates(context);
        }

        private void markAllCtesForMaterialization(Session session, LogicalCteOptimizerContext context) {
            session.getCteInformationCollector().getCTEInformationList().stream().map(CTEInformation::getCteId).forEach(context::addMaterializationCandidate);
        }
    }

    public static class LogicalCteOptimizerContext {
        public Map<String, CteProducerNode> cteProducerMap = new HashMap<String, CteProducerNode>();
        private MutableValueGraph<String, Integer> cteReferenceDependencyGraph = ValueGraphBuilder.directed().allowsSelfLoops(false).build();
        private MutableGraph<String> materializedCteDependencyGraph = GraphBuilder.directed().allowsSelfLoops(false).build();
        private Stack<String> activeCteStack = new Stack();
        private Set<String> complexCtes = new HashSet<String>();
        private Set<String> candidatesForMaterilization = new HashSet<String>();

        public Map<String, CteProducerNode> getCteProducerMap() {
            return ImmutableMap.copyOf(this.cteProducerMap);
        }

        public MutableValueGraph<String, Integer> copyOfCteReferenceDependencyGraph() {
            MutableValueGraph graphCopy = ValueGraphBuilder.from(this.cteReferenceDependencyGraph).build();
            for (String node : this.cteReferenceDependencyGraph.nodes()) {
                graphCopy.addNode((Object)node);
            }
            for (String node : this.cteReferenceDependencyGraph.nodes()) {
                this.cteReferenceDependencyGraph.successors((Object)node).forEach(successor -> graphCopy.putEdgeValue((Object)node, successor, (Object)((Integer)this.cteReferenceDependencyGraph.edgeValueOrDefault((Object)node, successor, (Object)0))));
            }
            return this.cteReferenceDependencyGraph;
        }

        public void addProducer(String cteId, CteProducerNode cteProducer) {
            this.cteProducerMap.putIfAbsent(cteId, cteProducer);
        }

        public void addMaterializationCandidate(String cteId) {
            this.candidatesForMaterilization.add(cteId);
        }

        public boolean shouldCteBeMaterialized(String cteId) {
            return this.candidatesForMaterilization.contains(cteId);
        }

        public void pushActiveCte(String cte) {
            this.activeCteStack.push(cte);
        }

        public String popActiveCte() {
            return this.activeCteStack.pop();
        }

        public Optional<String> peekActiveCte() {
            return this.activeCteStack.isEmpty() ? Optional.empty() : Optional.ofNullable(this.activeCteStack.peek());
        }

        public void addCteReferenceDependency(String currentCte) {
            this.cteReferenceDependencyGraph.addNode((Object)currentCte);
            Optional<String> parentCte = this.peekActiveCte();
            parentCte.ifPresent(parent -> {
                if (this.cteReferenceDependencyGraph.hasEdgeConnecting(parent, (Object)currentCte)) {
                    int existingWeight = (Integer)this.cteReferenceDependencyGraph.edgeValueOrDefault(parent, (Object)currentCte, (Object)0);
                    this.cteReferenceDependencyGraph.putEdgeValue(parent, (Object)currentCte, (Object)(existingWeight + 1));
                } else {
                    this.cteReferenceDependencyGraph.putEdgeValue(parent, (Object)currentCte, (Object)1);
                }
            });
        }

        public void addMaterializedCteDependency(String currentCte) {
            this.materializedCteDependencyGraph.addNode((Object)currentCte);
            Optional<String> parentCte = this.peekActiveCte();
            parentCte.ifPresent(s -> this.materializedCteDependencyGraph.putEdge((Object)currentCte, s));
        }

        public void addComplexCte(String cteId) {
            this.complexCtes.add(cteId);
        }

        public void removeComplexCte(String cteId) {
            this.complexCtes.remove(cteId);
        }

        public boolean isComplexCte(String cteId) {
            return this.complexCtes.contains(cteId);
        }

        public List<PlanNode> getTopologicalOrdering() {
            ImmutableList.Builder topSortedCteProducerListBuilder = ImmutableList.builder();
            Traverser.forGraph(this.materializedCteDependencyGraph).depthFirstPostOrder((Iterable)this.materializedCteDependencyGraph.nodes()).forEach(cteId -> topSortedCteProducerListBuilder.add((Object)((PlanNode)this.cteProducerMap.get(cteId))));
            return topSortedCteProducerListBuilder.build();
        }

        public Graph<Integer> createIndexedGraphFromTopologicallySortedCteProducers(List<PlanNode> topologicalSortedCteProducerList) {
            HashMap<String, Integer> cteIdToProducerIndexMap = new HashMap<String, Integer>();
            MutableGraph indexGraph = GraphBuilder.directed().expectedNodeCount(topologicalSortedCteProducerList.size()).build();
            for (int i = 0; i < topologicalSortedCteProducerList.size(); ++i) {
                cteIdToProducerIndexMap.put(((CteProducerNode)topologicalSortedCteProducerList.get(i)).getCteId(), i);
                indexGraph.addNode((Object)i);
            }
            for (String cteId : this.materializedCteDependencyGraph.nodes()) {
                this.materializedCteDependencyGraph.successors((Object)cteId).forEach(successor -> indexGraph.putEdge((Object)((Integer)cteIdToProducerIndexMap.get(cteId)), (Object)((Integer)cteIdToProducerIndexMap.get(successor))));
            }
            return indexGraph;
        }
    }

    public static class CteConsumerTransformer
    extends SimplePlanRewriter<LogicalCteOptimizerContext> {
        private final PlanNodeIdAllocator idAllocator;
        private final VariableAllocator variableAllocator;
        private final Session session;

        public CteConsumerTransformer(Session session, PlanNodeIdAllocator idAllocator, VariableAllocator variableAllocator) {
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator must not be null");
            this.variableAllocator = Objects.requireNonNull(variableAllocator, "variableAllocator must not be null");
            this.session = Objects.requireNonNull(session, "Session is null");
        }

        public boolean shouldCteBeMaterialized(String cteId, LogicalCteOptimizerContext context) {
            CTEInformation cteInfo = this.session.getCteInformationCollector().getCteInformationMap().get(cteId);
            boolean shouldBeMaterialized = context.shouldCteBeMaterialized(cteId);
            this.session.getCteInformationCollector().getCteInformationMap().put(cteId, new CTEInformation(cteInfo.getCteName(), cteInfo.getCteId(), cteInfo.getNumberOfReferences(), cteInfo.getIsView(), shouldBeMaterialized));
            return shouldBeMaterialized;
        }

        public PlanNode visitCteReference(CteReferenceNode node, SimplePlanRewriter.RewriteContext<LogicalCteOptimizerContext> context) {
            if (!this.shouldCteBeMaterialized(node.getCteId(), context.get())) {
                return context.rewrite(node.getSource(), context.get());
            }
            context.get().addMaterializedCteDependency(node.getCteId());
            context.get().pushActiveCte(node.getCteId());
            PlanNode actualSource = context.rewrite(node.getSource(), context.get());
            context.get().popActiveCte();
            CteProducerNode cteProducerSource = new CteProducerNode(node.getSourceLocation(), this.idAllocator.getNextId(), actualSource, node.getCteId(), this.variableAllocator.newVariable("rows", (Type)BigintType.BIGINT), node.getOutputVariables());
            context.get().addProducer(node.getCteId(), cteProducerSource);
            return new CteConsumerNode(node.getSourceLocation(), this.idAllocator.getNextId(), Optional.of(actualSource), actualSource.getOutputVariables(), node.getCteId(), actualSource);
        }

        @Override
        public PlanNode visitApply(ApplyNode node, SimplePlanRewriter.RewriteContext<LogicalCteOptimizerContext> context) {
            return new ApplyNode(node.getSourceLocation(), this.idAllocator.getNextId(), context.rewrite(node.getInput(), context.get()), context.rewrite(node.getSubquery(), context.get()), node.getSubqueryAssignments(), node.getCorrelation(), node.getOriginSubqueryError(), node.getMayParticipateInAntiJoin());
        }
    }

    public static class HeuristicCteMaterializationDeterminer {
        private final Session session;

        public HeuristicCteMaterializationDeterminer(Session session) {
            this.session = session;
        }

        private void decrementCteReferenceCount(String cteId, int referencesToRemove) {
            HashMap<String, CTEInformation> cteInformationMap = this.session.getCteInformationCollector().getCteInformationMap();
            CTEInformation cteInfo = cteInformationMap.get(cteId);
            int newReferenceCount = cteInfo.getNumberOfReferences() - referencesToRemove;
            Preconditions.checkArgument((newReferenceCount >= 0 ? 1 : 0) != 0, (String)"CTE Reference count for cteId %s should be >= 0", (Object)cteId);
            cteInformationMap.put(cteId, new CTEInformation(cteInfo.getCteName(), cteInfo.getCteId(), newReferenceCount, cteInfo.getIsView(), cteInfo.isMaterialized()));
        }

        void rebaseReferences(MutableValueGraph<String, Integer> graph, String cteId, int currentMultiplier, int baseRemovalMultiplier, LogicalCteOptimizerContext context) {
            for (String childCte : graph.successors((Object)cteId)) {
                if (context.shouldCteBeMaterialized(childCte)) continue;
                int edgeValue = (Integer)graph.edgeValueOrDefault((Object)cteId, (Object)childCte, (Object)1);
                int referencesToRemove = baseRemovalMultiplier * currentMultiplier * edgeValue;
                this.decrementCteReferenceCount(childCte, referencesToRemove);
                this.rebaseReferences(graph, childCte, currentMultiplier * edgeValue, baseRemovalMultiplier, context);
            }
        }

        private void adjustChildReferenceCounts(String parentCteId, int parentReferences, LogicalCteOptimizerContext context) {
            int adjustmentFactor = parentReferences - 1;
            Preconditions.checkArgument((adjustmentFactor >= 0 ? 1 : 0) != 0, (Object)"adjustment count cannot be negative");
            this.rebaseReferences((MutableValueGraph<String, Integer>)context.cteReferenceDependencyGraph, parentCteId, 1, adjustmentFactor, context);
        }

        public void determineHeuristicCandidates(LogicalCteOptimizerContext context) {
            MutableValueGraph<String, Integer> cteReferenceDependencyGraph = context.copyOfCteReferenceDependencyGraph();
            HashMap<String, CTEInformation> cteInformationMap = this.session.getCteInformationCollector().getCteInformationMap();
            List<String> nodesWithInDegreeZero = cteReferenceDependencyGraph.nodes().stream().filter(node -> cteReferenceDependencyGraph.inDegree(node) == 0).collect(Collectors.toList());
            while (!nodesWithInDegreeZero.isEmpty()) {
                nodesWithInDegreeZero.forEach(cteId -> {
                    CTEInformation cteInfo = (CTEInformation)cteInformationMap.get(cteId);
                    boolean isAboveThreshold = cteInfo.getNumberOfReferences() >= SystemSessionProperties.getCteHeuristicReplicationThreshold(this.session);
                    boolean isHeuristic = SystemSessionProperties.getCteMaterializationStrategy(this.session).equals((Object)FeaturesConfig.CteMaterializationStrategy.HEURISTIC);
                    boolean isHeuristicComplexOnly = SystemSessionProperties.getCteMaterializationStrategy(this.session).equals((Object)FeaturesConfig.CteMaterializationStrategy.HEURISTIC_COMPLEX_QUERIES_ONLY);
                    boolean isComplexCte = context.isComplexCte(cteInfo.getCteId());
                    if (isAboveThreshold && (isHeuristic || isHeuristicComplexOnly && isComplexCte)) {
                        context.candidatesForMaterilization.add(cteId);
                        this.adjustChildReferenceCounts((String)cteId, cteInfo.getNumberOfReferences(), context);
                    }
                });
                nodesWithInDegreeZero.forEach(arg_0 -> cteReferenceDependencyGraph.removeNode(arg_0));
                nodesWithInDegreeZero = cteReferenceDependencyGraph.nodes().stream().filter(node -> cteReferenceDependencyGraph.inDegree(node) == 0).collect(Collectors.toList());
            }
        }
    }

    public static class WeightedDependencyAnalyzer
    extends SimplePlanVisitor<LogicalCteOptimizerContext> {
        private final Set<String> visited = new HashSet<String>();

        public Void visitCteReference(CteReferenceNode node, LogicalCteOptimizerContext context) {
            if (this.visited.contains(node.getCteId())) {
                context.addCteReferenceDependency(node.getCteId());
                return null;
            }
            this.visited.add(node.getCteId());
            context.addCteReferenceDependency(node.getCteId());
            context.pushActiveCte(node.getCteId());
            node.getSource().accept((PlanVisitor)this, (Object)context);
            context.popActiveCte();
            return null;
        }

        @Override
        public Void visitApply(ApplyNode node, LogicalCteOptimizerContext context) {
            node.getInput().accept((PlanVisitor)this, (Object)context);
            node.getSubquery().accept((PlanVisitor)this, (Object)context);
            return null;
        }
    }

    public static class ComplexCteAnalyzer
    extends SimplePlanVisitor<LogicalCteOptimizerContext> {
        private final Session session;
        private static final List<Class<? extends PlanNode>> DATA_SOURCES_PLAN_NODES = ImmutableList.of(TableScanNode.class, RemoteSourceNode.class);

        public ComplexCteAnalyzer(Session session) {
            this.session = Objects.requireNonNull(session, "Session is null");
        }

        public Void visitCteReference(CteReferenceNode node, LogicalCteOptimizerContext context) {
            context.pushActiveCte(node.getCteId());
            node.getSource().accept((PlanVisitor)this, (Object)context);
            context.popActiveCte();
            if (context.isComplexCte(node.getCteId()) && !PlanNodeSearcher.searchFrom((PlanNode)node).where(planNode -> DATA_SOURCES_PLAN_NODES.stream().anyMatch(clazz -> clazz.isInstance(planNode))).matches()) {
                context.removeComplexCte(node.getCteId());
            }
            return null;
        }

        public Void visitJoin(JoinNode node, LogicalCteOptimizerContext context) {
            Optional<String> parentCte = context.peekActiveCte();
            parentCte.ifPresent(context::addComplexCte);
            return (Void)super.visitJoin(node, (Object)context);
        }

        public Void visitSemiJoin(SemiJoinNode node, LogicalCteOptimizerContext context) {
            Optional<String> parentCte = context.peekActiveCte();
            parentCte.ifPresent(context::addComplexCte);
            return (Void)super.visitSemiJoin(node, (Object)context);
        }

        public Void visitAggregation(AggregationNode node, LogicalCteOptimizerContext context) {
            Optional<String> parentCte = context.peekActiveCte();
            parentCte.ifPresent(context::addComplexCte);
            return (Void)super.visitAggregation(node, (Object)context);
        }
    }
}

