/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.spi.ConstantProperty;
import com.facebook.presto.spi.GroupingProperty;
import com.facebook.presto.spi.LocalProperty;
import com.facebook.presto.spi.SortingProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class LocalProperties {
    private LocalProperties() {
    }

    public static <T> List<LocalProperty<T>> none() {
        return ImmutableList.of();
    }

    public static <T> List<LocalProperty<T>> grouped(Collection<T> columns) {
        return ImmutableList.of((Object)new GroupingProperty(columns));
    }

    public static <T> List<LocalProperty<T>> sorted(Collection<T> columns, SortOrder order) {
        return (List)columns.stream().map(column -> new SortingProperty(column, order)).collect(ImmutableList.toImmutableList());
    }

    public static <T> List<LocalProperty<T>> stripLeadingConstants(List<? extends LocalProperty<T>> properties) {
        PeekingIterator iterator = Iterators.peekingIterator(properties.iterator());
        while (iterator.hasNext() && iterator.peek() instanceof ConstantProperty) {
            iterator.next();
        }
        return ImmutableList.copyOf((Iterator)iterator);
    }

    public static <T> Set<T> extractLeadingConstants(List<? extends LocalProperty<T>> properties) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        PeekingIterator iterator = Iterators.peekingIterator(properties.iterator());
        while (iterator.hasNext() && iterator.peek() instanceof ConstantProperty) {
            builder.add(((ConstantProperty)iterator.next()).getColumn());
        }
        return builder.build();
    }

    public static <X, Y> List<LocalProperty<Y>> translate(List<? extends LocalProperty<X>> properties, Function<X, Optional<Y>> translator) {
        properties = LocalProperties.normalizeAndPrune(properties);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (LocalProperty<X> property : properties) {
            Optional translated = property.translate(translator);
            if (translated.isPresent()) {
                builder.add((Object)((LocalProperty)translated.get()));
                continue;
            }
            if (property instanceof ConstantProperty) continue;
            break;
        }
        return builder.build();
    }

    public static <T> List<Optional<LocalProperty<T>>> match(List<LocalProperty<T>> actuals, List<LocalProperty<T>> desired) {
        PeekingIterator actualIterator = Iterators.peekingIterator(LocalProperties.normalizeAndPrune(actuals).iterator());
        HashSet constants = new HashSet();
        boolean consumeMoreActuals = true;
        ArrayList<Optional<LocalProperty<T>>> result = new ArrayList<Optional<LocalProperty<T>>>(desired.size());
        for (LocalProperty<T> desiredProperty : desired) {
            while (consumeMoreActuals && actualIterator.hasNext() && desiredProperty.isSimplifiedBy((LocalProperty)actualIterator.peek())) {
                constants.addAll(((LocalProperty)actualIterator.next()).getColumns());
            }
            Optional simplifiedDesired = desiredProperty.withConstants(constants);
            consumeMoreActuals &= !simplifiedDesired.isPresent();
            result.add(simplifiedDesired);
        }
        return result;
    }

    public static <T> List<LocalProperty<T>> normalizeAndPrune(List<? extends LocalProperty<T>> localProperties) {
        return LocalProperties.normalize(localProperties).stream().filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public static <T> List<Optional<LocalProperty<T>>> normalize(List<? extends LocalProperty<T>> localProperties) {
        ArrayList<Optional<LocalProperty<T>>> normalizedProperties = new ArrayList<Optional<LocalProperty<T>>>(localProperties.size());
        HashSet constants = new HashSet();
        for (LocalProperty<T> localProperty : localProperties) {
            normalizedProperties.add(localProperty.withConstants(constants));
            constants.addAll(localProperty.getColumns());
        }
        return normalizedProperties;
    }
}

