/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.expressions.DefaultRowExpressionTraversalVisitor;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.matching.Capture;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.JoinTableInfo;
import com.facebook.presto.spi.JoinTableSet;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.connector.ConnectorCapabilities;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.JoinNode;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.DeterminismEvaluator;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.EqualityInference;
import com.facebook.presto.sql.planner.NullabilityAnalyzer;
import com.facebook.presto.sql.planner.PlannerUtils;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.VariablesExtractor;
import com.facebook.presto.sql.planner.iterative.GroupReference;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.optimizations.JoinNodeUtils;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.AssignmentUtils;
import com.facebook.presto.sql.planner.plan.MultiJoinNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.relational.RowExpressionDeterminismEvaluator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class GroupInnerJoinsByConnectorRuleSet {
    private final Metadata metadata;
    private final PlanOptimizer predicatePushdownOptimizer;

    public GroupInnerJoinsByConnectorRuleSet(Metadata metadata, PlanOptimizer predicatePushdown) {
        this.metadata = metadata;
        this.predicatePushdownOptimizer = predicatePushdown;
    }

    public Set<Rule<?>> rules() {
        return ImmutableSet.of((Object)new OnlyJoinRule(this.metadata, this.predicatePushdownOptimizer), (Object)new FilterOnJoinRule(this.metadata, this.predicatePushdownOptimizer));
    }

    public static class OnlyJoinRule
    extends BaseGroupInnerJoinsByConnector<JoinNode> {
        public OnlyJoinRule(Metadata metadata, PlanOptimizer predicatePushdownOptimizer) {
            super(metadata, predicatePushdownOptimizer);
        }

        @Override
        public Pattern<JoinNode> getPattern() {
            return Patterns.join().matching(joinNode -> joinNode.getType() == JoinType.INNER && this.determinismEvaluator.isDeterministic((RowExpression)joinNode.getFilter().orElse(LogicalRowExpressions.TRUE_CONSTANT)));
        }

        @Override
        public Rule.Result apply(JoinNode node, Captures captures, Rule.Context context) {
            PlanNode rewrittenPlan = this.getCombinedJoin(node, this.functionResolution, this.determinismEvaluator, this.metadata, context);
            if (rewrittenPlan.equals(node)) {
                return Rule.Result.empty();
            }
            return Rule.Result.ofPlanNode(rewrittenPlan);
        }
    }

    public static class FilterOnJoinRule
    extends BaseGroupInnerJoinsByConnector<FilterNode> {
        private static final Capture<JoinNode> JOIN = Capture.newCapture();

        public FilterOnJoinRule(Metadata metadata, PlanOptimizer predicatePushdownOptimizer) {
            super(metadata, predicatePushdownOptimizer);
        }

        @Override
        public Pattern<FilterNode> getPattern() {
            return Patterns.filter().with(Patterns.source().matching(Patterns.join().matching(joinNode -> joinNode.getType() == JoinType.INNER && this.determinismEvaluator.isDeterministic((RowExpression)joinNode.getFilter().orElse(LogicalRowExpressions.TRUE_CONSTANT))).capturedAs(JOIN)));
        }

        @Override
        public Rule.Result apply(FilterNode filterNode, Captures captures, Rule.Context context) {
            JoinNode capturedJoinNode = (JoinNode)captures.get(JOIN);
            ImmutableList.Builder predicates = ImmutableList.builder();
            predicates.add((Object)filterNode.getPredicate());
            capturedJoinNode.getFilter().ifPresent(arg_0 -> ((ImmutableList.Builder)predicates).add(arg_0));
            JoinNode joinNode = new JoinNode(capturedJoinNode.getSourceLocation(), context.getIdAllocator().getNextId(), capturedJoinNode.getStatsEquivalentPlanNode(), capturedJoinNode.getType(), capturedJoinNode.getLeft(), capturedJoinNode.getRight(), capturedJoinNode.getCriteria(), capturedJoinNode.getOutputVariables(), Optional.of(LogicalRowExpressions.and((Collection)predicates.build())), capturedJoinNode.getLeftHashVariable(), capturedJoinNode.getRightHashVariable(), capturedJoinNode.getDistributionType(), capturedJoinNode.getDynamicFilters());
            PlanNode rewrittenPlan = this.getCombinedJoin(joinNode, this.functionResolution, this.determinismEvaluator, this.metadata, context);
            if (rewrittenPlan.equals(filterNode)) {
                return Rule.Result.empty();
            }
            return Rule.Result.ofPlanNode(rewrittenPlan);
        }
    }

    public static abstract class BaseGroupInnerJoinsByConnector<T>
    implements Rule<T> {
        final FunctionResolution functionResolution;
        final DeterminismEvaluator determinismEvaluator;
        final Metadata metadata;
        final NullabilityAnalyzer nullabilityAnalyzer;
        boolean isEnabledForTesting;
        final FunctionAndTypeManager functionAndTypeManager;
        private final PlanOptimizer predicatePushdownOptimizer;

        public BaseGroupInnerJoinsByConnector(Metadata metadata, PlanOptimizer predicatePushdownOptimizer) {
            this.functionResolution = new FunctionResolution(metadata.getFunctionAndTypeManager().getFunctionAndTypeResolver());
            this.determinismEvaluator = new RowExpressionDeterminismEvaluator(metadata.getFunctionAndTypeManager());
            this.metadata = metadata;
            this.functionAndTypeManager = metadata.getFunctionAndTypeManager();
            this.nullabilityAnalyzer = new NullabilityAnalyzer(this.functionAndTypeManager);
            this.predicatePushdownOptimizer = predicatePushdownOptimizer;
        }

        @Override
        public boolean isEnabled(Session session) {
            return this.isEnabledForTesting || SystemSessionProperties.isInnerJoinPushdownEnabled(session) != false;
        }

        public void setEnabledForTesting(boolean isSet) {
            this.isEnabledForTesting = isSet;
        }

        private static List<RowExpression> getExpressionsWithinVariableScope(Set<RowExpression> rowExpressions, Set<VariableReferenceExpression> variableScope) {
            return (List)rowExpressions.stream().filter(rowExpression -> Sets.difference(VariablesExtractor.extractUnique(rowExpression), (Set)variableScope).isEmpty()).collect(ImmutableList.toImmutableList());
        }

        private static boolean isOperation(RowExpression expression, OperatorType type, FunctionAndTypeManager functionAndTypeManager) {
            CallExpression call;
            Optional expressionOperatorType;
            if (expression instanceof CallExpression && (expressionOperatorType = functionAndTypeManager.getFunctionMetadata((call = (CallExpression)expression).getFunctionHandle()).getOperatorType()).isPresent()) {
                return expressionOperatorType.get() == type;
            }
            return false;
        }

        private static RowExpression getLeft(RowExpression expression) {
            Preconditions.checkArgument((expression instanceof CallExpression && ((CallExpression)expression).getArguments().size() == 2 ? 1 : 0) != 0, (Object)"must be binary call expression");
            return (RowExpression)((CallExpression)expression).getArguments().get(0);
        }

        private static RowExpression getRight(RowExpression expression) {
            Preconditions.checkArgument((expression instanceof CallExpression && ((CallExpression)expression).getArguments().size() == 2 ? 1 : 0) != 0, (Object)"must be binary call expression");
            return (RowExpression)((CallExpression)expression).getArguments().get(1);
        }

        private static Set<VariableReferenceExpression> extractVariableExpressions(RowExpression expression) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            expression.accept((RowExpressionVisitor)new VariableReferenceBuilderVisitor(), (Object)builder);
            return builder.build();
        }

        protected PlanNode getCombinedJoin(JoinNode node, FunctionResolution functionResolution, DeterminismEvaluator determinismEvaluator, Metadata metadata, Rule.Context context) {
            Lookup lookup = context.getLookup();
            Session session = context.getSession();
            PlanNodeIdAllocator idAllocator = context.getIdAllocator();
            VariableAllocator variableAllocator = context.getVariableAllocator();
            MultiJoinNode groupInnerJoinsMultiJoinNode = new JoinNodeFlattener((PlanNode)node, functionResolution, determinismEvaluator, lookup).toMultiJoinNode();
            MultiJoinNode rewrittenMultiJoinNode = this.joinPushdownCombineSources(groupInnerJoinsMultiJoinNode, idAllocator, metadata, session, lookup);
            if (rewrittenMultiJoinNode.getContainsCombinedSources()) {
                PlanNode leftDeepJoinTree = this.createLeftDeepJoinTree(rewrittenMultiJoinNode, idAllocator);
                return this.predicatePushdownOptimizer.optimize(leftDeepJoinTree, session, TypeProvider.viewOf(variableAllocator.getVariables()), variableAllocator, idAllocator, context.getWarningCollector()).getPlanNode();
            }
            return node;
        }

        private PlanNode createLeftDeepJoinTree(MultiJoinNode multiJoinNode, PlanNodeIdAllocator idAllocator) {
            PlanNode joinNode = this.createJoin(0, (List<PlanNode>)ImmutableList.copyOf(multiJoinNode.getSources()), idAllocator);
            RowExpression combinedFilters = LogicalRowExpressions.and((RowExpression[])new RowExpression[]{multiJoinNode.getJoinFilter().get(), multiJoinNode.getFilter()});
            FilterNode withFilters = new FilterNode(Optional.empty(), idAllocator.getNextId(), joinNode, combinedFilters);
            return PlannerUtils.restrictOutput((PlanNode)withFilters, idAllocator, multiJoinNode.getOutputVariables());
        }

        private PlanNode createJoin(int index, List<PlanNode> sources, PlanNodeIdAllocator idAllocator) {
            if (index == sources.size() - 1) {
                return sources.get(index);
            }
            PlanNode leftNode = this.createJoin(index + 1, sources, idAllocator);
            PlanNode rightNode = sources.get(index);
            return new JoinNode(Optional.empty(), idAllocator.getNextId(), JoinType.INNER, leftNode, rightNode, (List)ImmutableList.of(), (List)ImmutableList.builder().addAll((Iterable)leftNode.getOutputVariables()).addAll((Iterable)rightNode.getOutputVariables()).build(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)ImmutableMap.of());
        }

        private MultiJoinNode joinPushdownCombineSources(MultiJoinNode multiJoinNode, PlanNodeIdAllocator idAllocator, Metadata metadata, Session session, Lookup lookup) {
            LinkedHashSet<PlanNode> rewrittenSources = new LinkedHashSet<PlanNode>();
            List overallTableFilter = LogicalRowExpressions.extractConjuncts((RowExpression)multiJoinNode.getFilter());
            HashMap<String, List> sourcesByConnector = new HashMap<String, List>();
            boolean isInEqualityPushDownEnabled = session.getSystemProperty("optimizer_inequality_join_pushdown_enabled", Boolean.class);
            EqualityInference filterEqualityInference = new EqualityInference.Builder(metadata).addEqualityInference(multiJoinNode.getJoinFilter().get()).build();
            ImmutableSet inequalityPredicates = isInEqualityPushDownEnabled ? Iterables.filter((Iterable)LogicalRowExpressions.extractConjuncts((RowExpression)multiJoinNode.getJoinFilter().get()), this.isInequalityInferenceCandidate()) : ImmutableSet.of();
            AtomicReference<Boolean> wereSourcesRewritten = new AtomicReference<Boolean>(false);
            Set sources = multiJoinNode.getSources().stream().flatMap(planNode -> {
                if (planNode instanceof GroupReference) {
                    return lookup.resolveGroup((PlanNode)planNode);
                }
                return Stream.of(planNode);
            }).collect(Collectors.toCollection(LinkedHashSet::new));
            for (PlanNode source : sources) {
                Optional<String> connectorId = this.getConnectorIdFromSource(source, session, lookup);
                if (connectorId.isPresent()) {
                    sourcesByConnector.computeIfAbsent(connectorId.get(), k -> new ArrayList());
                    ((List)sourcesByConnector.get(connectorId.get())).add(source);
                    continue;
                }
                rewrittenSources.add(source);
            }
            sourcesByConnector.forEach((arg_0, arg_1) -> this.lambda$joinPushdownCombineSources$3(filterEqualityInference, (Iterable)inequalityPredicates, rewrittenSources, idAllocator, session, wereSourcesRewritten, arg_0, arg_1));
            return new MultiJoinNode(rewrittenSources, LogicalRowExpressions.and((Collection)overallTableFilter), multiJoinNode.getOutputVariables(), multiJoinNode.getAssignments(), wereSourcesRewritten.get(), multiJoinNode.getJoinFilter());
        }

        private Predicate<RowExpression> isInequalityInferenceCandidate() {
            return expression -> (BaseGroupInnerJoinsByConnector.isOperation(expression, OperatorType.GREATER_THAN_OR_EQUAL, this.functionAndTypeManager) || BaseGroupInnerJoinsByConnector.isOperation(expression, OperatorType.GREATER_THAN, this.functionAndTypeManager) || BaseGroupInnerJoinsByConnector.isOperation(expression, OperatorType.LESS_THAN_OR_EQUAL, this.functionAndTypeManager) || BaseGroupInnerJoinsByConnector.isOperation(expression, OperatorType.LESS_THAN, this.functionAndTypeManager) || BaseGroupInnerJoinsByConnector.isOperation(expression, OperatorType.NOT_EQUAL, this.functionAndTypeManager)) && this.determinismEvaluator.isDeterministic(expression) && !this.nullabilityAnalyzer.mayReturnNullOnNonNullInput((RowExpression)expression) && !BaseGroupInnerJoinsByConnector.getLeft(expression).equals((Object)BaseGroupInnerJoinsByConnector.getRight(expression));
        }

        private PlanNode getNewTableScanNode(List<PlanNode> groupedSources, EqualityInference filterEqualityInference, Iterable<RowExpression> inequalityPredicates, LinkedHashSet<PlanNode> rewrittenSources, PlanNodeIdAllocator idAllocator, Session session) {
            ImmutableList.Builder nodesToCombineBuilder = ImmutableList.builder();
            ImmutableList.Builder joinPushdownSourcesBuilder = ImmutableList.builder();
            groupedSources.forEach(planNode -> {
                if (planNode instanceof TableScanNode) {
                    nodesToCombineBuilder.add(planNode);
                } else {
                    rewrittenSources.add((PlanNode)planNode);
                }
            });
            ImmutableList nodesToCombine = nodesToCombineBuilder.build();
            if (nodesToCombine.isEmpty()) {
                return null;
            }
            Set<VariableReferenceExpression> combinedOutputVariables = nodesToCombine.stream().flatMap(o -> o.getOutputVariables().stream()).collect(Collectors.toSet());
            List<RowExpression> equiJoinFilters = filterEqualityInference.generateEqualitiesPartitionedBy((Predicate<VariableReferenceExpression>)((Predicate)combinedOutputVariables::contains)).getScopeEqualities();
            Set<RowExpression> inequalityPredicateSet = StreamSupport.stream(inequalityPredicates.spliterator(), false).collect(Collectors.toSet());
            Map<VariableReferenceExpression, ColumnHandle> groupAssignments = nodesToCombine.stream().map(this::getTableScanNode).map(TableScanNode::getAssignments).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(entry -> (VariableReferenceExpression)entry.getKey(), entry -> (ColumnHandle)entry.getValue()));
            HashSet<ConnectorTableHandle> nodeHandles = new HashSet<ConnectorTableHandle>();
            TableHandle firstResolvedTableHandle = null;
            HashSet<JoinTableInfo> joinTableInfos = new HashSet<JoinTableInfo>();
            for (PlanNode planNode2 : nodesToCombine) {
                TableHandle resolvedTableHandle = this.getTableScanNode(planNode2).getTable();
                if (firstResolvedTableHandle == null) {
                    firstResolvedTableHandle = resolvedTableHandle;
                }
                ConnectorTableHandle connectorHandle = resolvedTableHandle.getConnectorHandle();
                nodeHandles.add(connectorHandle);
                joinTableInfos.add(new JoinTableInfo(connectorHandle, this.getTableScanNode(planNode2).getAssignments(), planNode2.getOutputVariables()));
            }
            JoinTableSet combinedTableHandles = new JoinTableSet(joinTableInfos);
            TableHandle combinedTableHandle = new TableHandle(firstResolvedTableHandle.getConnectorId(), (ConnectorTableHandle)combinedTableHandles, firstResolvedTableHandle.getTransaction(), firstResolvedTableHandle.getLayout());
            ArrayList<RowExpression> translatableJoinFilters = new ArrayList<RowExpression>();
            for (RowExpression rowExpression : equiJoinFilters) {
                if (!this.metadata.isPushdownSupportedForFilter(session, combinedTableHandle, rowExpression, groupAssignments)) continue;
                translatableJoinFilters.add(rowExpression);
            }
            List<RowExpression> scopedInequalities = BaseGroupInnerJoinsByConnector.getExpressionsWithinVariableScope(inequalityPredicateSet, combinedOutputVariables);
            for (RowExpression nonEquiFilter : scopedInequalities) {
                if (!this.metadata.isPushdownSupportedForFilter(session, combinedTableHandle, nonEquiFilter, groupAssignments)) continue;
                translatableJoinFilters.add(nonEquiFilter);
            }
            RowExpression rowExpression = LogicalRowExpressions.and(translatableJoinFilters);
            Set<VariableReferenceExpression> referredVariables = BaseGroupInnerJoinsByConnector.extractVariableExpressions(rowExpression);
            if (referredVariables.isEmpty()) {
                rewrittenSources.addAll((Collection<PlanNode>)nodesToCombine);
            }
            nodesToCombine.forEach(node -> {
                if (node.getOutputVariables().stream().anyMatch(referredVariables::contains)) {
                    joinPushdownSourcesBuilder.add(node);
                } else {
                    rewrittenSources.add((PlanNode)node);
                }
            });
            ImmutableList joinPushdownSources = joinPushdownSourcesBuilder.build();
            if (joinPushdownSources.isEmpty()) {
                return null;
            }
            if (joinPushdownSources.size() == 1) {
                rewrittenSources.add((PlanNode)joinPushdownSources.get(0));
                return null;
            }
            return this.buildSingleTableScan((List<PlanNode>)joinPushdownSources, idAllocator);
        }

        private PlanNode buildSingleTableScan(List<PlanNode> groupNodes, PlanNodeIdAllocator idAllocator) {
            TableHandle firstResolvedTableHandle = null;
            TableScanNode firstResolvedTableScanNode = null;
            ImmutableSet.Builder builder = ImmutableSet.builder();
            ArrayList outputVariables = new ArrayList();
            HashMap assignments = new HashMap();
            for (PlanNode groupNode : groupNodes) {
                TableScanNode tableScanNode = this.getTableScanNode(groupNode);
                TableHandle tableHandle = tableScanNode.getTable();
                if (firstResolvedTableHandle == null) {
                    firstResolvedTableHandle = tableHandle;
                    firstResolvedTableScanNode = tableScanNode;
                }
                outputVariables.addAll(tableScanNode.getOutputVariables());
                assignments.putAll(tableScanNode.getAssignments());
                builder.add((Object)new JoinTableInfo(tableHandle.getConnectorHandle(), tableScanNode.getAssignments(), tableScanNode.getOutputVariables()));
            }
            TableHandle updatedTableHandle = new TableHandle(firstResolvedTableHandle.getConnectorId(), (ConnectorTableHandle)new JoinTableSet((Set)builder.build()), firstResolvedTableHandle.getTransaction(), firstResolvedTableHandle.getLayout(), firstResolvedTableHandle.getDynamicFilter());
            return new TableScanNode(Optional.empty(), idAllocator.getNextId(), updatedTableHandle, outputVariables, assignments, firstResolvedTableScanNode.getCurrentConstraint(), firstResolvedTableScanNode.getEnforcedConstraint(), firstResolvedTableScanNode.getCteMaterializationInfo());
        }

        private TableScanNode getTableScanNode(PlanNode planNode) {
            while (!(planNode instanceof TableScanNode)) {
                planNode = (PlanNode)planNode.getSources().get(0);
            }
            return (TableScanNode)planNode;
        }

        private Optional<String> getConnectorIdFromSource(PlanNode resolved, Session session, Lookup lookup) {
            TableScanNode ts;
            ConnectorId connectorId;
            boolean supportsJoinPushDown;
            if (resolved instanceof GroupReference) {
                return this.getConnectorIdFromSource(lookup.resolve(resolved), session, lookup);
            }
            if (resolved instanceof ProjectNode) {
                return this.getConnectorIdFromSource(((ProjectNode)resolved).getSource(), session, lookup);
            }
            if (resolved instanceof FilterNode) {
                return this.getConnectorIdFromSource(((FilterNode)resolved).getSource(), session, lookup);
            }
            if (resolved instanceof TableScanNode && (supportsJoinPushDown = this.metadata.getConnectorCapabilities(session, connectorId = (ts = (TableScanNode)resolved).getTable().getConnectorId()).contains(ConnectorCapabilities.SUPPORTS_JOIN_PUSHDOWN))) {
                return Optional.of(connectorId.toString());
            }
            return Optional.empty();
        }

        private /* synthetic */ void lambda$joinPushdownCombineSources$3(EqualityInference filterEqualityInference, Iterable inequalityPredicates, LinkedHashSet rewrittenSources, PlanNodeIdAllocator idAllocator, Session session, AtomicReference wereSourcesRewritten, String connectorId, List planNodes) {
            PlanNode newSource = this.getNewTableScanNode(planNodes, filterEqualityInference, inequalityPredicates, rewrittenSources, idAllocator, session);
            if (null != newSource) {
                wereSourcesRewritten.set(true);
                rewrittenSources.add(newSource);
            }
        }

        private static class VariableReferenceBuilderVisitor
        extends DefaultRowExpressionTraversalVisitor<ImmutableSet.Builder<VariableReferenceExpression>> {
            private VariableReferenceBuilderVisitor() {
            }

            public Void visitVariableReference(VariableReferenceExpression variable, ImmutableSet.Builder<VariableReferenceExpression> builder) {
                builder.add((Object)variable);
                return null;
            }
        }

        @VisibleForTesting
        private static class JoinNodeFlattener {
            private final LinkedHashSet<PlanNode> sources = new LinkedHashSet();
            private List<RowExpression> joinCriteriaFilters = new ArrayList<RowExpression>();
            private List<RowExpression> filters = new ArrayList<RowExpression>();
            private final List<VariableReferenceExpression> outputVariables;
            private final FunctionResolution functionResolution;
            private final DeterminismEvaluator determinismEvaluator;
            private final boolean connectorJoinNode = false;

            JoinNodeFlattener(PlanNode node, FunctionResolution functionResolution, DeterminismEvaluator determinismEvaluator, Lookup lookup) {
                Objects.requireNonNull(node, "node is null");
                this.outputVariables = node.getOutputVariables();
                this.functionResolution = Objects.requireNonNull(functionResolution, "functionResolution is null");
                this.determinismEvaluator = Objects.requireNonNull(determinismEvaluator, "determinismEvaluator is null");
                this.flattenNode(node, lookup);
            }

            private void flattenNode(PlanNode resolved, Lookup lookup) {
                PlanNode resolvedNode = lookup.resolve(resolved);
                if (resolvedNode instanceof FilterNode) {
                    FilterNode filterNode = (FilterNode)resolvedNode;
                    this.filters.add(filterNode.getPredicate());
                    this.flattenNode(filterNode.getSource(), lookup);
                    return;
                }
                if (!(resolvedNode instanceof JoinNode)) {
                    if (resolvedNode instanceof ProjectNode && AssignmentUtils.isIdentity(((ProjectNode)resolvedNode).getAssignments())) {
                        this.flattenNode(((ProjectNode)resolvedNode).getSource(), lookup);
                        return;
                    }
                    this.sources.add(resolvedNode);
                    return;
                }
                JoinNode joinNode = (JoinNode)resolvedNode;
                if (joinNode.getType() != JoinType.INNER || !this.determinismEvaluator.isDeterministic((RowExpression)joinNode.getFilter().orElse(LogicalRowExpressions.TRUE_CONSTANT))) {
                    this.sources.add(resolvedNode);
                    return;
                }
                this.flattenNode(joinNode.getLeft(), lookup);
                this.flattenNode(joinNode.getRight(), lookup);
                joinNode.getCriteria().stream().map(criteria -> JoinNodeUtils.toRowExpression(criteria, this.functionResolution)).forEach(this.joinCriteriaFilters::add);
                joinNode.getFilter().ifPresent(this.joinCriteriaFilters::add);
            }

            MultiJoinNode toMultiJoinNode() {
                ImmutableSet inputVariables = (ImmutableSet)this.sources.stream().flatMap(source -> source.getOutputVariables().stream()).collect(ImmutableSet.toImmutableSet());
                ImmutableSet.Builder updatedOutputVariables = ImmutableSet.builder();
                for (VariableReferenceExpression outputVariable : this.outputVariables) {
                    if (!inputVariables.contains((Object)outputVariable)) continue;
                    updatedOutputVariables.add((Object)outputVariable);
                }
                return new MultiJoinNode(this.sources, LogicalRowExpressions.and(this.filters), (List<VariableReferenceExpression>)updatedOutputVariables.build().asList(), Assignments.of(), false, Optional.of(LogicalRowExpressions.and(this.joinCriteriaFilters)));
            }
        }
    }
}

