/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.cost.CachingStatsProvider;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.StatsCalculator;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.statistics.SourceInfo;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.VariablesExtractor;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class AggregationNodeUtils {
    private AggregationNodeUtils() {
    }

    public static AggregationNode.Aggregation count(FunctionAndTypeManager functionAndTypeManager) {
        return new AggregationNode.Aggregation(new CallExpression("count", new FunctionResolution(functionAndTypeManager.getFunctionAndTypeResolver()).countFunction(), (Type)BigintType.BIGINT, (List)ImmutableList.of()), Optional.empty(), Optional.empty(), false, Optional.empty());
    }

    public static Set<VariableReferenceExpression> extractAggregationUniqueVariables(AggregationNode.Aggregation aggregation) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        aggregation.getArguments().forEach(argument -> builder.addAll(AggregationNodeUtils.extractAll(argument)));
        aggregation.getFilter().ifPresent(filter -> builder.addAll(AggregationNodeUtils.extractAll(filter)));
        aggregation.getOrderBy().ifPresent(orderingScheme -> builder.addAll((Iterable)orderingScheme.getOrderByVariables()));
        return builder.build();
    }

    private static List<VariableReferenceExpression> extractAll(RowExpression expression) {
        return (List)VariablesExtractor.extractAll(expression).stream().collect(ImmutableList.toImmutableList());
    }

    public static boolean isAllLowCardinalityGroupByKeys(AggregationNode aggregationNode, TableScanNode scanNode, Session session, StatsCalculator statsCalculator, TypeProvider types, long count) {
        List groupbyKeys = aggregationNode.getGroupingSets().getGroupingKeys().stream().collect(Collectors.toList());
        CachingStatsProvider statsProvider = new CachingStatsProvider(statsCalculator, session, types);
        PlanNodeStatsEstimate estimate = statsProvider.getStats((PlanNode)scanNode);
        if (estimate.confidenceLevel() == SourceInfo.ConfidenceLevel.LOW) {
            return true;
        }
        return groupbyKeys.stream().noneMatch(x -> estimate.getVariableStatistics((VariableReferenceExpression)x).getDistinctValuesCount() >= (double)count);
    }

    public static AggregationNode.Aggregation removeFilterAndMask(AggregationNode.Aggregation aggregation) {
        Optional filter = aggregation.getFilter();
        Optional mask = aggregation.getMask();
        if (filter.isPresent() || mask.isPresent()) {
            return new AggregationNode.Aggregation(aggregation.getCall(), Optional.empty(), aggregation.getOrderBy(), aggregation.isDistinct(), Optional.empty());
        }
        return aggregation;
    }
}

