/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.Partitioning;
import com.facebook.presto.spi.plan.PartitioningHandle;
import com.facebook.presto.spi.plan.PartitioningScheme;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.plan.TableFinishNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.sql.planner.PlannerUtils;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.iterative.rule.PickTableLayout;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizerResult;
import com.facebook.presto.sql.planner.plan.ChildReplacer;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.ExplainAnalyzeNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.planner.plan.StatisticsWriterNode;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class AddExchangesForSingleNodeExecution
implements PlanOptimizer {
    private final Metadata metadata;

    public AddExchangesForSingleNodeExecution(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    @Override
    public boolean isEnabled(Session session) {
        return SystemSessionProperties.isSingleNodeExecutionEnabled(session);
    }

    @Override
    public PlanOptimizerResult optimize(PlanNode plan, Session session, TypeProvider types, VariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        if (this.isEnabled(session)) {
            Rewriter rewriter = new Rewriter(idAllocator, this.metadata, session);
            PlanNode rewrittenPlan = SimplePlanRewriter.rewriteWith(rewriter, plan, null);
            return PlanOptimizerResult.optimizerResult(rewrittenPlan, rewriter.isPlanChanged());
        }
        return PlanOptimizerResult.optimizerResult(plan, false);
    }

    private class Rewriter
    extends SimplePlanRewriter<Void> {
        private final PlanNodeIdAllocator idAllocator;
        private final Metadata metadata;
        private final Session session;
        private boolean planChanged;

        private Rewriter(PlanNodeIdAllocator idAllocator, Metadata metadata, Session session) {
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.session = Objects.requireNonNull(session, "session is null");
        }

        public boolean isPlanChanged() {
            return this.planChanged;
        }

        public PlanNode visitTableScan(TableScanNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode plan = PickTableLayout.pushPredicateIntoTableScan(node, (RowExpression)new ConstantExpression((Object)true, (Type)BooleanType.BOOLEAN), true, this.session, this.idAllocator, this.metadata);
            if (PlannerUtils.containsSystemTableScan(plan)) {
                plan = ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, plan);
            }
            return plan;
        }

        @Override
        public PlanNode visitExplainAnalyze(ExplainAnalyzeNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return this.addGatherExchange(node, context);
        }

        public PlanNode visitTableFinish(TableFinishNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return this.addGatherExchange((PlanNode)node, context);
        }

        @Override
        public PlanNode visitStatisticsWriterNode(StatisticsWriterNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return this.addGatherExchange(node, context);
        }

        private PlanNode addGatherExchange(PlanNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            ExchangeNode gather;
            PlanNode child = (PlanNode)((PlanNode)node.getSources().get(0)).accept((PlanVisitor)this, context);
            if (child instanceof ExchangeNode) {
                ExchangeNode exchangeNode = (ExchangeNode)child;
                gather = new ExchangeNode(exchangeNode.getSourceLocation(), this.idAllocator.getNextId(), ExchangeNode.Type.GATHER, ExchangeNode.Scope.REMOTE_STREAMING, new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (Collection)ImmutableList.of()), exchangeNode.getOutputVariables()), exchangeNode.getSources(), exchangeNode.getInputs(), true, Optional.empty());
            } else {
                gather = ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, child);
            }
            this.planChanged = true;
            return ChildReplacer.replaceChildren(node, (List<PlanNode>)ImmutableList.of((Object)((Object)gather)));
        }
    }
}

