/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.ConstantProperty;
import com.facebook.presto.spi.LocalProperty;
import com.facebook.presto.spi.plan.Partitioning;
import com.facebook.presto.spi.plan.PartitioningHandle;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.facebook.presto.sql.planner.optimizations.LocalProperties;
import com.facebook.presto.sql.planner.optimizations.PartitioningUtils;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.concurrent.Immutable;

public class ActualProperties {
    private final Global global;
    private final List<LocalProperty<VariableReferenceExpression>> localProperties;
    private final Map<VariableReferenceExpression, ConstantExpression> constants;

    private ActualProperties(Global global, List<? extends LocalProperty<VariableReferenceExpression>> localProperties, Map<VariableReferenceExpression, ConstantExpression> constants) {
        Objects.requireNonNull(global, "globalProperties is null");
        Objects.requireNonNull(localProperties, "localProperties is null");
        Objects.requireNonNull(constants, "constants is null");
        this.global = global;
        Set localConstants = LocalProperties.extractLeadingConstants(localProperties);
        localProperties = LocalProperties.stripLeadingConstants(localProperties);
        ImmutableSet updatedLocalConstants = ImmutableSet.builder().addAll(localConstants).addAll(constants.keySet()).build();
        List updatedLocalProperties = LocalProperties.normalizeAndPrune(ImmutableList.builder().addAll(Iterables.transform((Iterable)updatedLocalConstants, ConstantProperty::new)).addAll(localProperties).build());
        this.localProperties = ImmutableList.copyOf(updatedLocalProperties);
        this.constants = ImmutableMap.copyOf(constants);
    }

    public boolean isCoordinatorOnly() {
        return this.global.isCoordinatorOnly();
    }

    public boolean isSingleNode() {
        return this.global.isSingleNode();
    }

    public boolean isNullsAndAnyReplicated() {
        return this.global.isNullsAndAnyReplicated();
    }

    public boolean isStreamPartitionedOn(Collection<VariableReferenceExpression> columns, boolean exactly) {
        return this.isStreamPartitionedOn(columns, false, exactly);
    }

    public boolean isStreamPartitionedOn(Collection<VariableReferenceExpression> columns, boolean nullsAndAnyReplicated, boolean exactly) {
        if (exactly) {
            return this.global.isStreamPartitionedOnExactly(columns, this.constants.keySet(), nullsAndAnyReplicated);
        }
        return this.global.isStreamPartitionedOn(columns, this.constants.keySet(), nullsAndAnyReplicated);
    }

    public boolean isNodePartitionedOn(Collection<VariableReferenceExpression> columns, boolean exactly) {
        return this.isNodePartitionedOn(columns, false, exactly);
    }

    public boolean isNodePartitionedOn(Collection<VariableReferenceExpression> columns, boolean nullsAndAnyReplicated, boolean exactly) {
        if (exactly) {
            return this.global.isNodePartitionedOnExactly(columns, this.constants.keySet(), nullsAndAnyReplicated);
        }
        return this.global.isNodePartitionedOn(columns, this.constants.keySet(), nullsAndAnyReplicated);
    }

    @Deprecated
    public boolean isCompatibleTablePartitioningWith(Partitioning partitioning, boolean nullsAndAnyReplicated, Metadata metadata, Session session) {
        return this.global.isCompatibleTablePartitioningWith(partitioning, nullsAndAnyReplicated, metadata, session);
    }

    @Deprecated
    public boolean isCompatibleTablePartitioningWith(ActualProperties other, Function<VariableReferenceExpression, Set<VariableReferenceExpression>> symbolMappings, Metadata metadata, Session session) {
        return this.global.isCompatibleTablePartitioningWith(other.global, symbolMappings, variable -> Optional.ofNullable(this.constants.get(variable)), variable -> Optional.ofNullable(other.constants.get(variable)), metadata, session);
    }

    public boolean isRefinedPartitioningOver(Partitioning partitioning, boolean nullsAndAnyReplicated, Metadata metadata, Session session) {
        return this.global.isRefinedPartitioningOver(partitioning, nullsAndAnyReplicated, metadata, session);
    }

    public boolean isRefinedPartitioningOver(ActualProperties other, Function<VariableReferenceExpression, Set<VariableReferenceExpression>> symbolMappings, Metadata metadata, Session session) {
        return this.global.isRefinedPartitioningOver(other.global, symbolMappings, variable -> Optional.ofNullable(this.constants.get(variable)), variable -> Optional.ofNullable(other.constants.get(variable)), metadata, session);
    }

    public boolean isEffectivelySingleStream() {
        return this.global.isEffectivelySingleStream(this.constants.keySet());
    }

    public boolean isStreamRepartitionEffective(Collection<VariableReferenceExpression> keys) {
        return this.global.isStreamRepartitionEffective(keys, this.constants.keySet());
    }

    public ActualProperties translateVariable(Function<VariableReferenceExpression, Optional<VariableReferenceExpression>> translator) {
        HashMap<VariableReferenceExpression, ConstantExpression> translatedConstants = new HashMap<VariableReferenceExpression, ConstantExpression>();
        for (Map.Entry<VariableReferenceExpression, ConstantExpression> entry : this.constants.entrySet()) {
            Optional<VariableReferenceExpression> translatedKey = translator.apply(entry.getKey());
            if (!translatedKey.isPresent()) continue;
            translatedConstants.put(translatedKey.get(), entry.getValue());
        }
        return ActualProperties.builder().global(this.global.translateVariableToRowExpression(variable -> {
            Optional<RowExpression> translated = ((Optional)translator.apply((VariableReferenceExpression)variable)).map(RowExpression.class::cast);
            if (!translated.isPresent()) {
                translated = Optional.ofNullable((RowExpression)this.constants.get(variable));
            }
            return translated;
        })).local(LocalProperties.translate(this.localProperties, translator)).constants(translatedConstants).build();
    }

    public ActualProperties translateRowExpression(Map<VariableReferenceExpression, RowExpression> assignments) {
        HashMap<VariableReferenceExpression, VariableReferenceExpression> inputToOutputVariables = new HashMap<VariableReferenceExpression, VariableReferenceExpression>();
        for (Map.Entry<VariableReferenceExpression, RowExpression> assignment : assignments.entrySet()) {
            RowExpression rowExpression = assignment.getValue();
            if (!(rowExpression instanceof VariableReferenceExpression)) continue;
            inputToOutputVariables.put((VariableReferenceExpression)rowExpression, (VariableReferenceExpression)assignment.getKey());
        }
        HashMap<VariableReferenceExpression, ConstantExpression> translatedConstants = new HashMap<VariableReferenceExpression, ConstantExpression>();
        for (Map.Entry entry2 : this.constants.entrySet()) {
            if (!inputToOutputVariables.containsKey(entry2.getKey())) continue;
            translatedConstants.put((VariableReferenceExpression)inputToOutputVariables.get(entry2.getKey()), (ConstantExpression)entry2.getValue());
        }
        ImmutableMap.Builder inputToOutputMappings = ImmutableMap.builder();
        inputToOutputMappings.putAll(inputToOutputVariables);
        this.constants.entrySet().stream().filter(entry -> !inputToOutputVariables.containsKey(entry.getKey())).forEach(arg_0 -> ((ImmutableMap.Builder)inputToOutputMappings).put(arg_0));
        return ActualProperties.builder().global(this.global.translateRowExpression((Map)inputToOutputMappings.build(), assignments)).local(LocalProperties.translate(this.localProperties, variable -> Optional.ofNullable((VariableReferenceExpression)inputToOutputVariables.get(variable)))).constants(translatedConstants).build();
    }

    public Optional<Partitioning> getNodePartitioning() {
        return this.global.getNodePartitioning();
    }

    public Map<VariableReferenceExpression, ConstantExpression> getConstants() {
        return this.constants;
    }

    public List<LocalProperty<VariableReferenceExpression>> getLocalProperties() {
        return this.localProperties;
    }

    public ActualProperties withReplicatedNulls(boolean replicatedNulls) {
        return ActualProperties.builderFrom(this).global(this.global.withReplicatedNulls(replicatedNulls)).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builderFrom(ActualProperties properties) {
        return new Builder(properties.global, properties.localProperties, properties.constants);
    }

    public int hashCode() {
        return Objects.hash(this.global, this.localProperties, this.constants.keySet());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ActualProperties other = (ActualProperties)obj;
        return Objects.equals(this.global, other.global) && Objects.equals(this.localProperties, other.localProperties) && Objects.equals(this.constants.keySet(), other.constants.keySet());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("globalProperties", (Object)this.global).add("localProperties", this.localProperties).add("constants", this.constants).toString();
    }

    @Immutable
    public static final class Global {
        private final Optional<Partitioning> nodePartitioning;
        private final Optional<Partitioning> streamPartitioning;
        private final boolean nullsAndAnyReplicated;

        private Global(Optional<Partitioning> nodePartitioning, Optional<Partitioning> streamPartitioning, boolean nullsAndAnyReplicated) {
            Preconditions.checkArgument((!nodePartitioning.isPresent() || !streamPartitioning.isPresent() || nodePartitioning.get().getVariableReferences().containsAll(streamPartitioning.get().getVariableReferences()) || streamPartitioning.get().getVariableReferences().containsAll(nodePartitioning.get().getVariableReferences()) ? 1 : 0) != 0, (Object)"Global stream partitioning columns should match node partitioning columns");
            this.nodePartitioning = Objects.requireNonNull(nodePartitioning, "nodePartitioning is null");
            this.streamPartitioning = Objects.requireNonNull(streamPartitioning, "streamPartitioning is null");
            this.nullsAndAnyReplicated = nullsAndAnyReplicated;
        }

        public static Global coordinatorSingleStreamPartition() {
            return Global.partitionedOn(SystemPartitioningHandle.COORDINATOR_DISTRIBUTION, ImmutableList.of(), Optional.of(ImmutableList.of()));
        }

        public static Global singleStreamPartition() {
            return Global.partitionedOn(SystemPartitioningHandle.SINGLE_DISTRIBUTION, ImmutableList.of(), Optional.of(ImmutableList.of()));
        }

        public static Global arbitraryPartition() {
            return new Global(Optional.empty(), Optional.empty(), false);
        }

        public static <T extends RowExpression, U extends RowExpression> Global partitionedOn(PartitioningHandle nodePartitioningHandle, List<T> nodePartitioning, Optional<List<U>> streamPartitioning) {
            return new Global(Optional.of(Partitioning.create((PartitioningHandle)nodePartitioningHandle, nodePartitioning)), streamPartitioning.map(columns -> Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SOURCE_DISTRIBUTION, (Collection)columns)), false);
        }

        public static Global partitionedOn(Partitioning nodePartitioning, Optional<Partitioning> streamPartitioning) {
            return new Global(Optional.of(nodePartitioning), streamPartitioning, false);
        }

        public static Global streamPartitionedOn(List<VariableReferenceExpression> streamPartitioning) {
            return new Global(Optional.empty(), Optional.of(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SOURCE_DISTRIBUTION, streamPartitioning)), false);
        }

        public static Global partitionedOnCoalesce(Partitioning one, Partitioning other, Metadata metadata, Session session) {
            return new Global(PartitioningUtils.translateToCoalesce(one, other, metadata, session), Optional.empty(), false);
        }

        public Global withReplicatedNulls(boolean replicatedNulls) {
            return new Global(this.nodePartitioning, this.streamPartitioning, replicatedNulls);
        }

        private boolean isNullsAndAnyReplicated() {
            return this.nullsAndAnyReplicated;
        }

        private boolean isSingleNode() {
            if (!this.nodePartitioning.isPresent()) {
                return false;
            }
            return this.nodePartitioning.get().getHandle().isSingleNode();
        }

        private boolean isCoordinatorOnly() {
            if (!this.nodePartitioning.isPresent()) {
                return false;
            }
            return this.nodePartitioning.get().getHandle().isCoordinatorOnly();
        }

        private boolean isNodePartitionedOn(Collection<VariableReferenceExpression> columns, Set<VariableReferenceExpression> constants, boolean nullsAndAnyReplicated) {
            return this.nodePartitioning.isPresent() && PartitioningUtils.isPartitionedOn(this.nodePartitioning.get(), columns, constants) && this.nullsAndAnyReplicated == nullsAndAnyReplicated;
        }

        private boolean isNodePartitionedOnExactly(Collection<VariableReferenceExpression> columns, Set<VariableReferenceExpression> constants, boolean nullsAndAnyReplicated) {
            return this.nodePartitioning.isPresent() && PartitioningUtils.isPartitionedOnExactly(this.nodePartitioning.get(), columns, constants) && this.nullsAndAnyReplicated == nullsAndAnyReplicated;
        }

        private boolean isCompatibleTablePartitioningWith(Partitioning partitioning, boolean nullsAndAnyReplicated, Metadata metadata, Session session) {
            return this.nodePartitioning.isPresent() && PartitioningUtils.areCompatiblePartitionings(this.nodePartitioning.get(), partitioning, metadata, session) && this.nullsAndAnyReplicated == nullsAndAnyReplicated;
        }

        private boolean isCompatibleTablePartitioningWith(Global other, Function<VariableReferenceExpression, Set<VariableReferenceExpression>> symbolMappings, Function<VariableReferenceExpression, Optional<ConstantExpression>> leftConstantMapping, Function<VariableReferenceExpression, Optional<ConstantExpression>> rightConstantMapping, Metadata metadata, Session session) {
            return this.nodePartitioning.isPresent() && other.nodePartitioning.isPresent() && PartitioningUtils.areCompatiblePartitionings(this.nodePartitioning.get(), other.nodePartitioning.get(), symbolMappings, leftConstantMapping, rightConstantMapping, metadata, session) && this.nullsAndAnyReplicated == other.nullsAndAnyReplicated;
        }

        private boolean isRefinedPartitioningOver(Partitioning partitioning, boolean nullsAndAnyReplicated, Metadata metadata, Session session) {
            return this.nodePartitioning.isPresent() && PartitioningUtils.isRefinedPartitioningOver(this.nodePartitioning.get(), partitioning, metadata, session) && this.nullsAndAnyReplicated == nullsAndAnyReplicated;
        }

        private boolean isRefinedPartitioningOver(Global other, Function<VariableReferenceExpression, Set<VariableReferenceExpression>> symbolMappings, Function<VariableReferenceExpression, Optional<ConstantExpression>> leftConstantMapping, Function<VariableReferenceExpression, Optional<ConstantExpression>> rightConstantMapping, Metadata metadata, Session session) {
            return this.nodePartitioning.isPresent() && other.nodePartitioning.isPresent() && PartitioningUtils.isRefinedPartitioningOver(this.nodePartitioning.get(), other.nodePartitioning.get(), symbolMappings, leftConstantMapping, rightConstantMapping, metadata, session) && this.nullsAndAnyReplicated == other.nullsAndAnyReplicated;
        }

        private Optional<Partitioning> getNodePartitioning() {
            return this.nodePartitioning;
        }

        private boolean isStreamPartitionedOn(Collection<VariableReferenceExpression> columns, Set<VariableReferenceExpression> constants, boolean nullsAndAnyReplicated) {
            return this.streamPartitioning.isPresent() && PartitioningUtils.isPartitionedOn(this.streamPartitioning.get(), columns, constants) && this.nullsAndAnyReplicated == nullsAndAnyReplicated;
        }

        private boolean isStreamPartitionedOnExactly(Collection<VariableReferenceExpression> columns, Set<VariableReferenceExpression> constants, boolean nullsAndAnyReplicated) {
            return this.streamPartitioning.isPresent() && PartitioningUtils.isPartitionedOnExactly(this.streamPartitioning.get(), columns, constants) && this.nullsAndAnyReplicated == nullsAndAnyReplicated;
        }

        private boolean isEffectivelySingleStream(Set<VariableReferenceExpression> constants) {
            return this.streamPartitioning.isPresent() && PartitioningUtils.isEffectivelySinglePartition(this.streamPartitioning.get(), constants) && !this.nullsAndAnyReplicated;
        }

        private boolean isStreamRepartitionEffective(Collection<VariableReferenceExpression> keys, Set<VariableReferenceExpression> constants) {
            return (!this.streamPartitioning.isPresent() || PartitioningUtils.isRepartitionEffective(this.streamPartitioning.get(), keys, constants)) && !this.nullsAndAnyReplicated;
        }

        private Global translateVariableToRowExpression(Function<VariableReferenceExpression, Optional<RowExpression>> translator) {
            return new Global(this.nodePartitioning.flatMap(partitioning -> PartitioningUtils.translateVariableToRowExpression(partitioning, translator)), this.streamPartitioning.flatMap(partitioning -> PartitioningUtils.translateVariableToRowExpression(partitioning, translator)), this.nullsAndAnyReplicated);
        }

        private Global translateRowExpression(Map<VariableReferenceExpression, RowExpression> inputToOutputMappings, Map<VariableReferenceExpression, RowExpression> assignments) {
            return new Global(this.nodePartitioning.flatMap(partitioning -> PartitioningUtils.translatePartitioningRowExpression(partitioning, inputToOutputMappings, assignments)), this.streamPartitioning.flatMap(partitioning -> PartitioningUtils.translatePartitioningRowExpression(partitioning, inputToOutputMappings, assignments)), this.nullsAndAnyReplicated);
        }

        public int hashCode() {
            return Objects.hash(this.nodePartitioning, this.streamPartitioning, this.nullsAndAnyReplicated);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Global other = (Global)obj;
            return Objects.equals(this.nodePartitioning, other.nodePartitioning) && Objects.equals(this.streamPartitioning, other.streamPartitioning) && this.nullsAndAnyReplicated == other.nullsAndAnyReplicated;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("nodePartitioning", this.nodePartitioning).add("streamPartitioning", this.streamPartitioning).add("nullsAndAnyReplicated", this.nullsAndAnyReplicated).toString();
        }
    }

    public static class Builder {
        private Global global;
        private List<LocalProperty<VariableReferenceExpression>> localProperties;
        private Map<VariableReferenceExpression, ConstantExpression> constants;
        private boolean unordered;

        public Builder() {
            this(Global.arbitraryPartition(), (List<LocalProperty<VariableReferenceExpression>>)ImmutableList.of(), (Map<VariableReferenceExpression, ConstantExpression>)ImmutableMap.of());
        }

        public Builder(Global global, List<LocalProperty<VariableReferenceExpression>> localProperties, Map<VariableReferenceExpression, ConstantExpression> constants) {
            this.global = Objects.requireNonNull(global, "global is null");
            this.localProperties = ImmutableList.copyOf(localProperties);
            this.constants = ImmutableMap.copyOf(constants);
        }

        public Builder global(Global global) {
            this.global = global;
            return this;
        }

        public Builder global(ActualProperties other) {
            this.global = other.global;
            return this;
        }

        public Builder local(List<? extends LocalProperty<VariableReferenceExpression>> localProperties) {
            this.localProperties = ImmutableList.copyOf(localProperties);
            return this;
        }

        public Builder constants(Map<VariableReferenceExpression, ConstantExpression> constants) {
            this.constants = ImmutableMap.copyOf(constants);
            return this;
        }

        public Builder unordered(boolean unordered) {
            this.unordered = unordered;
            return this;
        }

        public ActualProperties build() {
            ImmutableList localProperties = this.localProperties;
            if (this.unordered) {
                ImmutableList.Builder newLocalProperties = ImmutableList.builder();
                for (LocalProperty<VariableReferenceExpression> property : this.localProperties) {
                    if (property.isOrderSensitive()) break;
                    newLocalProperties.add(property);
                }
                localProperties = newLocalProperties.build();
            }
            return new ActualProperties(this.global, (List)localProperties, this.constants);
        }
    }
}

