/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.spi.plan.LogicalProperties;
import com.facebook.presto.spi.plan.Ordering;
import com.facebook.presto.spi.plan.OrderingScheme;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.VariablesExtractor;
import com.facebook.presto.sql.planner.plan.AssignmentUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

class Util {
    private Util() {
    }

    public static Optional<Set<VariableReferenceExpression>> pruneInputs(Collection<VariableReferenceExpression> availableInputs, Collection<RowExpression> expressions, TypeProvider types) {
        ImmutableSet availableInputsSet = ImmutableSet.copyOf(availableInputs);
        Set prunedInputs = Sets.filter((Set)availableInputsSet, VariablesExtractor.extractUnique(expressions)::contains);
        if (prunedInputs.size() == availableInputsSet.size()) {
            return Optional.empty();
        }
        return Optional.of(prunedInputs);
    }

    public static PlanNode transpose(PlanNode parent, PlanNode child) {
        return child.replaceChildren((List)ImmutableList.of((Object)parent.replaceChildren(child.getSources())));
    }

    public static Optional<PlanNode> restrictOutputs(PlanNodeIdAllocator idAllocator, PlanNode node, Set<VariableReferenceExpression> permittedOutputs) {
        List restrictedOutputs = (List)node.getOutputVariables().stream().filter(permittedOutputs::contains).collect(ImmutableList.toImmutableList());
        if (restrictedOutputs.size() == node.getOutputVariables().size()) {
            return Optional.empty();
        }
        return Optional.of(new ProjectNode(node.getSourceLocation(), idAllocator.getNextId(), node, AssignmentUtils.identityAssignments(restrictedOutputs), ProjectNode.Locality.LOCAL));
    }

    @SafeVarargs
    public static Optional<PlanNode> restrictChildOutputs(PlanNodeIdAllocator idAllocator, PlanNode node, Set<VariableReferenceExpression> ... permittedChildOutputsArgs) {
        ImmutableList permittedChildOutputs = ImmutableList.copyOf((Object[])permittedChildOutputsArgs);
        Preconditions.checkArgument((node.getSources().size() == permittedChildOutputs.size() ? 1 : 0) != 0, (String)"Mismatched child (%d) and permitted outputs (%d) sizes", (int)node.getSources().size(), (int)permittedChildOutputs.size());
        ImmutableList.Builder newChildrenBuilder = ImmutableList.builder();
        boolean rewroteChildren = false;
        for (int i = 0; i < node.getSources().size(); ++i) {
            PlanNode oldChild = (PlanNode)node.getSources().get(i);
            Optional<PlanNode> newChild = Util.restrictOutputs(idAllocator, oldChild, (Set)permittedChildOutputs.get(i));
            rewroteChildren |= newChild.isPresent();
            newChildrenBuilder.add((Object)newChild.orElse(oldChild));
        }
        if (!rewroteChildren) {
            return Optional.empty();
        }
        return Optional.of(node.replaceChildren((List)newChildrenBuilder.build()));
    }

    public static OrderingScheme pruneOrderingColumns(OrderingScheme nodeOrderingScheme, LogicalProperties sourceLogicalProperties) {
        Objects.requireNonNull(nodeOrderingScheme, "nodeOrderingScheme is null");
        Objects.requireNonNull(sourceLogicalProperties, "nodeOrderingScheme is null");
        List orderingVariables = (List)nodeOrderingScheme.getOrderBy().stream().map(Ordering::getVariable).collect(ImmutableList.toImmutableList());
        int sizeSmallestDistinctPrefix = Util.sizeSmallestDistinctPrefix(sourceLogicalProperties, orderingVariables);
        if (sizeSmallestDistinctPrefix == 0) {
            return nodeOrderingScheme;
        }
        List keyPrefix = nodeOrderingScheme.getOrderBy().subList(0, sizeSmallestDistinctPrefix);
        return new OrderingScheme(keyPrefix);
    }

    private static int sizeSmallestDistinctPrefix(LogicalProperties logicalProperties, List<VariableReferenceExpression> candidateVariables) {
        HashSet<VariableReferenceExpression> possibleKeySet = new HashSet<VariableReferenceExpression>();
        for (int prefixSize = 1; prefixSize < candidateVariables.size(); ++prefixSize) {
            possibleKeySet.add(candidateVariables.get(prefixSize - 1));
            if (!logicalProperties.isDistinct(possibleKeySet)) continue;
            return prefixSize;
        }
        return 0;
    }
}

