/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.matching.Capture;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.JoinNode;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.spi.plan.LogicalProperties;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.SemiJoinNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class TransformDistinctInnerJoinToLeftEarlyOutJoin
implements Rule<AggregationNode> {
    private static final Capture<JoinNode> JOIN = Capture.newCapture();
    private static final Pattern<AggregationNode> PATTERN = Patterns.aggregation().matching(AggregationNode::isDistinct).with(Patterns.source().matching(Patterns.join().capturedAs(JOIN).with(Patterns.Join.type().matching(type -> type == JoinType.INNER))));

    @Override
    public Pattern<AggregationNode> getPattern() {
        return PATTERN;
    }

    @Override
    public boolean isEnabled(Session session) {
        return SystemSessionProperties.isInPredicatesAsInnerJoinsEnabled(session) && SystemSessionProperties.isExploitConstraints(session) && SystemSessionProperties.getJoinReorderingStrategy(session) == FeaturesConfig.JoinReorderingStrategy.AUTOMATIC;
    }

    @Override
    public Rule.Result apply(AggregationNode aggregationNode, Captures captures, Rule.Context context) {
        JoinNode innerJoin = (JoinNode)captures.get(JOIN);
        if (!this.canAggregationBePushedDown(aggregationNode, innerJoin, context)) {
            return Rule.Result.empty();
        }
        EquiJoinClause equiJoinClause = (EquiJoinClause)Iterators.getOnlyElement(innerJoin.getCriteria().listIterator());
        VariableReferenceExpression sourceJoinVariable = equiJoinClause.getLeft();
        VariableReferenceExpression filteringSourceJoinVariable = equiJoinClause.getRight();
        VariableReferenceExpression semiJoinVariable = context.getVariableAllocator().newVariable("semijoinvariable", (Type)BooleanType.BOOLEAN, "eoj");
        SemiJoinNode semiJoinNode = new SemiJoinNode(innerJoin.getSourceLocation(), context.getIdAllocator().getNextId(), innerJoin.getLeft(), innerJoin.getRight(), sourceJoinVariable, filteringSourceJoinVariable, semiJoinVariable, Optional.empty(), Optional.empty(), Optional.empty(), (Map)ImmutableMap.of());
        FilterNode filterNode = new FilterNode(semiJoinNode.getSourceLocation(), context.getIdAllocator().getNextId(), (PlanNode)semiJoinNode, (RowExpression)semiJoinVariable);
        Assignments.Builder assignments = Assignments.builder();
        filterNode.getOutputVariables().stream().filter(variable -> !variable.equals((Object)semiJoinVariable)).forEach(variable -> assignments.put(variable, (RowExpression)variable));
        ProjectNode projectNode = new ProjectNode(filterNode.getSourceLocation(), context.getIdAllocator().getNextId(), (PlanNode)filterNode, assignments.build(), ProjectNode.Locality.LOCAL);
        AggregationNode newAggregationNode = new AggregationNode(aggregationNode.getSourceLocation(), context.getIdAllocator().getNextId(), (PlanNode)projectNode, aggregationNode.getAggregations(), aggregationNode.getGroupingSets(), aggregationNode.getPreGroupedVariables(), aggregationNode.getStep(), aggregationNode.getHashVariable(), aggregationNode.getGroupIdVariable(), aggregationNode.getAggregationId());
        return Rule.Result.ofPlanNode((PlanNode)newAggregationNode);
    }

    private boolean canAggregationBePushedDown(AggregationNode aggregationNode, JoinNode joinNode, Rule.Context context) {
        if (!context.getLogicalPropertiesProvider().isPresent()) {
            return false;
        }
        if (joinNode.isCrossJoin() || joinNode.getCriteria().size() != 1) {
            return false;
        }
        ImmutableSet groupingVariables = ImmutableSet.copyOf((Collection)aggregationNode.getGroupingKeys());
        ImmutableSet joinInputVariablesRight = ImmutableSet.copyOf((Collection)joinNode.getRight().getOutputVariables());
        ImmutableSet joinInputVariablesLeft = ImmutableSet.copyOf((Collection)joinNode.getLeft().getOutputVariables());
        ImmutableSet joinOutputVariables = ImmutableSet.copyOf((Collection)joinNode.getOutputVariables());
        LogicalProperties aggregationNodelogicalProperties = context.getLogicalPropertiesProvider().get().getAggregationProperties(aggregationNode);
        if (!aggregationNodelogicalProperties.canBeHomogenized((Set)joinInputVariablesRight, (Set)groupingVariables)) {
            return false;
        }
        return joinInputVariablesLeft.equals(joinOutputVariables);
    }
}

