/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.Session;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.expressions.RowExpressionRewriter;
import com.facebook.presto.expressions.RowExpressionTreeRewriter;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.function.FunctionMetadataManager;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.DeterminismEvaluator;
import com.facebook.presto.spi.relation.ExpressionOptimizer;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.sql.expressions.ExpressionOptimizerManager;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.RowExpressionRewriteRuleSet;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.relational.RowExpressionDeterminismEvaluator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Objects;

public class SimplifyRowExpressions
extends RowExpressionRewriteRuleSet {
    public SimplifyRowExpressions(Metadata metadata, ExpressionOptimizerManager expressionOptimizerManager) {
        super(new Rewriter(metadata, expressionOptimizerManager));
    }

    @VisibleForTesting
    public static RowExpression rewrite(RowExpression expression, Metadata metadata, Session session, ExpressionOptimizerManager expressionOptimizerManager) {
        return new Rewriter(metadata, expressionOptimizerManager).rewrite(expression, session);
    }

    private static class Rewriter
    implements RowExpressionRewriteRuleSet.PlanRowExpressionRewriter {
        private final ExpressionOptimizerManager expressionOptimizerManager;
        private final LogicalExpressionRewriter logicalExpressionRewriter;

        public Rewriter(Metadata metadata, ExpressionOptimizerManager expressionOptimizerManager) {
            Objects.requireNonNull(metadata, "metadata is null");
            Objects.requireNonNull(expressionOptimizerManager, "expressionOptimizerManager is null");
            this.expressionOptimizerManager = Objects.requireNonNull(expressionOptimizerManager, "expressionOptimizerManager is null");
            this.logicalExpressionRewriter = new LogicalExpressionRewriter(metadata.getFunctionAndTypeManager());
        }

        @Override
        public RowExpression rewrite(RowExpression expression, Rule.Context context) {
            return this.rewrite(expression, context.getSession());
        }

        private RowExpression rewrite(RowExpression expression, Session session) {
            RowExpression rewritten = RowExpressionTreeRewriter.rewriteWith((RowExpressionRewriter)this.logicalExpressionRewriter, (RowExpression)expression, (Object)true);
            return this.expressionOptimizerManager.getExpressionOptimizer(session.toConnectorSession()).optimize(rewritten, ExpressionOptimizer.Level.SERIALIZABLE, session.toConnectorSession());
        }
    }

    private static class LogicalExpressionRewriter
    extends RowExpressionRewriter<Boolean> {
        private final FunctionResolution functionResolution;
        private final LogicalRowExpressions logicalRowExpressions;

        public LogicalExpressionRewriter(FunctionAndTypeManager functionAndTypeManager) {
            Objects.requireNonNull(functionAndTypeManager, "functionManager is null");
            this.functionResolution = new FunctionResolution(functionAndTypeManager.getFunctionAndTypeResolver());
            this.logicalRowExpressions = new LogicalRowExpressions((DeterminismEvaluator)new RowExpressionDeterminismEvaluator(functionAndTypeManager), (StandardFunctionResolution)new FunctionResolution(functionAndTypeManager.getFunctionAndTypeResolver()), (FunctionMetadataManager)functionAndTypeManager);
        }

        public RowExpression rewriteCall(CallExpression node, Boolean isRoot, RowExpressionTreeRewriter<Boolean> treeRewriter) {
            if (this.functionResolution.isNotFunction(node.getFunctionHandle())) {
                Preconditions.checkState((boolean)BooleanType.BOOLEAN.equals((Object)node.getType()), (Object)"NOT must be boolean function");
                return this.rewriteBooleanExpression((RowExpression)node, isRoot);
            }
            if (isRoot.booleanValue()) {
                return treeRewriter.rewrite((RowExpression)node, (Object)false);
            }
            return null;
        }

        public RowExpression rewriteSpecialForm(SpecialFormExpression node, Boolean isRoot, RowExpressionTreeRewriter<Boolean> treeRewriter) {
            if (this.isConjunctiveDisjunctive(node.getForm())) {
                Preconditions.checkState((boolean)BooleanType.BOOLEAN.equals((Object)node.getType()), (Object)"AND/OR must be boolean function");
                return this.rewriteBooleanExpression((RowExpression)node, isRoot);
            }
            if (isRoot.booleanValue()) {
                return treeRewriter.rewrite((RowExpression)node, (Object)false);
            }
            return null;
        }

        private boolean isConjunctiveDisjunctive(SpecialFormExpression.Form form) {
            return form == SpecialFormExpression.Form.AND || form == SpecialFormExpression.Form.OR;
        }

        private RowExpression rewriteBooleanExpression(RowExpression expression, boolean isRoot) {
            if (isRoot) {
                return this.logicalRowExpressions.convertToConjunctiveNormalForm(expression);
            }
            return this.logicalRowExpressions.minimalNormalForm(expression);
        }
    }
}

